/*
 * Decompiled with CFR 0.152.
 */
package com.slprime.chromatictooltips.util;

import com.slprime.chromatictooltips.ChromaticTooltips;
import com.slprime.chromatictooltips.util.NumberFormat;
import com.slprime.chromatictooltips.util.TooltipFontContext;
import com.slprime.chromatictooltips.util.TooltipUtils;
import java.awt.Rectangle;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class TooltipRenderUtils {
    private static final Rectangle ICON_RECTANGLE = new Rectangle(0, 0, 16, 16);

    private TooltipRenderUtils() {
    }

    public static void gl2DRenderContext(Runnable callback) {
        boolean isLighting = GL11.glGetBoolean((int)2896);
        boolean isDepthTest = GL11.glGetBoolean((int)2929);
        boolean isAlphaTest = GL11.glGetBoolean((int)3008);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)2929);
        callback.run();
        if (isLighting) {
            GL11.glEnable((int)2896);
        }
        if (isDepthTest) {
            GL11.glEnable((int)2929);
        }
        if (!isAlphaTest) {
            GL11.glDisable((int)3008);
        }
    }

    public static void drawOverlayText(String text, Rectangle rect, float scale, int color, boolean shadow, Alignment alignment) {
        float screenScale = TooltipUtils.getScaledResolution().func_78325_e();
        double smallTextScale = Math.max(screenScale, Math.max(scale, 1.0f) * (TooltipFontContext.getFontRenderer().func_82883_a() ? 0.75f : 0.5f));
        TooltipRenderUtils.gl2DRenderContext(() -> {
            int width = TooltipFontContext.getStringWidth(text);
            float partW = (float)rect.width / 2.0f;
            float partH = (float)rect.height / 2.0f;
            double offsetX = Math.ceil((double)((float)rect.x + partW + partW * (float)alignment.x) - (double)((float)width / 2.0f * (float)(alignment.x + 1)) * smallTextScale);
            double offsetY = Math.ceil((double)((float)rect.y + partH + partH * (float)alignment.y) - (double)((float)TooltipFontContext.getFontRenderer().field_78288_b / 2.0f * (float)(alignment.y + 1)) * smallTextScale);
            GL11.glTranslated((double)offsetX, (double)offsetY, (double)0.0);
            GL11.glScaled((double)smallTextScale, (double)smallTextScale, (double)1.0);
            TooltipFontContext.drawString(text, 0, 0, color, shadow);
            GL11.glScaled((double)(1.0 / smallTextScale), (double)(1.0 / smallTextScale), (double)1.0);
            GL11.glTranslated((double)(-1.0 * offsetX), (double)(-1.0 * offsetY), (double)0.0);
        });
    }

    public static void drawItemStack(ItemStack stack, long stackAmount, boolean showOverlayInfo) {
        FontRenderer font = TooltipFontContext.getFontRenderer();
        RenderItem itemRender = TooltipUtils.getItemRenderer();
        TextureManager renderEngine = TooltipUtils.mc().func_110434_K();
        TooltipRenderUtils.drawIromIcon(() -> {
            itemRender.field_77023_b += 100.0f;
            itemRender.func_82406_b(font, renderEngine, stack, 0, 0);
            if (showOverlayInfo) {
                itemRender.func_94148_a(font, renderEngine, stack, 0, 0, "");
            }
            itemRender.field_77023_b -= 100.0f;
        }, stackAmount, false);
    }

    public static void drawFluidStack(FluidStack stack, long stackAmount) {
        Fluid fluid = stack.getFluid();
        IIcon fluidIcon = fluid.getIcon(stack);
        int fluidColor = fluid.getColor(stack);
        if (fluidIcon == null) {
            return;
        }
        TooltipRenderUtils.drawIromIcon(() -> {
            GL11.glEnable((int)3042);
            GL11.glEnable((int)3008);
            TooltipUtils.bindTexture(TextureMap.field_110575_b);
            float a = (float)(fluidColor >> 24 & 0xFF) / 255.0f;
            float r = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(fluidColor & 0xFF) / 255.0f;
            a = a == 0.0f ? 1.0f : a;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
            TooltipUtils.mc().field_71462_r.func_94065_a(0, 0, fluidIcon, 16, 16);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }, stackAmount, true);
    }

    protected static void drawIromIcon(Runnable drawIcon, long stackAmount, boolean fluid) {
        GL11.glPushAttrib((int)24640);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        try {
            drawIcon.run();
        }
        catch (Exception e) {
            ChromaticTooltips.LOG.error("renderStack Item/Fluid Stack Error", (Throwable)e);
        }
        if (stackAmount > 1L) {
            TooltipRenderUtils.drawStackSize(stackAmount, fluid);
        }
        GL11.glPopAttrib();
    }

    protected static void drawStackSize(long stackAmount, boolean isFluid) {
        String amountString = "";
        amountString = stackAmount < 10000L ? String.valueOf(stackAmount) : NumberFormat.SI.format(stackAmount);
        if (isFluid) {
            amountString = amountString + "L";
        }
        TooltipRenderUtils.drawOverlayText(amountString, ICON_RECTANGLE, 1.0f, 0xFFFFFF, true, isFluid ? Alignment.BottomLeft : Alignment.BottomRight);
    }

    public static enum Alignment {
        TopLeft(-1, -1),
        TopCenter(0, -1),
        TopRight(1, -1),
        CenterLeft(-1, 0),
        Center(0, 0),
        CenterRight(1, 0),
        BottomLeft(-1, 1),
        BottomCenter(0, 1),
        BottomRight(1, 1);

        public final int x;
        public final int y;

        private Alignment(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public float getX(float parentWidth, float childWidth) {
            float x = (float)(this.x + 1) / 2.0f;
            return parentWidth * x - childWidth * x;
        }

        public float getY(float parentHeight, float childHeight) {
            float y = (float)(this.y + 1) / 2.0f;
            return parentHeight * y - childHeight * y;
        }
    }
}

