/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import net.minecraftforge.eventbus.ListenerList;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.internal.Cache;
import org.jetbrains.annotations.ApiStatus;

public class EventListenerHelper {
    private static final Cache<Class<?>, ListenerList> listeners = Cache.create();
    private static final ListenerList EVENTS_LIST = new ListenerList();
    private static final Cache<Class<?>, Boolean> cancelable = Cache.create();
    private static final Cache<Class<?>, Boolean> hasResult = Cache.create();

    public static ListenerList getListenerList(Class<?> eventClass) {
        return EventListenerHelper.getListenerListInternal(eventClass, false);
    }

    static ListenerList getListenerListInternal(Class<?> eventClass, boolean fromInstanceCall) {
        if (eventClass == Event.class) {
            return EVENTS_LIST;
        }
        ListenerList ret = listeners.get(eventClass);
        if (ret != null) {
            return ret;
        }
        return listeners.computeIfAbsent(eventClass, k -> EventListenerHelper.computeListenerList(k, fromInstanceCall));
    }

    private static ListenerList computeListenerList(Class<?> eventClass, boolean fromInstanceCall) {
        if (eventClass == Event.class) {
            return EVENTS_LIST;
        }
        if (fromInstanceCall || Modifier.isAbstract(eventClass.getModifiers())) {
            Class<?> superclass = eventClass.getSuperclass();
            ListenerList parentList = EventListenerHelper.getListenerList(superclass);
            return new ListenerList(parentList);
        }
        try {
            Constructor<?> ctr = eventClass.getConstructor(new Class[0]);
            ctr.setAccessible(true);
            Event event = (Event)ctr.newInstance(new Object[0]);
            return event.getListenerList();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error computing listener list for " + eventClass.getName(), e);
        }
    }

    @ApiStatus.Internal
    public static boolean isCancelable(Class<?> eventClass) {
        return EventListenerHelper.hasAnnotation(eventClass, Cancelable.class, cancelable);
    }

    static boolean hasResult(Class<?> eventClass) {
        return EventListenerHelper.hasAnnotation(eventClass, Event.HasResult.class, hasResult);
    }

    private static boolean hasAnnotation(Class<?> eventClass, Class<? extends Annotation> annotation, Cache<Class<?>, Boolean> cache) {
        if (eventClass == Event.class || eventClass == Object.class) {
            return false;
        }
        Boolean ret = cache.get(eventClass);
        if (ret != null) {
            return ret;
        }
        return cache.computeIfAbsent(eventClass, k -> {
            if (k.isAnnotationPresent(annotation)) {
                return true;
            }
            Class parent = k.getSuperclass();
            return parent != null && EventListenerHelper.hasAnnotation(parent, annotation, cache);
        });
    }
}

