/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemTransforms {
    public static final ItemTransforms f_111786_ = new ItemTransforms();
    public final ItemTransform f_111787_;
    public final ItemTransform f_111788_;
    public final ItemTransform f_111789_;
    public final ItemTransform f_111790_;
    public final ItemTransform f_111791_;
    public final ItemTransform f_111792_;
    public final ItemTransform f_111793_;
    public final ItemTransform f_111794_;
    public final ImmutableMap<ItemDisplayContext, ItemTransform> moddedTransforms;

    private ItemTransforms() {
        this(ItemTransform.f_111754_, ItemTransform.f_111754_, ItemTransform.f_111754_, ItemTransform.f_111754_, ItemTransform.f_111754_, ItemTransform.f_111754_, ItemTransform.f_111754_, ItemTransform.f_111754_);
    }

    @Deprecated
    public ItemTransforms(ItemTransforms p_111807_) {
        this.f_111787_ = p_111807_.f_111787_;
        this.f_111788_ = p_111807_.f_111788_;
        this.f_111789_ = p_111807_.f_111789_;
        this.f_111790_ = p_111807_.f_111790_;
        this.f_111791_ = p_111807_.f_111791_;
        this.f_111792_ = p_111807_.f_111792_;
        this.f_111793_ = p_111807_.f_111793_;
        this.f_111794_ = p_111807_.f_111794_;
        this.moddedTransforms = p_111807_.moddedTransforms;
    }

    @Deprecated
    public ItemTransforms(ItemTransform p_111798_, ItemTransform p_111799_, ItemTransform p_111800_, ItemTransform p_111801_, ItemTransform p_111802_, ItemTransform p_111803_, ItemTransform p_111804_, ItemTransform p_111805_) {
        this(p_111798_, p_111799_, p_111800_, p_111801_, p_111802_, p_111803_, p_111804_, p_111805_, (ImmutableMap<ItemDisplayContext, ItemTransform>)ImmutableMap.of());
    }

    public ItemTransforms(ItemTransform p_111798_, ItemTransform p_111799_, ItemTransform p_111800_, ItemTransform p_111801_, ItemTransform p_111802_, ItemTransform p_111803_, ItemTransform p_111804_, ItemTransform p_111805_, ImmutableMap<ItemDisplayContext, ItemTransform> moddedTransforms) {
        this.f_111787_ = p_111798_;
        this.f_111788_ = p_111799_;
        this.f_111789_ = p_111800_;
        this.f_111790_ = p_111801_;
        this.f_111791_ = p_111802_;
        this.f_111792_ = p_111803_;
        this.f_111793_ = p_111804_;
        this.f_111794_ = p_111805_;
        this.moddedTransforms = moddedTransforms;
    }

    public ItemTransform m_269404_(ItemDisplayContext p_270619_) {
        ItemTransform itemtransform;
        switch (p_270619_) {
            case THIRD_PERSON_LEFT_HAND: {
                itemtransform = this.f_111787_;
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                itemtransform = this.f_111788_;
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                itemtransform = this.f_111789_;
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                itemtransform = this.f_111790_;
                break;
            }
            case HEAD: {
                itemtransform = this.f_111791_;
                break;
            }
            case GUI: {
                itemtransform = this.f_111792_;
                break;
            }
            case GROUND: {
                itemtransform = this.f_111793_;
                break;
            }
            case FIXED: {
                itemtransform = this.f_111794_;
                break;
            }
            default: {
                return (ItemTransform)this.moddedTransforms.getOrDefault((Object)p_270619_, (Object)ItemTransform.f_111754_);
            }
        }
        return itemtransform;
    }

    public boolean m_269504_(ItemDisplayContext p_270365_) {
        return this.m_269404_(p_270365_) != ItemTransform.f_111754_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<ItemTransforms> {
        public ItemTransforms deserialize(JsonElement p_111820_, Type p_111821_, JsonDeserializationContext p_111822_) throws JsonParseException {
            JsonObject jsonobject = p_111820_.getAsJsonObject();
            ItemTransform itemtransform = this.m_269518_(p_111822_, jsonobject, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND);
            ItemTransform itemtransform1 = this.m_269518_(p_111822_, jsonobject, ItemDisplayContext.THIRD_PERSON_LEFT_HAND);
            if (itemtransform1 == ItemTransform.f_111754_) {
                itemtransform1 = itemtransform;
            }
            ItemTransform itemtransform2 = this.m_269518_(p_111822_, jsonobject, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND);
            ItemTransform itemtransform3 = this.m_269518_(p_111822_, jsonobject, ItemDisplayContext.FIRST_PERSON_LEFT_HAND);
            if (itemtransform3 == ItemTransform.f_111754_) {
                itemtransform3 = itemtransform2;
            }
            ItemTransform itemtransform4 = this.m_269518_(p_111822_, jsonobject, ItemDisplayContext.HEAD);
            ItemTransform itemtransform5 = this.m_269518_(p_111822_, jsonobject, ItemDisplayContext.GUI);
            ItemTransform itemtransform6 = this.m_269518_(p_111822_, jsonobject, ItemDisplayContext.GROUND);
            ItemTransform itemtransform7 = this.m_269518_(p_111822_, jsonobject, ItemDisplayContext.FIXED);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ItemDisplayContext type : ItemDisplayContext.values()) {
                if (!type.isModded()) continue;
                ItemTransform transform = this.m_269518_(p_111822_, jsonobject, type);
                ItemDisplayContext fallbackType = type;
                while (transform == ItemTransform.f_111754_ && fallbackType.fallback() != null) {
                    fallbackType = fallbackType.fallback();
                    transform = this.m_269518_(p_111822_, jsonobject, fallbackType);
                }
                if (transform == ItemTransform.f_111754_) continue;
                builder.put((Object)type, (Object)transform);
            }
            return new ItemTransforms(itemtransform1, itemtransform, itemtransform3, itemtransform2, itemtransform4, itemtransform5, itemtransform6, itemtransform7, (ImmutableMap<ItemDisplayContext, ItemTransform>)builder.build());
        }

        private ItemTransform m_269518_(JsonDeserializationContext p_270385_, JsonObject p_270436_, ItemDisplayContext p_270100_) {
            String s = p_270100_.m_7912_();
            return p_270436_.has(s) ? (ItemTransform)p_270385_.deserialize(p_270436_.get(s), ItemTransform.class) : ItemTransform.f_111754_;
        }
    }
}

