/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryInternal;

public final class ItemDisplayContext
extends Enum<ItemDisplayContext>
implements StringRepresentable,
IExtensibleEnum {
    public static final /* enum */ ItemDisplayContext NONE = new ItemDisplayContext(0, "none");
    public static final /* enum */ ItemDisplayContext THIRD_PERSON_LEFT_HAND = new ItemDisplayContext(1, "thirdperson_lefthand");
    public static final /* enum */ ItemDisplayContext THIRD_PERSON_RIGHT_HAND = new ItemDisplayContext(2, "thirdperson_righthand");
    public static final /* enum */ ItemDisplayContext FIRST_PERSON_LEFT_HAND = new ItemDisplayContext(3, "firstperson_lefthand");
    public static final /* enum */ ItemDisplayContext FIRST_PERSON_RIGHT_HAND = new ItemDisplayContext(4, "firstperson_righthand");
    public static final /* enum */ ItemDisplayContext HEAD = new ItemDisplayContext(5, "head");
    public static final /* enum */ ItemDisplayContext GUI = new ItemDisplayContext(6, "gui");
    public static final /* enum */ ItemDisplayContext GROUND = new ItemDisplayContext(7, "ground");
    public static final /* enum */ ItemDisplayContext FIXED = new ItemDisplayContext(8, "fixed");
    public static final Codec<ItemDisplayContext> f_268458_;
    public static final IntFunction<ItemDisplayContext> f_268648_;
    private byte f_268735_;
    private final String f_268747_;
    private final boolean isModded;
    @Nullable
    private final ItemDisplayContext fallback;
    public static final IForgeRegistry.AddCallback<ItemDisplayContext> ADD_CALLBACK;
    private static final /* synthetic */ ItemDisplayContext[] $VALUES;

    public static ItemDisplayContext[] values() {
        return (ItemDisplayContext[])$VALUES.clone();
    }

    public static ItemDisplayContext valueOf(String p_270079_) {
        return Enum.valueOf(ItemDisplayContext.class, p_270079_);
    }

    private ItemDisplayContext(int p_270624_, String p_270851_) {
        this.f_268747_ = p_270851_;
        this.f_268735_ = (byte)p_270624_;
        this.isModded = false;
        this.fallback = null;
    }

    public String m_7912_() {
        return this.f_268747_;
    }

    public byte m_269462_() {
        return this.f_268735_;
    }

    public boolean m_269069_() {
        return this == FIRST_PERSON_LEFT_HAND || this == FIRST_PERSON_RIGHT_HAND;
    }

    private ItemDisplayContext(ResourceLocation serializeName, ItemDisplayContext fallback) {
        this.f_268735_ = 0;
        this.f_268747_ = Objects.requireNonNull(serializeName, "Modded ItemDisplayContexts must have a non-null serializeName").toString();
        this.isModded = true;
        this.fallback = fallback;
    }

    public boolean isModded() {
        return this.isModded;
    }

    @Nullable
    public ItemDisplayContext fallback() {
        return this.fallback;
    }

    public static ItemDisplayContext create(String keyName, ResourceLocation serializedName, @Nullable ItemDisplayContext fallback) {
        throw new IllegalStateException("Enum not extended!");
    }

    private static /* synthetic */ ItemDisplayContext[] m_269476_() {
        return new ItemDisplayContext[]{NONE, THIRD_PERSON_LEFT_HAND, THIRD_PERSON_RIGHT_HAND, FIRST_PERSON_LEFT_HAND, FIRST_PERSON_RIGHT_HAND, HEAD, GUI, GROUND, FIXED};
    }

    static {
        $VALUES = ItemDisplayContext.m_269476_();
        f_268458_ = ExtraCodecs.m_184415_(() -> ((IForgeRegistry)ForgeRegistries.DISPLAY_CONTEXTS.get()).getCodec());
        f_268648_ = id -> Objects.requireNonNullElse((ItemDisplayContext)((Object)((Object)((IForgeRegistryInternal)ForgeRegistries.DISPLAY_CONTEXTS.get()).getValue(id < 0 ? 127 + -id : id))), NONE);
        ADD_CALLBACK = (owner, stage, id, key, obj, oldObj) -> {
            obj.f_268735_ = id > 127 ? (byte)(-(id - 127)) : (byte)id;
        };
    }
}

