/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;

public class GLFWNativeOSMesa {
    protected GLFWNativeOSMesa() {
        throw new UnsupportedOperationException();
    }

    public static int nglfwGetOSMesaColorBuffer(long window, long width, long height, long format, long buffer) {
        long __functionAddress = Functions.GetOSMesaColorBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPPPPI((long)window, (long)width, (long)height, (long)format, (long)buffer, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean glfwGetOSMesaColorBuffer(@NativeType(value="GLFWwindow *") long window, @Nullable @NativeType(value="int *") IntBuffer width, @Nullable @NativeType(value="int *") IntBuffer height, @Nullable @NativeType(value="int *") IntBuffer format, @Nullable @NativeType(value="void **") PointerBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)width, (int)1);
            Checks.checkSafe((Buffer)height, (int)1);
            Checks.checkSafe((Buffer)format, (int)1);
            Checks.checkSafe((CustomBuffer)buffer, (int)1);
        }
        return GLFWNativeOSMesa.nglfwGetOSMesaColorBuffer(window, MemoryUtil.memAddressSafe((IntBuffer)width), MemoryUtil.memAddressSafe((IntBuffer)height), MemoryUtil.memAddressSafe((IntBuffer)format), MemoryUtil.memAddressSafe((Pointer)buffer)) != 0;
    }

    public static int nglfwGetOSMesaDepthBuffer(long window, long width, long height, long bytesPerValue, long buffer) {
        long __functionAddress = Functions.GetOSMesaDepthBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPPPPI((long)window, (long)width, (long)height, (long)bytesPerValue, (long)buffer, (long)__functionAddress);
    }

    public static int glfwGetOSMesaDepthBuffer(@NativeType(value="GLFWwindow *") long window, @Nullable @NativeType(value="int *") IntBuffer width, @Nullable @NativeType(value="int *") IntBuffer height, @Nullable @NativeType(value="int *") IntBuffer bytesPerValue, @Nullable @NativeType(value="void **") PointerBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)width, (int)1);
            Checks.checkSafe((Buffer)height, (int)1);
            Checks.checkSafe((Buffer)bytesPerValue, (int)1);
            Checks.checkSafe((CustomBuffer)buffer, (int)1);
        }
        return GLFWNativeOSMesa.nglfwGetOSMesaDepthBuffer(window, MemoryUtil.memAddressSafe((IntBuffer)width), MemoryUtil.memAddressSafe((IntBuffer)height), MemoryUtil.memAddressSafe((IntBuffer)bytesPerValue), MemoryUtil.memAddressSafe((Pointer)buffer));
    }

    @NativeType(value="OSMesaContext")
    public static long glfwGetOSMesaContext(@NativeType(value="GLFWwindow *") long window) {
        long __functionAddress = Functions.GetOSMesaContext;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean glfwGetOSMesaColorBuffer(@NativeType(value="GLFWwindow *") long window, @Nullable @NativeType(value="int *") int[] width, @Nullable @NativeType(value="int *") int[] height, @Nullable @NativeType(value="int *") int[] format, @Nullable @NativeType(value="void **") PointerBuffer buffer) {
        long __functionAddress = Functions.GetOSMesaColorBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)window);
            Checks.checkSafe((int[])width, (int)1);
            Checks.checkSafe((int[])height, (int)1);
            Checks.checkSafe((int[])format, (int)1);
            Checks.checkSafe((CustomBuffer)buffer, (int)1);
        }
        return JNI.invokePPPPPI((long)window, (int[])width, (int[])height, (int[])format, (long)MemoryUtil.memAddressSafe((Pointer)buffer), (long)__functionAddress) != 0;
    }

    public static int glfwGetOSMesaDepthBuffer(@NativeType(value="GLFWwindow *") long window, @Nullable @NativeType(value="int *") int[] width, @Nullable @NativeType(value="int *") int[] height, @Nullable @NativeType(value="int *") int[] bytesPerValue, @Nullable @NativeType(value="void **") PointerBuffer buffer) {
        long __functionAddress = Functions.GetOSMesaDepthBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)window);
            Checks.checkSafe((int[])width, (int)1);
            Checks.checkSafe((int[])height, (int)1);
            Checks.checkSafe((int[])bytesPerValue, (int)1);
            Checks.checkSafe((CustomBuffer)buffer, (int)1);
        }
        return JNI.invokePPPPPI((long)window, (int[])width, (int[])height, (int[])bytesPerValue, (long)MemoryUtil.memAddressSafe((Pointer)buffer), (long)__functionAddress);
    }

    public static void setPath(FunctionProvider sharedLibrary) {
        if (!(sharedLibrary instanceof SharedLibrary)) {
            APIUtil.apiLog((CharSequence)"GLFW OSMesa path override not set: Function provider is not a shared library.");
            return;
        }
        String path = ((SharedLibrary)sharedLibrary).getPath();
        if (path == null) {
            APIUtil.apiLog((CharSequence)"GLFW OSMesa path override not set: Could not resolve the OSMesa shared library path.");
            return;
        }
        GLFWNativeOSMesa.setPath(path);
    }

    public static void setPath(@Nullable String path) {
        long override = GLFW.getLibrary().getFunctionAddress((CharSequence)"_glfw_mesa_library");
        if (override == 0L) {
            APIUtil.apiLog((CharSequence)"GLFW OSMesa path override not set: Could not resolve override symbol.");
            return;
        }
        long a = MemoryUtil.memGetAddress((long)override);
        if (a != 0L) {
            MemoryUtil.nmemFree((long)a);
        }
        MemoryUtil.memPutAddress((long)override, (long)(path == null ? 0L : MemoryUtil.memAddress((ByteBuffer)MemoryUtil.memUTF8((CharSequence)path))));
    }

    public static final class Functions {
        public static final long GetOSMesaColorBuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetOSMesaColorBuffer");
        public static final long GetOSMesaDepthBuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetOSMesaDepthBuffer");
        public static final long GetOSMesaContext = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetOSMesaContext");

        private Functions() {
        }
    }
}

