/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap.asm;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import sun.misc.Unsafe;

public class UnsafeReflectionRedirector {
    private static final Class<?> fieldClass = Field.class;
    private static final Field fieldModifiers;
    private static final Set<Field> unlockedFields;
    private static final Unsafe unsafe;

    private static synchronized void unlockField(Field f) {
        unlockedFields.add(f);
    }

    private static synchronized boolean isFieldUnlocked(Field f) {
        return unlockedFields.contains(f);
    }

    public static Field getDeclaredField(Class<?> klass, String name) throws NoSuchFieldException, SecurityException {
        if (klass == fieldClass) {
            if ("modifiers".equals(name)) {
                return fieldModifiers;
            }
            throw new NoSuchFieldException(klass.getName() + "#" + name);
        }
        return klass.getDeclaredField(name);
    }

    public static Field[] getDeclaredFields(Class<?> klass) throws NoSuchFieldException, SecurityException {
        if (klass == fieldClass) {
            return new Field[]{fieldModifiers};
        }
        return klass.getDeclaredFields();
    }

    public static void setInt(Field field, Object target, int value) throws IllegalArgumentException, IllegalAccessException {
        if (field == fieldModifiers) {
            UnsafeReflectionRedirector.setModifiers(target, value);
            return;
        }
        field.setInt(target, value);
    }

    public static void setShort(Field field, Object target, short value) throws IllegalArgumentException, IllegalAccessException {
        if (field == fieldModifiers) {
            UnsafeReflectionRedirector.setModifiers(target, value);
            return;
        }
        field.setShort(target, value);
    }

    public static void setByte(Field field, Object target, byte value) throws IllegalArgumentException, IllegalAccessException {
        if (field == fieldModifiers) {
            UnsafeReflectionRedirector.setModifiers(target, value);
            return;
        }
        field.setByte(target, value);
    }

    public static void setChar(Field field, Object target, char value) throws IllegalArgumentException, IllegalAccessException {
        if (field == fieldModifiers) {
            UnsafeReflectionRedirector.setModifiers(target, value);
            return;
        }
        field.setChar(target, value);
    }

    public static int getInt(Field field, Object target) throws IllegalArgumentException, IllegalAccessException {
        if (field == fieldModifiers) {
            return UnsafeReflectionRedirector.getModifiers(target);
        }
        return field.getInt(target);
    }

    public static long getLong(Field field, Object target) throws IllegalArgumentException, IllegalAccessException {
        if (field == fieldModifiers) {
            return UnsafeReflectionRedirector.getModifiers(target);
        }
        return field.getLong(target);
    }

    public static float getFloat(Field field, Object target) throws IllegalArgumentException, IllegalAccessException {
        if (field == fieldModifiers) {
            return UnsafeReflectionRedirector.getModifiers(target);
        }
        return field.getFloat(target);
    }

    public static double getDouble(Field field, Object target) throws IllegalArgumentException, IllegalAccessException {
        if (field == fieldModifiers) {
            return UnsafeReflectionRedirector.getModifiers(target);
        }
        return field.getDouble(target);
    }

    public static void set(Field field, Object target, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (field == fieldModifiers && UnsafeReflectionRedirector.canCoerceToInt(value)) {
            UnsafeReflectionRedirector.setModifiers(target, UnsafeReflectionRedirector.coerceToInt(value));
            return;
        }
        if (UnsafeReflectionRedirector.isFieldUnlocked(field)) {
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalStateException("unsafe redirect of non-static field set");
            }
            if (!field.getType().isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Field " + field.getType() + " not assignable from " + value.getClass());
            }
            long staticOffset = unsafe.staticFieldOffset(field);
            Object staticObject = unsafe.staticFieldBase(field);
            unsafe.putObjectVolatile(staticObject, staticOffset, value);
        } else {
            if (target instanceof Dummy && value instanceof Field) {
                return;
            }
            field.set(target, value);
        }
    }

    public static Object get(Field field, Object target) throws IllegalArgumentException, IllegalAccessException {
        if (field == fieldModifiers) {
            return UnsafeReflectionRedirector.getModifiers(target);
        }
        return field.get(target);
    }

    private static int coerceToInt(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        throw new IllegalArgumentException("Passed non-integer-coerceable value to coerceToInt: " + obj);
    }

    private static boolean canCoerceToInt(Object obj) {
        return obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Character;
    }

    private static void setModifiers(Object target, int value) {
        Field targetF = (Field)target;
        int actualModifiers = targetF.getModifiers();
        if (Modifier.isStatic(actualModifiers) && Modifier.isFinal(actualModifiers)) {
            if ((value & 0x10) == 0) {
                UnsafeReflectionRedirector.unlockField(targetF);
            }
        } else {
            targetF.setAccessible(true);
        }
    }

    private static int getModifiers(Object target) {
        Field targetF = (Field)target;
        boolean isUnlocked = UnsafeReflectionRedirector.isFieldUnlocked(targetF);
        int modifiers = targetF.getModifiers();
        if (isUnlocked) {
            modifiers &= 0xFFFFFFEF;
        }
        return modifiers;
    }

    static {
        unlockedFields = Collections.newSetFromMap(new WeakHashMap());
        try {
            fieldModifiers = Dummy.class.getDeclaredField("modifiers");
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Dummy {
        private int modifiers;
    }
}

