/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.block.BlockMachineMeta;
import de.katzenpapst.amunra.block.SubBlockMachine;
import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.proxy.ARSidedProxy;
import de.katzenpapst.amunra.tile.TileEntityGravitation;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGravitation
extends SubBlockMachine {
    private final String backTexture;
    private final String sideTexture;
    private IIcon backIcon = null;
    private IIcon sideIcon = null;

    public BlockGravitation(String name, String frontInactiveTexture, String sideTexture, String backTexture) {
        super(name, frontInactiveTexture);
        this.backTexture = backTexture;
        this.sideTexture = sideTexture;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        super.func_149651_a(reg);
        this.backIcon = reg.func_94245_a(this.backTexture);
        this.sideIcon = reg.func_94245_a(this.sideTexture);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int realMeta = ((BlockMachineMeta)this.parent).getRotationMeta(meta);
        ForgeDirection front = CoordHelper.rotateForgeDirection(ForgeDirection.SOUTH, realMeta);
        ForgeDirection back = CoordHelper.rotateForgeDirection(ForgeDirection.NORTH, realMeta);
        if (side == front.ordinal()) {
            return this.field_149761_L;
        }
        if (side == back.ordinal()) {
            return this.backIcon;
        }
        return this.sideIcon;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityGravitation();
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        entityPlayer.openGui((Object)AmunRa.instance, 9, world, x, y, z);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World worldIn, int x, int y, int z, Random random) {
        TileEntityGravitation tile;
        boolean test = true;
        TileEntity tileEntity = worldIn.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityGravitation && (tile = (TileEntityGravitation)tileEntity).isRunning()) {
            for (int particleCount = 0; particleCount < 10; ++particleCount) {
                double x2 = (float)x + random.nextFloat();
                double y2 = (float)y + random.nextFloat();
                double z2 = (float)z + random.nextFloat();
                double mX = 0.0;
                double mZ = 0.0;
                int dir = random.nextInt(2) * 2 - 1;
                double mY = ((double)random.nextFloat() - 0.5) * 0.5;
                int var2 = worldIn.func_72805_g(x, y, z);
                if (var2 == 3 || var2 == 2) {
                    x2 = (double)x + 0.5 + 0.25 * (double)dir;
                    mX = random.nextFloat() * 2.0f * (float)dir;
                } else {
                    z2 = (double)z + 0.5 + 0.25 * (double)dir;
                    mZ = random.nextFloat() * 2.0f * (float)dir;
                }
                AmunRa.proxy.spawnParticles(ARSidedProxy.ParticleType.PT_GRAVITY_DUST, worldIn, new Vector3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), new Vector3(mX, tile.getGravityForce(), mZ));
            }
        }
    }
}

