/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.client.gui;

import cpw.mods.fml.common.eventhandler.Event;
import de.katzenpapst.amunra.client.gui.GuiShuttleSelection;
import de.katzenpapst.amunra.helper.ShuttleTeleportHelper;
import de.katzenpapst.amunra.mothership.Mothership;
import de.katzenpapst.amunra.mothership.MothershipWorldData;
import de.katzenpapst.amunra.tick.TickHandlerServer;
import de.katzenpapst.amunra.vec.BoxInt2D;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class GuiARCelestialSelection
extends GuiCelestialSelection {
    public static ResourceLocation guiExtra = new ResourceLocation("amunra", "textures/gui/celestialselection_extra.png");
    protected int numPlayersMotherships = -1;
    protected CelestialBody playerParent = null;
    protected CelestialBody lastSelectedBodyMS;
    protected CelestialBody nextSelectedBody = null;
    protected List<CelestialBody> shuttlePossibleBodies;
    protected boolean isMessageShown = false;
    protected String messageCaption = "";
    protected String messageText = "";
    protected BoxInt2D messageButtonBox = new BoxInt2D();

    public GuiARCelestialSelection(GuiCelestialSelection.MapMode mapMode, List<CelestialBody> possibleBodies) {
        super(mapMode, possibleBodies);
        this.shuttlePossibleBodies = possibleBodies;
    }

    public void setPossibleBodies(List<CelestialBody> possibleBodies) {
        this.possibleBodies = possibleBodies;
        this.shuttlePossibleBodies = possibleBodies;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        MothershipWorldData msData = TickHandlerServer.mothershipData;
        for (Mothership ms : msData.getMotherships().values()) {
            this.celestialBodyTicks.put(ms, 0);
        }
        this.updateNumPlayerMotherships();
        this.updatePlayerParent();
    }

    protected boolean isMouseWithin(int mouseX, int mouseY, int rectX, int rectY, int rectW, int rectH) {
        return mouseX >= rectX && mouseX <= rectX + rectW && mouseY >= rectY && mouseY <= rectY + rectH;
    }

    public void drawButtons(int mousePosX, int mousePosY) {
        super.drawButtons(mousePosX, mousePosY);
        if (this.isMessageShown) {
            this.drawMessageBox();
        }
    }

    protected void drawMessageBox() {
        GL11.glPushMatrix();
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(guiExtra);
        int boxWidth = 179;
        int boxHeight = 67;
        this.drawTexturedModalRect((this.field_146294_l - 179) / 2, (this.field_146295_m - 67) / 2, 179, 67, 0, 135, 179, 67, true, false);
        int btnOffset = 24;
        int btnWidth = 93;
        int btnHeight = 12;
        this.messageButtonBox.setPositionSize((this.field_146294_l - 93) / 2, (this.field_146295_m - 12) / 2 + 24, 93, 12);
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        this.drawTexturedModalRect(this.messageButtonBox.minX, this.messageButtonBox.minY, this.messageButtonBox.getWidth(), this.messageButtonBox.getHeight(), 0, 202, 93, 12, true, false);
        String str = this.messageCaption;
        this.field_146289_q.func_78276_b(str, (this.field_146294_l - this.field_146289_q.func_78256_a(str)) / 2, (this.field_146295_m - 67) / 2 + 3, -1);
        str = GCCoreUtil.translate((String)"gui.message.mothership.okay");
        this.field_146289_q.func_78276_b(str, (this.field_146294_l - this.field_146289_q.func_78256_a(str)) / 2, (this.field_146295_m - 12) / 2 + 2 + 24, -1);
        this.field_146289_q.func_78279_b(this.messageText, (this.field_146294_l - 179) / 2 + 4, (this.field_146295_m - 67) / 2 + 14, 171, -1);
        GL11.glPopMatrix();
    }

    protected void showTooltip(String text, int mousePosX, int mousePosY) {
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
        int stringWidth = this.smallFontRenderer.getStringWidth(text);
        int tooltipX = mousePosX - stringWidth / 2;
        int tooltipY = mousePosY - 12;
        int widhtOffsetOrSo = 8;
        if (tooltipX + stringWidth > this.field_146294_l) {
            tooltipX -= tooltipX - this.field_146294_l + stringWidth;
        }
        if (tooltipY + 8 + 6 > this.field_146295_m) {
            tooltipY = this.field_146295_m - 8 - 6;
        }
        int colorBG = -1107256833;
        this.func_73733_a(tooltipX - 3, tooltipY - 4, tooltipX + stringWidth + 3, tooltipY - 3, -1107256833, -1107256833);
        this.func_73733_a(tooltipX - 3, tooltipY + 8 + 3, tooltipX + stringWidth + 3, tooltipY + 8 + 4, -1107256833, -1107256833);
        this.func_73733_a(tooltipX - 3, tooltipY - 3, tooltipX + stringWidth + 3, tooltipY + 8 + 3, -1107256833, -1107256833);
        this.func_73733_a(tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + 8 + 3, -1107256833, -1107256833);
        this.func_73733_a(tooltipX + stringWidth + 3, tooltipY - 3, tooltipX + stringWidth + 4, tooltipY + 8 + 3, -1107256833, -1107256833);
        int colorBorderStart = -1442801153;
        int colorBorderEnd = -1442820993;
        this.func_73733_a(tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + 8 + 3 - 1, -1442801153, -1442820993);
        this.func_73733_a(tooltipX + stringWidth + 2, tooltipY - 3 + 1, tooltipX + stringWidth + 3, tooltipY + 8 + 3 - 1, -1442801153, -1442820993);
        this.func_73733_a(tooltipX - 3, tooltipY - 3, tooltipX + stringWidth + 3, tooltipY - 3 + 1, -1442801153, -1442801153);
        this.func_73733_a(tooltipX - 3, tooltipY + 8 + 2, tooltipX + stringWidth + 3, tooltipY + 8 + 3, -1442820993, -1442820993);
        this.smallFontRenderer.drawString(text, tooltipX, tooltipY, -1);
        GL11.glPopMatrix();
    }

    protected boolean isSiblingOf(CelestialBody celestialBody, Mothership ship) {
        if (celestialBody instanceof Planet) {
            SolarSystem solarSystem = ((Planet)celestialBody).getParentSolarSystem();
            return solarSystem.getMainStar().equals((Object)ship.getParent());
        }
        if (celestialBody instanceof IChildBody) {
            IChildBody childBody = (IChildBody)celestialBody;
            return childBody.getParentPlanet().equals((Object)ship.getParent());
        }
        if (celestialBody instanceof Mothership) {
            Mothership otherShip = (Mothership)celestialBody;
            return otherShip.getParent().equals((Object)ship.getParent());
        }
        return false;
    }

    protected List<Mothership> getMothershipListToRender() {
        LinkedList<Mothership> result = new LinkedList<Mothership>();
        if (this.selectedBody != null) {
            MothershipWorldData msData = TickHandlerServer.mothershipData;
            for (Mothership ms : msData.getMotherships().values()) {
                Mothership ship;
                CelestialBody celestialBody;
                if ((ms != this.selectedBody && (ms.getParent() != this.selectedBody || this.selectionCount == 1) || this.ticksSinceSelection <= 35 && this.selectedBody != ms && (!((celestialBody = this.lastSelectedBody) instanceof Mothership) || !(ship = (Mothership)celestialBody).getParent().equals((Object)ms))) && !this.isSiblingOf(this.selectedBody, ms)) continue;
                result.add(ms);
            }
        }
        return result;
    }

    protected CelestialBody getBodyToRenderMothershipsAround() {
        if (this.selectedBody instanceof Star || this.selectedBody instanceof Planet) {
            if (this.selectionCount != 1 && this.ticksSinceSelection > 35) {
                return this.selectedBody;
            }
            return null;
        }
        if (this.selectedBody instanceof IChildBody) {
            if (this.selectionCount != 1 && this.ticksSinceSelection > 35) {
                return this.selectedBody;
            }
        } else {
            CelestialBody celestialBody = this.selectedBody;
            if (celestialBody instanceof Mothership) {
                Mothership ship = (Mothership)celestialBody;
                return ship.getParent();
            }
        }
        return null;
    }

    protected void _workaroundDrawMoon(Matrix4f worldMatrix0, Moon moon, FloatBuffer fb, Map<CelestialBody, Matrix4f> matrixMap) {
        GL11.glPushMatrix();
        Matrix4f worldMatrix1 = new Matrix4f(worldMatrix0);
        Matrix4f.translate((Vector3f)this.getCelestialBodyPosition((CelestialBody)moon), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
        Matrix4f worldMatrix2 = new Matrix4f();
        Matrix4f.rotate((float)((float)Math.toRadians(45.0)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
        Matrix4f.rotate((float)((float)Math.toRadians(-55.0)), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
        Matrix4f.scale((Vector3f)new Vector3f(0.25f, 0.25f, 1.0f), (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
        worldMatrix2 = Matrix4f.mul((Matrix4f)worldMatrix1, (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
        fb.rewind();
        worldMatrix2.store(fb);
        fb.flip();
        GL11.glMultMatrix((FloatBuffer)fb);
        CelestialBodyRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.Pre((CelestialBody)moon, moon.getBodyIcon(), 8);
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (preEvent.celestialBodyTexture != null) {
            this.field_146297_k.field_71446_o.func_110577_a(preEvent.celestialBodyTexture);
        }
        if (!preEvent.isCanceled()) {
            int size = GuiARCelestialSelection.getWidthForCelestialBodyStatic((CelestialBody)moon);
            this.drawTexturedModalRect(-size / 2, -size / 2, size, size, 0.0f, 0.0f, preEvent.textureSize, preEvent.textureSize, false, false, preEvent.textureSize, preEvent.textureSize);
            matrixMap.put((CelestialBody)moon, worldMatrix1);
        }
        CelestialBodyRenderEvent.Post postEvent = new CelestialBodyRenderEvent.Post((CelestialBody)moon);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        fb.clear();
        GL11.glPopMatrix();
    }

    protected void _workaroundDrawMoonCircle(Moon moon, float sin, float cos) {
        float x = this.getScale((CelestialBody)moon);
        float y = 0.0f;
        float alpha = 1.0f;
        GL11.glPushMatrix();
        Vector3f planetPos = this.getCelestialBodyPosition((CelestialBody)moon.getParentPlanet());
        GL11.glTranslatef((float)planetPos.x, (float)planetPos.y, (float)0.0f);
        if (this.selectionCount >= 2) {
            float f = alpha = this.selectedBody instanceof IChildBody ? 1.0f : Math.min(Math.max((float)(this.ticksSinceSelection - 30) / 15.0f, 0.0f), 1.0f);
            if (this.lastSelectedBody instanceof Moon && GalaxyRegistry.getMoonsForPlanet((Planet)((Moon)this.lastSelectedBody).getParentPlanet()).contains(moon)) {
                alpha = 1.0f;
            }
        }
        if (alpha != 0.0f) {
            GL11.glColor4f((float)0.4f, (float)0.9f, (float)1.0f, (float)alpha);
            CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre((CelestialBody)moon, new Vector3f(0.0f, 0.0f, 0.0f));
            MinecraftForge.EVENT_BUS.post((Event)preEvent);
            if (!preEvent.isCanceled()) {
                GL11.glBegin((int)2);
                for (int i = 0; i < 90; ++i) {
                    GL11.glVertex2f((float)x, (float)y);
                    float temp = x;
                    x = cos * x - sin * y;
                    y = sin * temp + cos * y;
                }
                GL11.glEnd();
            }
            CelestialBodyRenderEvent.CelestialRingRenderEvent.Post postEvent = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Post((CelestialBody)moon);
            MinecraftForge.EVENT_BUS.post((Event)postEvent);
        }
        GL11.glPopMatrix();
    }

    public void drawCircles() {
        GL11.glPushMatrix();
        GL11.glLineWidth((float)3.0f);
        float theta = 0.06981317f;
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        CelestialBody body = this.getBodyToRenderMothershipsAround();
        if (body instanceof Moon) {
            Moon moon = (Moon)body;
            if (this.selectionCount >= 1) {
                this._workaroundDrawMoonCircle(moon, sin, cos);
            }
        }
        GL11.glColor4f((float)0.6f, (float)0.2f, (float)0.2f, (float)0.8f);
        if (body != null && TickHandlerServer.mothershipData.hasMothershipsInOrbit(body)) {
            float dist = TickHandlerServer.mothershipData.getMothershipOrbitDistanceFor(body);
            float scale = 3.0f * dist * 0.2f;
            if (body instanceof Star) {
                scale *= 3.0f;
            }
            Vector3f planetPos = this.getCelestialBodyPosition(body);
            GL11.glTranslatef((float)planetPos.x, (float)planetPos.y, (float)0.0f);
            float x = scale;
            float y = 0.0f;
            GL11.glBegin((int)2);
            for (int i = 0; i < 90; ++i) {
                GL11.glVertex2f((float)x, (float)y);
                float temp = x;
                x = cos * x - sin * y;
                y = sin * temp + cos * y;
            }
            GL11.glEnd();
        }
        GL11.glLineWidth((float)1.0f);
        GL11.glPopMatrix();
        super.drawCircles();
    }

    public HashMap<CelestialBody, Matrix4f> drawCelestialBodies(Matrix4f worldMatrix) {
        HashMap result = super.drawCelestialBodies(worldMatrix);
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)512);
        if (this.selectedBody != null) {
            Matrix4f worldMatrix0 = new Matrix4f(worldMatrix);
            CelestialBody renderShipsAround = this.getBodyToRenderMothershipsAround();
            if (renderShipsAround != null) {
                List<Mothership> msList = TickHandlerServer.mothershipData.getMothershipsForParent(renderShipsAround);
                if (this.selectionCount > 0 && renderShipsAround instanceof Moon && this.selectedBody instanceof Mothership) {
                    this._workaroundDrawMoon(worldMatrix0, (Moon)renderShipsAround, fb, result);
                }
                for (Mothership ms : msList) {
                    GL11.glPushMatrix();
                    Matrix4f worldMatrix1 = new Matrix4f(worldMatrix0);
                    Matrix4f.translate((Vector3f)this.getCelestialBodyPosition(ms), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
                    Matrix4f worldMatrix2 = new Matrix4f();
                    Matrix4f.rotate((float)((float)Math.toRadians(45.0)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
                    Matrix4f.rotate((float)((float)Math.toRadians(-55.0)), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
                    Matrix4f.scale((Vector3f)new Vector3f(0.25f, 0.25f, 1.0f), (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
                    worldMatrix2 = Matrix4f.mul((Matrix4f)worldMatrix1, (Matrix4f)worldMatrix2, (Matrix4f)worldMatrix2);
                    fb.rewind();
                    worldMatrix2.store(fb);
                    fb.flip();
                    GL11.glMultMatrix((FloatBuffer)fb);
                    CelestialBodyRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.Pre((CelestialBody)ms, ms.getBodyIcon(), 8);
                    MinecraftForge.EVENT_BUS.post((Event)preEvent);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (preEvent.celestialBodyTexture != null) {
                        this.field_146297_k.field_71446_o.func_110577_a(preEvent.celestialBodyTexture);
                    }
                    if (!preEvent.isCanceled()) {
                        int size = GuiARCelestialSelection.getWidthForMothershipStatic(ms);
                        this.drawTexturedModalRect(-size / 2, -size / 2, size, size, 0.0f, 0.0f, preEvent.textureSize, preEvent.textureSize, false, false, preEvent.textureSize, preEvent.textureSize);
                        result.put(ms, worldMatrix1);
                    }
                    CelestialBodyRenderEvent.Post postEvent = new CelestialBodyRenderEvent.Post((CelestialBody)ms);
                    MinecraftForge.EVENT_BUS.post((Event)postEvent);
                    fb.clear();
                    GL11.glPopMatrix();
                }
            }
        }
        return result;
    }

    public static int getWidthForMothershipStatic(Mothership celestialBody) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiShuttleSelection && (celestialBody != ((GuiShuttleSelection)Minecraft.func_71410_x().field_71462_r).selectedBody || ((GuiShuttleSelection)Minecraft.func_71410_x().field_71462_r).selectionCount != 1)) {
            return 4;
        }
        return 6;
    }

    public void mothershipListUpdated() {
        Iterator it = this.celestialBodyTicks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!(entry.getKey() instanceof Mothership)) continue;
            it.remove();
        }
        MothershipWorldData msData = TickHandlerServer.mothershipData;
        for (Mothership ms : msData.getMotherships().values()) {
            this.celestialBodyTicks.put(ms, 0);
        }
        this.updateNumPlayerMotherships();
    }

    public void mothershipCreationFailed() {
    }

    public void newMothershipCreated(Mothership ship) {
        this.celestialBodyTicks.put(ship, 0);
        this.shuttlePossibleBodies.add(ship);
        this.updateNumPlayerMotherships();
    }

    public void mothershipPositionChanged(Mothership ship) {
        if (ship.isInTransit()) {
            if (this.shuttlePossibleBodies.remove((Object)ship) && this.selectedBody.equals((Object)ship)) {
                this.unselectCelestialBody();
            }
        } else if (!this.shuttlePossibleBodies.contains((Object)ship)) {
            this.shuttlePossibleBodies.add(ship);
        }
    }

    protected Vector3f getCelestialBodyPosition(CelestialBody cBody) {
        if (cBody instanceof Mothership) {
            int cBodyTicks = 0;
            if (this.celestialBodyTicks.get(cBody) != null) {
                cBodyTicks = (Integer)this.celestialBodyTicks.get(cBody);
            }
            float timeScale = 2.0f;
            float distanceFromCenter = this.getScale(cBody);
            float orbitTime = 100.0f;
            CelestialBody msParent = ((Mothership)cBody).getParent();
            if (msParent instanceof Star) {
                distanceFromCenter *= 3.0f;
            }
            Vector3f cBodyPos = new Vector3f((float)Math.sin((float)cBodyTicks / 200.0f + cBody.getPhaseShift()) * distanceFromCenter, (float)Math.cos((float)cBodyTicks / 200.0f + cBody.getPhaseShift()) * distanceFromCenter, 0.0f);
            Vector3f parentVec = this.getCelestialBodyPosition(((Mothership)cBody).getParent());
            return Vector3f.add((Vector3f)cBodyPos, (Vector3f)parentVec, null);
        }
        return super.getCelestialBodyPosition(cBody);
    }

    protected void updatePlayerParent() {
        CelestialBody body = ShuttleTeleportHelper.getCelestialBodyForDimensionID(this.field_146297_k.field_71439_g.field_70170_p.field_73011_w.field_76574_g);
        if (body instanceof Mothership) {
            body = ((Mothership)body).getParent();
        }
        this.playerParent = body;
    }

    protected void updateNumPlayerMotherships() {
        this.numPlayersMotherships = TickHandlerServer.mothershipData.getNumMothershipsForPlayer((EntityPlayer)this.field_146297_k.field_71439_g);
    }

    protected Vector2f getTranslationAdvanced(float partialTicks) {
        if (this.selectedBody != null) {
            Mothership lastSelectedShip;
            CelestialBody result3;
            if (this.selectedBody instanceof Mothership) {
                CelestialBody parent = ((Mothership)this.selectedBody).getParent();
                if (parent instanceof IChildBody) {
                    Vector3f result2 = this.getCelestialBodyPosition((CelestialBody)((IChildBody)parent).getParentPlanet());
                    return new Vector2f(result2.x, result2.y);
                }
                Vector3f result3 = this.getCelestialBodyPosition(parent);
                return new Vector2f(result3.x, result3.y);
            }
            if (this.selectedBody instanceof Planet && (result3 = this.lastSelectedBody) instanceof Mothership && (lastSelectedShip = (Mothership)result3).getParent() == this.selectedBody) {
                Vector3f posVec = this.getCelestialBodyPosition(this.selectedBody);
                return new Vector2f(posVec.x, posVec.y);
            }
        }
        return super.getTranslationAdvanced(partialTicks);
    }

    public void selectAndZoom(CelestialBody target) {
        this.lastSelectedBody = this.selectedBody;
        this.selectedBody = target;
        this.selectionCount = this.lastSelectedBody instanceof IChildBody ? 1 : 2;
        this.preSelectZoom = this.zoom;
        this.preSelectPosition = this.position;
        this.ticksSinceSelection = 0;
    }

    public void selectAndZoomNextTick(CelestialBody target) {
        this.nextSelectedBody = target;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.isMessageShown) {
            if (this.messageButtonBox.isWithin(mouseX, mouseY)) {
                this.hideMessage();
            }
            return;
        }
        CelestialBody prevSelection = this.selectedBody;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (prevSelection instanceof Mothership && this.selectedBody != prevSelection) {
            this.selectionCount = prevSelection instanceof IChildBody ? 1 : 2;
            this.lastSelectedBody = prevSelection;
            this.preSelectZoom = this.zoom;
            this.preSelectPosition = this.position;
            this.ticksSinceSelection = 0;
            this.doneZooming = false;
        }
    }

    public void func_73876_c() {
        if (this.nextSelectedBody != null) {
            this.selectAndZoom(this.nextSelectedBody);
            this.nextSelectedBody = null;
        }
        super.func_73876_c();
    }

    public void showMessageBox(String caption, String text) {
        this.isMessageShown = true;
        this.messageCaption = caption;
        this.messageText = text;
    }

    public void hideMessage() {
        this.isMessageShown = false;
    }
}

