/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.client.gui;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.client.gui.GuiARCelestialSelection;
import de.katzenpapst.amunra.helper.AstronomyHelper;
import de.katzenpapst.amunra.helper.GuiHelper;
import de.katzenpapst.amunra.mothership.Mothership;
import de.katzenpapst.amunra.mothership.MothershipWorldProvider;
import de.katzenpapst.amunra.mothership.fueldisplay.MothershipFuelDisplay;
import de.katzenpapst.amunra.mothership.fueldisplay.MothershipFuelRequirements;
import de.katzenpapst.amunra.network.packet.PacketSimpleAR;
import de.katzenpapst.amunra.tile.TileEntityMothershipController;
import de.katzenpapst.amunra.vec.BlockVector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiMothershipSelection
extends GuiARCelestialSelection {
    protected BlockVector triggerBlock = null;
    protected Mothership curMothership;
    protected World world;
    protected MothershipWorldProvider provider;
    protected int offsetX;
    protected int offsetY;
    protected static final int LAUNCHBUTTON_X = -95;
    protected static final int LAUNCHBUTTON_Y = 133;
    protected static final int LAUNCHBUTTON_W = 93;
    protected static final int LAUNCHBUTTON_H = 12;
    protected static final int RENAMEBUTTON_X = -95;
    protected static final int RENAMEBUTTON_Y = 53;
    protected static final int RENAMEBUTTON_W = 93;
    protected static final int RENAMEBUTTON_H = 12;
    protected static final int TRANSIT_INFO_U = 0;
    protected static final int TRANSIT_INFO_V = 16;
    protected static final int TRANSIT_INFO_W = 179;
    protected static final int TRANSIT_INFO_H = 20;
    protected float ticksSinceLaunch = -1.0f;
    protected boolean hasMothershipStats = false;
    protected Map<CelestialBody, MothershipWorldProvider.TransitDataWithDuration> transitDataCache;

    public GuiMothershipSelection(List<CelestialBody> possibleBodies, TileEntityMothershipController title, World world) {
        super(GuiCelestialSelection.MapMode.VIEW, possibleBodies);
        this.world = world;
        this.provider = (MothershipWorldProvider)world.field_73011_w;
        this.curMothership = (Mothership)this.provider.getCelestialBody();
        this.transitDataCache = new HashMap<CelestialBody, MothershipWorldProvider.TransitDataWithDuration>();
    }

    @Override
    public void drawButtons(int mousePosX, int mousePosY) {
        this.possibleBodies = this.shuttlePossibleBodies;
        super.drawButtons(mousePosX, mousePosY);
        this.drawMothershipGuiParts(mousePosX, mousePosY);
    }

    public void mothershipUpdateRecieved() {
        this.hasMothershipStats = true;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.selectAndZoom(this.curMothership.getDestination());
        AmunRa.packetPipeline.sendToServer(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.S_MOTHERSHIP_UPDATE, this.world.field_73011_w.field_76574_g));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.ticksSinceLaunch >= 0.0f) {
            this.ticksSinceLaunch += partialTicks;
            if (this.ticksSinceLaunch > 1.0f) {
                this.ticksSinceLaunch = -1.0f;
            }
        }
    }

    protected void drawBodyOnGUI(CelestialBody body, int x, int y, int w, int h) {
        if (body == null) {
            return;
        }
        this.field_146297_k.field_71446_o.func_110577_a(body.getBodyIcon());
        this.drawFullSizedTexturedRect(x, y, w, h);
    }

    public void drawFullSizedTexturedRect(int x, int y, int width, int height) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), (double)this.field_73735_i, 0.0, 0.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, 1.0, 0.0);
        tessellator.func_78374_a((double)(x + width), (double)y, (double)this.field_73735_i, 1.0, 1.0);
        tessellator.func_78374_a((double)x, (double)y, (double)this.field_73735_i, 0.0, 1.0);
        tessellator.func_78381_a();
    }

    protected void drawTransitBar(int length) {
        this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 27, this.field_146295_m - 11 - GuiCelestialSelection.BORDER_WIDTH + 2, 1, 4, 0, 0, 1, 4, false, false);
        this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 28, this.field_146295_m - 11 - GuiCelestialSelection.BORDER_WIDTH + 2, length, 4, 1, 0, 43, 4, false, false);
        this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 28 + length, this.field_146295_m - 11 - GuiCelestialSelection.BORDER_WIDTH + 2, 1, 4, 56, 0, 1, 4, false, false);
    }

    protected void drawTransitInfo(int mousePosX, int mousePosY) {
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(guiExtra);
        this.drawTexturedModalRect(this.field_146294_l / 2 - 90, this.field_146295_m - 11 - GuiCelestialSelection.BORDER_WIDTH - 4, 179, 20, 0, 16, 179, 20, false, false);
        GL11.glColor4f((float)0.35f, (float)0.01f, (float)0.01f, (float)1.0f);
        this.drawTransitBar(124);
        GL11.glColor4f((float)0.95f, (float)0.01f, (float)0.01f, (float)1.0f);
        this.drawTransitBar(this.curMothership.getScaledTravelTime(124));
        if (this.isMouseWithin(mousePosX, mousePosY, this.field_146294_l / 2 - 90 + 28, this.field_146295_m - 11 - GuiCelestialSelection.BORDER_WIDTH + 2, 124, 4)) {
            this.showTooltip(GCCoreUtil.translateWithFormat((String)"gui.message.mothership.travelTimeRemain", (Object[])new Object[]{GuiHelper.formatTime(this.curMothership.getRemainingTravelTime())}), mousePosX, mousePosY);
        }
        int bodyX = this.field_146294_l / 2 - 90 + 14;
        int bodyY = this.field_146295_m - 11 - GuiCelestialSelection.BORDER_WIDTH;
        this.drawBodyOnGUI(this.curMothership.getSource(), bodyX, bodyY, 8, 8);
        if (this.isMouseWithin(mousePosX, mousePosY, bodyX, bodyY, 8, 8)) {
            this.showTooltip(this.curMothership.getSource().getLocalizedName(), mousePosX, mousePosY);
        }
        bodyX = this.field_146294_l / 2 + 90 - 14 - 8;
        bodyY = this.field_146295_m - 11 - GuiCelestialSelection.BORDER_WIDTH;
        this.drawBodyOnGUI(this.curMothership.getDestination(), bodyX, bodyY, 8, 8);
        if (this.isMouseWithin(mousePosX, mousePosY, bodyX, bodyY, 8, 8)) {
            this.showTooltip(this.curMothership.getDestination().getLocalizedName(), mousePosX, mousePosY);
        }
    }

    protected int getScaledTravelTime(Mothership ship, int barLength) {
        float remain = ship.getRemainingTravelTime();
        float total = ship.getTotalTravelTime();
        float relative = remain / total;
        float scaled = (1.0f - relative) * (float)barLength;
        return (int)scaled;
    }

    protected void drawMothershipGuiParts(int mousePosX, int mousePosY) {
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.offsetX = this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH;
        this.offsetY = GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH;
        if (this.curMothership.isInTransit()) {
            this.drawTransitInfo(mousePosX, mousePosY);
        }
        if (this.hasMothershipStats) {
            this.drawMothershipInfo();
        }
        if (this.selectedBody != null) {
            this.drawTargetBodyInfo(mousePosX, mousePosY);
        }
    }

    protected void drawMothershipInfo() {
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(guiExtra);
        int boxWidth = 95;
        int boxHeight = 65;
        int bottomOffset = this.field_146295_m - this.offsetY;
        float totalMass = this.provider.getTotalMass();
        MothershipWorldProvider.TransitData tData = this.provider.getTheoreticalTransitData();
        int totalOffset = 66;
        this.drawTexturedModalRect(this.offsetX - 95, bottomOffset - totalOffset, 95, 65, 0, 70, 95, 65, false, false);
        totalOffset = 53;
        this.drawSplitString(this.curMothership.getLocalizedName(), this.offsetX - 47 - 2, bottomOffset - totalOffset, 91, -1, false, false);
        this.smallFontRenderer.drawString(GCCoreUtil.translate((String)"gui.message.mothership.totalMass") + ": " + GuiHelper.formatKilogram(totalMass), this.offsetX - 90, bottomOffset - (totalOffset -= 10), -1, false);
        this.smallFontRenderer.drawString(GCCoreUtil.translate((String)"gui.message.mothership.totalBlocks") + ": " + GuiHelper.formatMetric(this.provider.getNumBlocks()), this.offsetX - 90, bottomOffset - (totalOffset -= 10), -1, false);
        int thrustColor = tData.thrust <= 0.0 ? -1 : -33154;
        this.smallFontRenderer.drawString(GCCoreUtil.translate((String)"gui.message.mothership.travelThrust") + ": " + GuiHelper.formatMetric(tData.thrust, "N"), this.offsetX - 90, bottomOffset - (totalOffset -= 10), thrustColor, false);
        if (this.curMothership.isInTransit()) {
            double distance = AstronomyHelper.getDistance(this.curMothership.getSource(), this.curMothership.getDestination());
            double speed = distance / (double)this.curMothership.getTotalTravelTime();
            this.smallFontRenderer.drawString(GCCoreUtil.translate((String)"gui.message.mothership.travelSpeed") + ": " + GuiHelper.formatSpeed(speed), this.offsetX - 90, bottomOffset - (totalOffset -= 10), thrustColor, false);
        }
    }

    protected void drawTargetBodyInfo(int mousePosX, int mousePosY) {
        int offset = 17;
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(guiExtra);
        MothershipWorldProvider.TransitDataWithDuration tData = this.getTransitDataFor(this.selectedBody);
        TravelFailReason failReason = this.getTravelFailReason(this.selectedBody, tData);
        if (failReason == TravelFailReason.NONE) {
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.1f, (float)1.0f);
        } else {
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.drawTexturedModalRect(this.offsetX + -95, this.offsetY + 133, 93, 12, 0, 4, 93, 12, false, false);
        this.drawSplitString(GCCoreUtil.translate((String)"gui.message.mothership.launchbutton").toUpperCase(), this.offsetX - 48, this.offsetY + 135, 91, -1, false, false);
        this.drawSplitString(this.selectedBody.getLocalizedName(), this.offsetX - 48, offset + this.offsetY, 91, -1, false, false);
        offset += 12;
        double travelDistance = this.curMothership.getTravelDistanceTo(this.selectedBody);
        long travelTime = !tData.isEmpty() ? tData.duration : -1L;
        switch (failReason) {
            case ALREADY_ORBITING: {
                this.smallFontRenderer.drawSplitString(GCCoreUtil.translate((String)"gui.message.mothership.alreadyOrbiting"), this.offsetX - 90, this.offsetY + offset, 90, -1);
                offset += 10;
                break;
            }
            case NONE: {
                offset = this.drawTravelDistance(offset, travelDistance);
                offset = this.drawTravelTime(offset, travelDistance, travelTime);
                offset = this.drawFuelReqs(offset, mousePosX, mousePosY, tData.fuelReqData);
                break;
            }
            case NOT_ENOUGH_FUEL: {
                offset = this.drawTravelDistance(offset, travelDistance);
                offset = this.drawTravelTime(offset, travelDistance, travelTime);
                offset = this.drawFuelReqs(offset, mousePosX, mousePosY, tData.fuelReqData);
                this.smallFontRenderer.drawSplitString(GCCoreUtil.translate((String)"gui.message.mothership.notEnoughFuel"), this.offsetX - 90, this.offsetY + offset, 90, -32640);
                offset += 10;
                break;
            }
            case NOT_ENOUGH_THRUST: {
                offset = this.drawTravelDistance(offset, travelDistance);
                offset = this.drawTravelTime(offset, travelDistance, travelTime);
                offset = this.drawFuelReqs(offset, mousePosX, mousePosY, tData.fuelReqData);
                this.smallFontRenderer.drawSplitString(GCCoreUtil.translate((String)"gui.message.mothership.notEnoughThrust"), this.offsetX - 90, this.offsetY + offset, 90, -32640);
                offset += 10;
                break;
            }
            case NOT_ORBITABLE: {
                this.smallFontRenderer.drawSplitString(GCCoreUtil.translate((String)"gui.message.mothership.unreachableBody"), this.offsetX - 90, this.offsetY + offset, 90, -32640);
                offset += 10;
                break;
            }
            case TRAVEL_TOO_LONG: {
                offset = this.drawTravelDistance(offset, travelDistance);
                offset = this.drawTravelTime(offset, travelDistance, travelTime);
                offset = this.drawFuelReqs(offset, mousePosX, mousePosY, tData.fuelReqData);
                this.smallFontRenderer.drawSplitString(GCCoreUtil.translate((String)"gui.message.mothership.travelTooLong"), this.offsetX - 90, this.offsetY + offset, 90, -32640);
                offset += 10;
                break;
            }
        }
    }

    protected int drawFuelReqs(int offset, int mousePosX, int mousePosY, MothershipFuelRequirements fuelReqs) {
        if (fuelReqs != null && !fuelReqs.isEmpty()) {
            this.smallFontRenderer.drawSplitString(GCCoreUtil.translate((String)"gui.message.mothership.fuelReqs") + ":", this.offsetX - 90, this.offsetY + offset, 90, -1);
            for (MothershipFuelDisplay f : fuelReqs.getData().keySet()) {
                this.drawIcon(this.offsetX - 90, this.offsetY + (offset += 10), f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.isMouseWithin(mousePosX, mousePosY, this.offsetX - 90, this.offsetY + offset, 10, 10)) {
                    this.showTooltip(f.getDisplayName(), mousePosX, mousePosY);
                }
                this.smallFontRenderer.drawSplitString(f.formatValue(fuelReqs.getData().get(f).intValue()), this.offsetX - 80, this.offsetY + offset, 90, -1);
            }
            offset += 10;
        }
        return offset;
    }

    protected int drawTravelDistance(int offset, double travelDistance) {
        this.smallFontRenderer.drawString(GCCoreUtil.translate((String)"gui.message.mothership.travelDistance") + ": " + GuiHelper.formatMetric(travelDistance, "AU"), this.offsetX - 90, this.offsetY + offset, -1, false);
        return offset += 10;
    }

    protected int drawTravelTime(int offset, double travelDistance, long travelTime) {
        String travelTimeStr = travelTime > 0L ? GuiHelper.formatTime(travelTime, true) : GCCoreUtil.translate((String)"gui.message.misc.n_a");
        this.smallFontRenderer.drawString(GCCoreUtil.translate((String)"gui.message.mothership.travelTime") + ": " + travelTimeStr, this.offsetX - 90, this.offsetY + offset, -1, false);
        return offset + 10;
    }

    protected void drawItemForFuel(int x, int y, ItemStack item) {
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        float factor = 0.5f;
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        GuiScreen.field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, item, (int)((float)x / 0.5f), (int)((float)y / 0.5f));
        RenderHelper.func_74518_a();
        GL11.glEnable((int)3042);
        GL11.glPopMatrix();
    }

    protected void drawIcon(int x, int y, MothershipFuelDisplay fuelType) {
        ResourceLocation resourcelocation = this.field_146297_k.field_71446_o.func_130087_a(fuelType.getSpriteNumber());
        this.field_146297_k.field_71446_o.func_110577_a(resourcelocation);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GuiScreen.field_146296_j.func_94149_a(x, y, fuelType.getIcon(), 8, 8);
    }

    protected MothershipWorldProvider.TransitDataWithDuration getTransitDataFor(CelestialBody body) {
        MothershipWorldProvider.TransitDataWithDuration result;
        if (!this.transitDataCache.containsKey(this.selectedBody)) {
            result = this.provider.getTransitDataTo(this.selectedBody);
            if (result.fuelReqData == null) {
                result.fuelReqData = this.provider.getPotentialFuelReqs(body);
            }
            this.transitDataCache.put(this.selectedBody, result);
        } else {
            result = this.transitDataCache.get(this.selectedBody);
        }
        return result;
    }

    protected TravelFailReason getTravelFailReason(CelestialBody body, MothershipWorldProvider.TransitDataWithDuration tData) {
        long travelTime;
        if (body == null || !Mothership.canBeOrbited(body)) {
            return TravelFailReason.NOT_ORBITABLE;
        }
        if (body == this.curMothership.getParent() || body == this.curMothership.getDestination()) {
            return TravelFailReason.ALREADY_ORBITING;
        }
        if (tData == null) {
            tData = this.getTransitDataFor(this.selectedBody);
        }
        if ((travelTime = tData.duration) > (long)AmunRa.config.mothershipMaxTravelTime) {
            return TravelFailReason.TRAVEL_TOO_LONG;
        }
        if (tData.isEmpty()) {
            return TravelFailReason.NOT_ENOUGH_FUEL;
        }
        return TravelFailReason.NONE;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        int actualBtnX = this.offsetX + -95;
        int actualBtnY = this.offsetY + 133;
        if (actualBtnX <= mouseX && mouseX <= actualBtnX + 93 && actualBtnY <= mouseY && mouseY <= actualBtnY + 12) {
            if (this.getTravelFailReason(this.selectedBody, null) == TravelFailReason.NONE) {
                if (this.ticksSinceLaunch > -1.0f) {
                    return;
                }
                this.ticksSinceLaunch = 0.0f;
                AmunRa.packetPipeline.sendToServer(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.S_MOTHERSHIP_TRANSIT_START, this.curMothership.getID(), AstronomyHelper.getOrbitableBodyName(this.selectedBody)));
            }
            return;
        }
        if (this.hasMothershipStats) {
            actualBtnX = this.offsetX + -95;
            actualBtnY = this.field_146295_m - this.offsetY - 53;
            if (actualBtnX <= mouseX && mouseX <= actualBtnX + 93 && actualBtnY <= mouseY && mouseY <= actualBtnY + 12) {
                return;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public static enum TravelFailReason {
        NONE,
        NOT_ENOUGH_FUEL,
        NOT_ENOUGH_THRUST,
        ALREADY_ORBITING,
        NOT_ORBITABLE,
        TRAVEL_TOO_LONG;

    }
}

