/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.client.gui.tabs;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.client.gui.GuiMothershipSettings;
import de.katzenpapst.amunra.client.gui.elements.DynamicTexturedButton;
import de.katzenpapst.amunra.client.gui.tabs.AbstractTab;
import de.katzenpapst.amunra.mothership.Mothership;
import de.katzenpapst.amunra.tile.TileEntityMothershipSettings;
import java.util.List;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementTextBox;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class TabMothershipCustom
extends AbstractTab
implements GuiElementTextBox.ITextBoxCallback,
GuiMothershipSettings.IMothershipSettingsTab {
    private static final ResourceLocation ICONTEXTURES = new ResourceLocation("amunra", "textures/gui/mothership_icons/0.png");
    private final Mothership ship;
    private GuiButton texturesPrev;
    private GuiButton texturesNext;
    private int texButtonOffset = 0;
    private GuiElementTextBox nameField;
    private final DynamicTexturedButton[] textureButtons = new DynamicTexturedButton[6];
    protected List<ResourceLocation> mothershipTextures;

    public TabMothershipCustom(TileEntityMothershipSettings tile, GuiMothershipSettings parent, Minecraft mc, int width, int height, int xSize, int ySize) {
        super(parent, mc, width, height, xSize, ySize);
        this.ship = tile.getMothership();
        this.mothershipTextures = AmunRa.instance.getPossibleMothershipTextures();
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float ticks) {
        for (DynamicTexturedButton btn : this.textureButtons) {
            if (btn == null) continue;
            if (btn.getTexture().equals((Object)this.ship.getBodyIcon())) {
                btn.setSelected(true);
                continue;
            }
            btn.setSelected(false);
        }
        super.drawScreen(mouseX, mouseY, ticks);
    }

    @Override
    protected void drawExtraScreenElements(int mouseX, int mouseY, float ticks) {
        int guiX = (this.width - this.xSize) / 2;
        int guiY = (this.height - this.ySize) / 2;
        this.fontRendererObj.func_78276_b(this.getTooltip(), guiX + 5, guiY + 5, 0x404040);
        this.fontRendererObj.func_78276_b(GCCoreUtil.translate((String)"container.inventory"), guiX + 8, guiY + this.ySize - 94, 0x404040);
    }

    @Override
    public void initGui() {
        this.buttonList.clear();
        int guiX = (this.width - this.xSize) / 2;
        int guiY = (this.height - this.ySize) / 2;
        this.nameField = new GuiElementTextBox(2, (GuiElementTextBox.ITextBoxCallback)this, guiX + 4, guiY + 4 + 20, 168, 20, "", false, 14, true);
        this.texturesPrev = new GuiButton(3, guiX + 6, guiY + 26 + 20, 20, 20, GCCoreUtil.translate((String)"<"));
        this.texturesNext = new GuiButton(4, guiX + 150, guiY + 26 + 20, 20, 20, GCCoreUtil.translate((String)">"));
        this.addTextBox(this.nameField);
        this.addButton(this.texturesPrev);
        this.addButton(this.texturesNext);
        this.initTextureButtons(5, guiX + 2, guiY + 20);
    }

    protected int initTextureButtons(int startId, int guiX, int guiY) {
        int curId = startId;
        for (int i = 0; i < this.textureButtons.length; ++i) {
            DynamicTexturedButton btn = new DynamicTexturedButton(curId, guiX + 6 + 20 + 20 * i, guiY + 26, 20, 20, null);
            ++curId;
            if (this.mothershipTextures.size() > i) {
                btn.setTexture(this.mothershipTextures.get(i));
            } else {
                btn.field_146124_l = false;
            }
            this.buttonList.add(btn);
            this.textureButtons[i] = btn;
        }
        return curId;
    }

    @Override
    public void mothershipResponsePacketRecieved() {
        this.resetData();
        this.setGuiEnabled(true);
    }

    protected boolean isValidName(String name) {
        return name != null && !name.trim().isEmpty();
    }

    public boolean canPlayerEdit(GuiElementTextBox textBox, EntityPlayer player) {
        return true;
    }

    public void onTextChanged(GuiElementTextBox textBox, String newText) {
        if (textBox.equals(this.nameField) && this.isValidName(newText) && !newText.equals(this.ship.getLocalizedName())) {
            this.ship.setLocalizedName(newText);
            ((GuiMothershipSettings)this.parent).sendMothershipSettingsPacket();
        }
    }

    public String getInitialText(GuiElementTextBox textBox) {
        if (textBox.equals(this.nameField)) {
            return this.ship.getLocalizedName();
        }
        return "";
    }

    public int getTextColor(GuiElementTextBox textBox) {
        return ColorUtil.to32BitColor((int)255, (int)20, (int)255, (int)20);
    }

    public void onIntruderInteraction(GuiElementTextBox textBox) {
    }

    public void setGuiEnabled(boolean set) {
        this.texturesPrev.field_146124_l = set;
        this.texturesNext.field_146124_l = set;
        for (DynamicTexturedButton btn : this.textureButtons) {
            btn.field_146124_l = set;
        }
        this.nameField.field_146124_l = set;
    }

    public void resetData() {
    }

    @Override
    public boolean actionPerformed(GuiButton btn) {
        if (btn.equals(this.texturesNext) && this.texButtonOffset + this.textureButtons.length < this.mothershipTextures.size()) {
            ++this.texButtonOffset;
            this.updateTextureButtons();
            return true;
        }
        if (btn.equals(this.texturesPrev) && this.texButtonOffset > 0) {
            --this.texButtonOffset;
            this.updateTextureButtons();
            return true;
        }
        for (DynamicTexturedButton texButton : this.textureButtons) {
            if (!btn.equals((Object)texButton)) continue;
            this.ship.setBodyIcon(texButton.getTexture());
            ((GuiMothershipSettings)this.parent).sendMothershipSettingsPacket();
            return true;
        }
        return false;
    }

    @Override
    public void onTabActivated() {
        this.resetData();
    }

    protected void updateTextureButtons() {
        for (int i = 0; i < this.textureButtons.length; ++i) {
            int textureOffset = i + this.texButtonOffset;
            if (textureOffset < 0 || textureOffset >= this.mothershipTextures.size()) {
                this.textureButtons[i].field_146124_l = false;
                continue;
            }
            this.textureButtons[i].field_146124_l = true;
            this.textureButtons[i].setTexture(this.mothershipTextures.get(textureOffset));
        }
    }

    @Override
    public String getTooltip() {
        return GCCoreUtil.translate((String)"tile.mothershipSettings.customize");
    }

    @Override
    public ResourceLocation getIcon() {
        return ICONTEXTURES;
    }

    @Override
    public void mothershipOperationFailed(String message) {
    }
}

