/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.item;

import de.katzenpapst.amunra.item.SubItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class SubItemFood
extends SubItem {
    public final int itemUseDuration = 32;
    private final int healAmount;
    private final float saturationModifier;
    protected boolean alwaysEdible = false;
    private int potionId;
    private int potionDuration;
    private int potionAmplifier;
    private float potionEffectProbability;

    public SubItemFood(String name, String assetName, int healAmount, float saturationModifier) {
        super(name, assetName);
        this.healAmount = healAmount;
        this.saturationModifier = saturationModifier;
    }

    public SubItemFood(String name, String assetName, String info, int healAmount, float saturationModifier) {
        super(name, assetName, info);
        this.healAmount = healAmount;
        this.saturationModifier = saturationModifier;
    }

    public ItemStack func_77654_b(ItemStack p_77654_1_, World p_77654_2_, EntityPlayer p_77654_3_) {
        --p_77654_1_.field_77994_a;
        p_77654_3_.func_71024_bL().func_75122_a(this.getHealAmount(p_77654_1_), this.getSaturationModifier(p_77654_1_));
        p_77654_2_.func_72956_a((Entity)p_77654_3_, "random.burp", 0.5f, p_77654_2_.field_73012_v.nextFloat() * 0.1f + 0.9f);
        this.onFoodEaten(p_77654_1_, p_77654_2_, p_77654_3_);
        return p_77654_1_;
    }

    protected void onFoodEaten(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K && this.potionId > 0 && world.field_73012_v.nextFloat() < this.potionEffectProbability) {
            player.func_70690_d(new PotionEffect(this.potionId, this.potionDuration * 20, this.potionAmplifier));
        }
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.eat;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer player) {
        if (player.func_71043_e(this.alwaysEdible)) {
            player.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        }
        return itemStackIn;
    }

    public int getHealAmount(ItemStack itemStack) {
        return this.healAmount;
    }

    public float getSaturationModifier(ItemStack itemStack) {
        return this.saturationModifier;
    }

    public SubItemFood setPotionEffect(int potionId, int duration, int amplifier, float probability) {
        this.potionId = potionId;
        this.potionDuration = duration;
        this.potionAmplifier = amplifier;
        this.potionEffectProbability = probability;
        return this;
    }

    public SubItemFood setAlwaysEdible() {
        this.alwaysEdible = true;
        return this;
    }
}

