/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.horus;

import de.katzenpapst.amunra.block.ARBlocks;
import de.katzenpapst.amunra.world.AmunraChunkProvider;
import de.katzenpapst.amunra.world.horus.HorusBiomeDecorator;
import de.katzenpapst.amunra.world.mapgen.pyramid.BossRoom;
import de.katzenpapst.amunra.world.mapgen.pyramid.ChestRoom;
import de.katzenpapst.amunra.world.mapgen.pyramid.PitRoom;
import de.katzenpapst.amunra.world.mapgen.pyramid.PyramidGenerator;
import de.katzenpapst.amunra.world.mapgen.pyramid.PyramidRoom;
import de.katzenpapst.amunra.world.mapgen.volcano.VolcanoGenerator;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class HorusChunkProvider
extends AmunraChunkProvider {
    protected final BlockMetaPair stoneBlock = new BlockMetaPair(Blocks.field_150343_Z, 0);
    protected PyramidGenerator pyramid = new PyramidGenerator();
    private final VolcanoGenerator volcanoGen;

    public HorusChunkProvider(World world, long seed, boolean mapFeaturesEnabled) {
        super(world, seed, mapFeaturesEnabled);
        this.pyramid.setFillMaterial(ARBlocks.blockBasaltBrick);
        this.pyramid.setFloorMaterial(ARBlocks.blockSmoothBasalt);
        this.pyramid.setWallMaterial(ARBlocks.blockObsidianBrick);
        this.pyramid.addComponentType(ChestRoom.class, 0.25f);
        this.pyramid.addComponentType(PitRoom.class, 0.25f);
        this.pyramid.addComponentType(PyramidRoom.class, 0.5f);
        this.pyramid.addMainRoomType(BossRoom.class, 1.0f);
        this.volcanoGen = new VolcanoGenerator(new BlockMetaPair(Blocks.field_150353_l, 0), this.stoneBlock, this.stoneBlock, 15, true);
        this.worldGenerators.add(this.volcanoGen);
        this.worldGenerators.add(this.pyramid);
    }

    protected BiomeDecoratorSpace getBiomeGenerator() {
        return new HorusBiomeDecorator();
    }

    protected int getSeaLevel() {
        return 64;
    }

    protected BlockMetaPair getGrassBlock() {
        return ARBlocks.blockObsidiSand;
    }

    protected BlockMetaPair getDirtBlock() {
        return ARBlocks.blockObsidiGravel;
    }

    protected BlockMetaPair getStoneBlock() {
        return this.stoneBlock;
    }

    public double getHeightModifier() {
        return 20.0;
    }

    public double getSmallFeatureHeightModifier() {
        return 40.0;
    }

    public double getMountainHeightModifier() {
        return 60.0;
    }

    public double getValleyHeightModifier() {
        return 60.0;
    }

    public void func_73153_a(IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
        super.func_73153_a(p_73153_1_, p_73153_2_, p_73153_3_);
        this.pyramid.populate((IChunkProvider)this, this.field_73230_p, p_73153_2_, p_73153_3_);
    }
}

