/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.seth;

import de.katzenpapst.amunra.block.ARBlocks;
import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.world.AmunraChunkProvider;
import de.katzenpapst.amunra.world.TerrainGenerator;
import de.katzenpapst.amunra.world.mapgen.CrystalFormation;
import de.katzenpapst.amunra.world.mapgen.volcano.VolcanoGenerator;
import de.katzenpapst.amunra.world.seth.SethBiomeDecorator;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class SethChunkProvider
extends AmunraChunkProvider {
    BlockMetaPair rockBlock = new BlockMetaPair(Blocks.field_150403_cj, 0);
    BlockMetaPair grassBlock = new BlockMetaPair(Blocks.field_150433_aE, 0);
    BlockMetaPair dirtBlock = new BlockMetaPair(Blocks.field_150432_aD, 0);
    BlockMetaPair waterBlock;
    BlockMetaPair floorGrassBlock;
    BlockMetaPair floorDirtBlock;
    BlockMetaPair floorStoneBlock = new BlockMetaPair(Blocks.field_150405_ch, 0);
    protected final int floorDirtWidth = 4;
    protected final int maxWaterHeight = 60;
    private final TerrainGenerator oceanFloorGen;
    protected VolcanoGenerator volcanoGen;
    protected CrystalFormation crystalGen;

    public SethChunkProvider(World world, long seed, boolean mapFeaturesEnabled) {
        super(world, seed, mapFeaturesEnabled);
        this.floorDirtBlock = new BlockMetaPair(Blocks.field_150435_aG, 0);
        this.floorGrassBlock = ARBlocks.blockUnderwaterGrass;
        this.waterBlock = new BlockMetaPair(Blocks.field_150355_j, 0);
        this.oceanFloorGen = new TerrainGenerator(this.field_73220_k, this.floorStoneBlock, this.waterBlock, 30.0f, 35.0f, 40.0, 10.0, 25.0, this.maxWaterHeight);
        this.volcanoGen = new VolcanoGenerator(this.waterBlock, this.rockBlock, this.dirtBlock, 60, false);
        this.crystalGen = new CrystalFormation(ARBlocks.blockGlowingCoral, this.waterBlock);
        this.monsters = new BiomeGenBase.SpawnListEntry[0];
        this.biomes = new BiomeGenBase[]{BiomeGenBase.field_76775_o};
        this.worldGenerators.add(this.volcanoGen);
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] idArray, byte[] metaArray) {
        super.generateTerrain(chunkX, chunkZ, idArray, metaArray);
        this.oceanFloorGen.generateTerrain(chunkX, chunkZ, idArray, metaArray);
    }

    public void func_147422_a(int chunkX, int chunkZ, Block[] arrayOfIDs, byte[] arrayOfMeta, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        super.func_147422_a(chunkX, chunkZ, arrayOfIDs, arrayOfMeta, par4ArrayOfBiomeGenBase);
        for (int curX = 0; curX < 16; ++curX) {
            for (int curZ = 0; curZ < 16; ++curZ) {
                int surfaceHeight = -1;
                for (int curY = this.maxWaterHeight - 1; curY > 0; --curY) {
                    int index = this.getIndex(curX, curY, curZ);
                    Block curBlockId = arrayOfIDs[index];
                    byte curMeta = arrayOfMeta[index];
                    if (curBlockId != this.floorStoneBlock.getBlock() || curMeta != this.floorStoneBlock.getMetadata()) continue;
                    if (surfaceHeight == -1) {
                        surfaceHeight = curY;
                        arrayOfIDs[index] = this.floorGrassBlock.getBlock();
                        arrayOfMeta[index] = this.floorGrassBlock.getMetadata();
                        continue;
                    }
                    if (surfaceHeight - curY >= this.floorDirtWidth) continue;
                    arrayOfIDs[index] = this.floorDirtBlock.getBlock();
                    arrayOfMeta[index] = this.floorDirtBlock.getMetadata();
                }
            }
        }
    }

    protected BiomeDecoratorSpace getBiomeGenerator() {
        return new SethBiomeDecorator();
    }

    protected int getSeaLevel() {
        return 120;
    }

    protected BlockMetaPair getGrassBlock() {
        return this.grassBlock;
    }

    protected BlockMetaPair getDirtBlock() {
        return this.dirtBlock;
    }

    protected BlockMetaPair getStoneBlock() {
        return this.rockBlock;
    }

    public double getHeightModifier() {
        return 40.0;
    }

    public double getSmallFeatureHeightModifier() {
        return 60.0;
    }

    public double getMountainHeightModifier() {
        return 70.0;
    }

    public double getValleyHeightModifier() {
        return 50.0;
    }

    @Override
    public void onPopulate(IChunkProvider provider, int cX, int cZ) {
        int numToGenerate = this.field_73220_k.nextInt(this.field_73220_k.nextInt(4) + 1);
        int curChunkMinX = CoordHelper.chunkToMinBlock(cX);
        int curChunkMinZ = CoordHelper.chunkToMinBlock(cZ);
        for (int i = 0; i < numToGenerate; ++i) {
            int curX = curChunkMinX + this.field_73220_k.nextInt(16) + 8;
            int curY = 35;
            int curZ = curChunkMinZ + this.field_73220_k.nextInt(16) + 8;
            this.crystalGen.func_76484_a(this.field_73230_p, this.field_73220_k, curX, 35, curZ);
        }
    }
}

