/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.client.render;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import gcewing.architecture.ArchitectureCraftClient;
import gcewing.architecture.client.render.ICustomRenderer;
import gcewing.architecture.client.render.target.RenderTargetWorld;
import gcewing.architecture.common.block.BlockArchitecture;
import gcewing.architecture.compat.BlockPos;
import gcewing.architecture.compat.EnumWorldBlockLayer;
import gcewing.architecture.compat.IBlockState;
import gcewing.architecture.compat.Trans3;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;

@ThreadSafeISBRH(perThread=false)
public class BlockRenderDispatcher
implements ISimpleBlockRenderingHandler {
    private final ArchitectureCraftClient client;
    public final int renderID;

    public BlockRenderDispatcher(ArchitectureCraftClient baseModClient) {
        this.client = baseModClient;
        this.renderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)this.renderID, (ISimpleBlockRenderingHandler)this);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks rb) {
        boolean result = false;
        BlockPos pos = new BlockPos(x, y, z);
        BlockArchitecture baseBlock = (BlockArchitecture)block;
        int meta = world.func_72805_g(x, y, z);
        IBlockState state = baseBlock.getStateFromMeta(meta);
        ICustomRenderer renderer = this.client.getCustomBlockRenderer(world, pos, state);
        if (renderer != null) {
            int pass = ForgeHooksClient.getWorldRenderPass();
            for (EnumWorldBlockLayer layer : ArchitectureCraftClient.passLayers[pass + 1]) {
                if (!baseBlock.canRenderInLayer(layer)) continue;
                RenderTargetWorld target = new RenderTargetWorld(world, pos, Tessellator.field_78398_a, rb.field_147840_d, false);
                Trans3 t = Trans3.blockCenter(pos);
                renderer.renderBlock(world, pos, state, target, layer, t);
                if (!target.end()) continue;
                result = true;
            }
        }
        return result;
    }

    public void renderInventoryBlock(Block block, int meta, int modelId, RenderBlocks renderer) {
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return this.renderID;
    }
}

