/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.common.shape;

import gcewing.architecture.common.shape.CornerWindow;
import gcewing.architecture.common.shape.FrameKind;
import gcewing.architecture.common.shape.Window;
import gcewing.architecture.common.tile.TileShape;
import gcewing.architecture.compat.Directions;
import gcewing.architecture.compat.Trans3;
import gcewing.architecture.compat.Vector3;
import gcewing.architecture.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;

public class PlainWindow
extends Window {
    public PlainWindow() {
        this.frameSides = new EnumFacing[]{Directions.F_DOWN, Directions.F_EAST, Directions.F_UP, Directions.F_WEST};
        this.frameAlways = new boolean[]{false, false, false, false};
        this.frameKinds = new FrameKind[]{FrameKind.Plain, FrameKind.Plain, FrameKind.None, FrameKind.None, FrameKind.Plain, FrameKind.Plain};
        this.frameOrientations = new EnumFacing[]{Directions.F_EAST, Directions.F_EAST, null, null, Directions.F_UP, Directions.F_UP};
        this.frameTrans = new Trans3[]{Trans3.ident, Trans3.ident.rotZ(90.0), Trans3.ident.rotZ(180.0), Trans3.ident.rotZ(270.0)};
    }

    @Override
    public boolean orientOnPlacement(EntityPlayer player, TileShape te, TileShape nte, EnumFacing face, Vector3 hit) {
        if (nte != null && !player.func_70093_af()) {
            EnumFacing nlf;
            FrameKind nfk;
            if (nte.shape.kind instanceof PlainWindow) {
                te.setSide(nte.side);
                te.setTurn(nte.turn);
                return true;
            }
            if (nte.shape.kind instanceof CornerWindow && (nfk = ((Window)nte.shape.kind).frameKindForLocalSide(nlf = nte.localFace(face))) == FrameKind.Plain) {
                EnumFacing lf = Utils.oppositeFacing(face);
                te.setSide(nte.side);
                switch (nlf) {
                    case SOUTH: {
                        te.setTurn(Utils.turnToFace(Directions.F_WEST, lf));
                        return true;
                    }
                    case WEST: {
                        te.setTurn(Utils.turnToFace(Directions.F_EAST, lf));
                        return true;
                    }
                }
            }
        }
        return super.orientOnPlacement(player, te, nte, face, hit);
    }
}

