/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.common.shape;

import gcewing.architecture.client.render.ITexture;
import gcewing.architecture.client.render.RenderRoof;
import gcewing.architecture.client.render.target.IRenderTarget;
import gcewing.architecture.common.shape.Profile;
import gcewing.architecture.common.shape.RoofProfile;
import gcewing.architecture.common.shape.Shape;
import gcewing.architecture.common.shape.ShapeKind;
import gcewing.architecture.common.tile.TileShape;
import gcewing.architecture.compat.Trans3;
import net.minecraft.util.EnumFacing;

public class Roof
extends ShapeKind {
    static final ThreadLocal<RenderRoof> renderRoof = ThreadLocal.withInitial(RenderRoof::new);

    @Override
    public boolean acceptsCladding() {
        return true;
    }

    @Override
    public boolean secondaryDefaultsToBase() {
        return true;
    }

    @Override
    public void renderShape(TileShape te, ITexture[] textures, IRenderTarget target, Trans3 t, boolean renderBase, boolean renderSecondary) {
        RenderRoof renderRoof = gcewing.architecture.common.shape.Roof.renderRoof.get();
        renderRoof.prepare(te, textures, t, target, renderBase, renderSecondary);
        renderRoof.render();
    }

    @Override
    public Object profileForLocalFace(Shape shape, EnumFacing face) {
        int dir = face.ordinal();
        switch (shape) {
            case RoofTile: 
            case RoofOverhang: {
                switch (dir) {
                    case 5: {
                        return RoofProfile.Left;
                    }
                    case 4: {
                        return RoofProfile.Right;
                    }
                }
                break;
            }
            case RoofOuterCorner: 
            case RoofOverhangOuterCorner: {
                switch (dir) {
                    case 3: {
                        return RoofProfile.Left;
                    }
                    case 4: {
                        return RoofProfile.Right;
                    }
                }
                break;
            }
            case RoofInnerCorner: 
            case RoofOverhangInnerCorner: {
                switch (dir) {
                    case 5: {
                        return RoofProfile.Left;
                    }
                    case 2: {
                        return RoofProfile.Right;
                    }
                }
                break;
            }
            case RoofRidge: 
            case RoofSmartRidge: 
            case RoofOverhangRidge: {
                return RoofProfile.Ridge;
            }
            case RoofValley: 
            case RoofSmartValley: 
            case RoofOverhangValley: {
                return RoofProfile.Valley;
            }
        }
        return RoofProfile.None;
    }

    static {
        Profile.declareOpposite((Object)RoofProfile.Left, (Object)RoofProfile.Right);
    }
}

