/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tuhljin.automagy.blocks.BlockRedcrystalLarge;
import tuhljin.automagy.lib.RedstoneCalc;
import tuhljin.automagy.tiles.TileEntityRedcrystal;

public class BlockRedcrystalAmp
extends BlockRedcrystalLarge {
    public static int SIGNAL_OUTPUT = 50;
    private final boolean ACCEPT_POWER_FROM_ATTACHED_DIRECTION = true;

    public BlockRedcrystalAmp(String name) {
        super(name);
    }

    @Override
    protected RedstoneCalc.PowerResult calculateRedstonePowerAt(World world, int x, int y, int z, int orientation) {
        RedstoneCalc.PowerResult result = RedstoneCalc.getRedstonePowerAt(world, x, y, z, orientation, true, orientation, true, 1, this.getRedstoneInputDirections((IBlockAccess)world, x, y, z));
        if (result != null && result.strength > 0) {
            return new RedstoneCalc.PowerResult(Math.max(result.strength, SIGNAL_OUTPUT), result.sourceDirection);
        }
        return null;
    }

    @Override
    public ForgeDirection[] getRedstoneInputDirections(IBlockAccess blockaccess, int x, int y, int z) {
        TileEntityRedcrystal te;
        try {
            te = (TileEntityRedcrystal)blockaccess.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            return null;
        }
        ArrayList<ForgeDirection> list = new ArrayList<ForgeDirection>();
        short orientation = te.orientation;
        switch (orientation) {
            case 2: {
                if (te.connectN) {
                    list.add(ForgeDirection.UP);
                }
                if (te.connectS) {
                    list.add(ForgeDirection.DOWN);
                }
                if (te.connectW) {
                    list.add(ForgeDirection.EAST);
                }
                if (!te.connectE) break;
                list.add(ForgeDirection.WEST);
                break;
            }
            case 3: {
                if (te.connectN) {
                    list.add(ForgeDirection.DOWN);
                }
                if (te.connectS) {
                    list.add(ForgeDirection.UP);
                }
                if (te.connectW) {
                    list.add(ForgeDirection.EAST);
                }
                if (!te.connectE) break;
                list.add(ForgeDirection.WEST);
                break;
            }
            case 4: {
                if (te.connectN) {
                    list.add(ForgeDirection.SOUTH);
                }
                if (te.connectS) {
                    list.add(ForgeDirection.NORTH);
                }
                if (te.connectW) {
                    list.add(ForgeDirection.UP);
                }
                if (!te.connectE) break;
                list.add(ForgeDirection.DOWN);
                break;
            }
            case 5: {
                if (te.connectN) {
                    list.add(ForgeDirection.SOUTH);
                }
                if (te.connectS) {
                    list.add(ForgeDirection.NORTH);
                }
                if (te.connectW) {
                    list.add(ForgeDirection.DOWN);
                }
                if (!te.connectE) break;
                list.add(ForgeDirection.UP);
                break;
            }
            default: {
                if (te.connectN) {
                    list.add(ForgeDirection.SOUTH);
                }
                if (te.connectS) {
                    list.add(ForgeDirection.NORTH);
                }
                if (te.connectW) {
                    list.add(ForgeDirection.EAST);
                }
                if (!te.connectE) break;
                list.add(ForgeDirection.WEST);
            }
        }
        list.add(ForgeDirection.getOrientation((int)orientation).getOpposite());
        return list.toArray(new ForgeDirection[list.size()]);
    }

    @Override
    public boolean canSendRedstoneSignalInDirection(IBlockAccess blockaccess, int x, int y, int z, int dir) {
        TileEntityRedcrystal te;
        try {
            te = (TileEntityRedcrystal)blockaccess.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            return false;
        }
        short orientation = te.orientation;
        switch (orientation) {
            case 0: 
            case 1: {
                switch (dir) {
                    case 2: {
                        return te.connectN;
                    }
                    case 3: {
                        return te.connectS;
                    }
                    case 4: {
                        return te.connectW;
                    }
                    case 5: {
                        return te.connectE;
                    }
                }
                break;
            }
            case 2: {
                switch (dir) {
                    case 0: {
                        return te.connectN;
                    }
                    case 1: {
                        return te.connectS;
                    }
                    case 4: {
                        return te.connectW;
                    }
                    case 5: {
                        return te.connectE;
                    }
                }
                break;
            }
            case 3: {
                switch (dir) {
                    case 0: {
                        return te.connectS;
                    }
                    case 1: {
                        return te.connectN;
                    }
                    case 4: {
                        return te.connectW;
                    }
                    case 5: {
                        return te.connectE;
                    }
                }
                break;
            }
            case 4: {
                switch (dir) {
                    case 0: {
                        return te.connectW;
                    }
                    case 1: {
                        return te.connectE;
                    }
                    case 2: {
                        return te.connectN;
                    }
                    case 3: {
                        return te.connectS;
                    }
                }
                break;
            }
            case 5: {
                switch (dir) {
                    case 0: {
                        return te.connectE;
                    }
                    case 1: {
                        return te.connectW;
                    }
                    case 2: {
                        return te.connectN;
                    }
                    case 3: {
                        return te.connectS;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        int opposite;
        if (!this.func_149744_f()) {
            return false;
        }
        switch (side) {
            case 0: {
                side = 2;
                opposite = 3;
                break;
            }
            case 1: {
                side = 5;
                opposite = 4;
                break;
            }
            case 2: {
                side = 3;
                opposite = 2;
                break;
            }
            case 3: {
                side = 4;
                opposite = 5;
                break;
            }
            default: {
                return false;
            }
        }
        return this.canSendRedstoneSignalInDirection(world, x, y, z, side) || this.canSendRedstoneSignalInDirection(world, x, y, z, opposite);
    }

    @Override
    public boolean allowNeighborToChangeConnection(World world, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean onBlockActivatedAdjustedSide(World world, int x, int y, int z, EntityPlayer player, int side) {
        TileEntityRedcrystal te = null;
        try {
            te = (TileEntityRedcrystal)world.func_147438_o(x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (te == null) {
            return false;
        }
        if (side != 2 && te.connectN) {
            this.toggleConnectionToDirection(world, x, y, z, 2, false);
        }
        if (side != 3 && te.connectS) {
            this.toggleConnectionToDirection(world, x, y, z, 3, false);
        }
        if (side != 4 && te.connectW) {
            this.toggleConnectionToDirection(world, x, y, z, 4, false);
        }
        if (side != 5 && te.connectE) {
            this.toggleConnectionToDirection(world, x, y, z, 5, false);
        }
        return super.onBlockActivatedAdjustedSide(world, x, y, z, player, side);
    }
}

