/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.gui;

import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.container.InventoryHandMirror;
import thaumcraft.common.items.relics.ItemHandMirror;
import tuhljin.automagy.Automagy;
import tuhljin.automagy.gui.SlotRestrictedWithReporting;
import tuhljin.automagy.items.ItemEnchantedPaper;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.inventory.IItemMap;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.network.MessageItemStacksList;
import tuhljin.automagy.network.MessageItemStacksRequested;
import tuhljin.automagy.tiles.IInventariumBook;
import tuhljin.automagy.tiles.IInventariumBookLinksMirror;
import tuhljin.automagy.tiles.IMirrorVariant;

public class ContainerScribe
extends Container {
    public IInventariumBook book;
    protected TileEntity te;
    protected IItemMap prevListLocal;
    protected IItemMap prevListInventarium;
    protected IItemMap prevListRequested;
    public static int XOFFSET_DEMAND = 30;
    protected final boolean hasLocalItems;
    protected final boolean hasDemand;
    private WorldSpecificCoordinates invCoord;
    private EntityPlayer player;
    private World worldObj;
    public IInventory mirror;
    private ItemStack fakeHandMirror;

    public ContainerScribe(InventoryPlayer inventoryPlayer, World world, IInventariumBook book, boolean hasLocalItems, boolean hasDemand) {
        int i;
        WorldSpecificCoordinates coord;
        IMirrorVariant mirror;
        this.book = book;
        this.hasLocalItems = hasLocalItems;
        this.hasDemand = hasDemand;
        if (book instanceof IInventariumBookLinksMirror && (mirror = ((IInventariumBookLinksMirror)book).getInputMirror()) != null && (coord = mirror.getDestinationMirrorCoordinates()) != null) {
            this.setMirrorOutputLocation(coord);
        }
        this.player = inventoryPlayer.field_70458_d;
        this.worldObj = world;
        if (book instanceof TileEntity) {
            this.te = (TileEntity)book;
        }
        if (book.isInventariumLoaded()) {
            this.invCoord = book.getLinkCoord();
            if (hasLocalItems) {
                this.prevListLocal = book.getLocalItemList();
            }
            this.prevListInventarium = book.getInventariumItemList();
            if (hasDemand) {
                this.prevListRequested = book.getInventariumRequestedItemList().copy();
            }
        }
        if (this.fakeHandMirror != null) {
            this.mirror = new InventoryHandMirror((Container)this);
            this.func_75146_a(new Slot(this.mirror, 0, 22, 169));
            this.func_75130_a(this.mirror);
        }
        int xOffset = hasDemand ? XOFFSET_DEMAND : 0;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18 + 16 + xOffset, 198));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, 9 + j + i * 9, 8 + j * 18 + 16 + xOffset, 84 + i * 18 + 56));
            }
        }
        if (this.fakeHandMirror != null) {
            this.func_75130_a(this.mirror);
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.book.isInventariumLoaded() && this.book.isUseableByPlayer(player);
    }

    public void func_75130_a(IInventory inv) {
        if (this.fakeHandMirror == null) {
            super.func_75130_a(inv);
            return;
        }
        if (!this.worldObj.field_72995_K && this.mirror.func_70301_a(0) != null && this.player != null && this.transport(this.mirror.func_70301_a(0))) {
            this.mirror.func_70299_a(0, null);
            for (int var4 = 0; var4 < this.field_75149_d.size(); ++var4) {
                ((ICrafting)this.field_75149_d.get(var4)).func_71111_a((Container)this, 0, null);
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNum) {
        if (this.fakeHandMirror == null) {
            return null;
        }
        ItemStack stack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotNum);
        if (slot != null) {
            if (slot instanceof SlotRestrictedWithReporting) {
                return super.func_82846_b(player, slotNum);
            }
            if (slot.func_75216_d()) {
                ItemStack stackInSlot = slot.func_75211_c();
                if (ItemEnchantedPaper.stackIsFilter(stackInSlot)) {
                    return super.func_82846_b(player, slotNum);
                }
                if (slotNum == 0 ? !this.func_75135_a(stackInSlot, 1, this.field_75151_b.size(), true) : !this.func_75135_a(stackInSlot, 0, 1, false)) {
                    return null;
                }
                if (stackInSlot.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
            }
        }
        return stack;
    }

    public void func_75142_b() {
        IItemMap itemList;
        ArrayList<ItemStack> list;
        super.func_75142_b();
        if (this.hasLocalItems && (list = ContainerScribe.getUpdatedItems(itemList = this.book.getLocalItemList(), this.prevListLocal)).size() > 0) {
            this.prevListLocal = itemList;
            for (Object player : this.field_75149_d) {
                if (!(player instanceof EntityPlayer)) continue;
                MessageItemStacksList.sendToClient((EntityPlayer)player, this.te.func_145831_w(), this.te.field_145851_c, this.te.field_145848_d, this.te.field_145849_e, list, true, true);
            }
        }
        if ((list = ContainerScribe.getUpdatedItems(itemList = this.book.getInventariumItemList(), this.prevListInventarium)).size() > 0) {
            this.prevListInventarium = itemList;
            for (Object player : this.field_75149_d) {
                if (!(player instanceof EntityPlayer)) continue;
                MessageItemStacksList.sendToClient((EntityPlayer)player, this.invCoord.dim, this.invCoord.x, this.invCoord.y, this.invCoord.z, list, true, false);
            }
        }
        if (this.hasDemand && (list = ContainerScribe.getUpdatedItems(itemList = this.book.getInventariumRequestedItemList(), this.prevListRequested)).size() > 0) {
            this.prevListRequested = itemList.copy();
            for (Object player : this.field_75149_d) {
                if (!(player instanceof EntityPlayer)) continue;
                MessageItemStacksRequested.sendToClient((EntityPlayer)player, this.invCoord.dim, this.invCoord.x, this.invCoord.y, this.invCoord.z, list, true);
            }
        }
    }

    public TileEntity getTile() {
        return this.te;
    }

    public boolean transport(ItemStack items) {
        if (this.fakeHandMirror == null) {
            return false;
        }
        return ItemHandMirror.transport((ItemStack)this.fakeHandMirror, (ItemStack)items, (EntityPlayer)this.player, (World)this.worldObj);
    }

    public void setMirrorOutputLocation(WorldSpecificCoordinates coord) {
        World world = Automagy.proxy.getWorldByID(coord.dim);
        if (world == null) {
            this.fakeHandMirror = null;
        } else {
            this.fakeHandMirror = new ItemStack(ConfigItems.itemHandMirror);
            this.fakeHandMirror.func_77983_a("linkX", (NBTBase)new NBTTagInt(coord.x));
            this.fakeHandMirror.func_77983_a("linkY", (NBTBase)new NBTTagInt(coord.y));
            this.fakeHandMirror.func_77983_a("linkZ", (NBTBase)new NBTTagInt(coord.z));
            this.fakeHandMirror.func_77983_a("linkDim", (NBTBase)new NBTTagInt(coord.dim));
            this.fakeHandMirror.func_77983_a("dimname", (NBTBase)new NBTTagString(world.field_73011_w.func_80007_l()));
        }
    }

    public void setMirrorOutputLocation(World world, int x, int y, int z) {
        this.fakeHandMirror = new ItemStack(ConfigItems.itemHandMirror);
        this.fakeHandMirror.func_77983_a("linkX", (NBTBase)new NBTTagInt(x));
        this.fakeHandMirror.func_77983_a("linkY", (NBTBase)new NBTTagInt(y));
        this.fakeHandMirror.func_77983_a("linkZ", (NBTBase)new NBTTagInt(z));
        this.fakeHandMirror.func_77983_a("linkDim", (NBTBase)new NBTTagInt(world.field_73011_w.field_76574_g));
        this.fakeHandMirror.func_77983_a("dimname", (NBTBase)new NBTTagString(DimensionManager.getProvider((int)world.field_73011_w.field_76574_g).func_80007_l()));
    }

    public boolean hasMirror() {
        return this.fakeHandMirror != null;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.worldObj.field_72995_K && this.mirror != null) {
            for (int i = 0; i < 1; ++i) {
                ItemStack stack = this.mirror.func_70304_b(i);
                if (stack == null) continue;
                player.func_71019_a(stack, false);
            }
        }
    }

    public boolean func_75140_a(EntityPlayer player, int button) {
        if (button == 0 && this.te != null) {
            int gui = 18;
            if (this.hasDemand && this.book instanceof IInventariumBookLinksMirror && ((IInventariumBookLinksMirror)this.book).isTrackingDestinations()) {
                gui = 19;
            }
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)Automagy.instance, (int)gui, (World)this.te.func_145831_w(), (int)this.te.field_145851_c, (int)this.te.field_145848_d, (int)this.te.field_145849_e);
            return true;
        }
        return false;
    }

    public static ArrayList<ItemStack> getUpdatedItems(IItemMap newList, IItemMap oldList) {
        HashableItemWithoutSize key;
        Map.Entry<HashableItemWithoutSize, Integer> entry;
        Iterator<Map.Entry<HashableItemWithoutSize, Integer>> iter;
        ArrayList<ItemStack> changed = new ArrayList<ItemStack>();
        if (newList != null) {
            iter = newList.getIterator();
            while (iter.hasNext()) {
                entry = iter.next();
                key = entry.getKey();
                int count = entry.getValue();
                if (oldList != null && oldList.get(key) == count) continue;
                changed.add(key.getItemStack(count));
            }
        }
        if (oldList != null) {
            iter = oldList.getIterator();
            while (iter.hasNext()) {
                entry = iter.next();
                key = entry.getKey();
                if (newList != null && newList.containsKey(key)) continue;
                changed.add(key.getItemStack(0));
            }
        }
        return changed;
    }
}

