/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.awt.Color;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.tiles.TileJar;
import thaumcraft.common.tiles.TileJarFillable;
import tuhljin.automagy.Automagy;
import tuhljin.automagy.blocks.BlockXPStone;
import tuhljin.automagy.lib.RedstoneCalc;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.tiles.IXPContainer;
import tuhljin.automagy.tiles.ModTileEntity;
import tuhljin.automagy.tiles.TileEntityAmnesiacStone;
import tuhljin.automagy.tiles.TileEntityJarXP;

public class TileEntityXPStone
extends ModTileEntity
implements IXPContainer {
    public static int MAX_XP = 2000;
    private static final ForgeDirection[] DIRS = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    private static int CHECK_FREQUENCY = 10;
    private static int MAX_TRANSFER_AMT = 10;
    private static int MAX_QUICK_DRAIN_AMT = MAX_XP;
    private static int DRIP_FREQUENCY = 75;
    private static int DRIP_AMOUNT = 10;
    protected int xp = 0;
    private int nextCheck = CHECK_FREQUENCY;
    private int nextDrip = DRIP_FREQUENCY;

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            --this.nextCheck;
            if (this.nextCheck < 1) {
                this.nextCheck = CHECK_FREQUENCY;
                for (ForgeDirection dir : DIRS) {
                    TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                    if (te == null || !(te instanceof TileEntityAmnesiacStone)) continue;
                    ((TileEntityAmnesiacStone)te).doXPTransfer(this, this.xp);
                }
            }
            --this.nextDrip;
            if (this.nextDrip < 1) {
                this.nextDrip = DRIP_FREQUENCY;
                if (this.xp > 0 && this.field_145848_d > 1) {
                    boolean needDrip = true;
                    for (int yOffset = 1; yOffset < 3; ++yOffset) {
                        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - yOffset, this.field_145849_e);
                        if (te != null) {
                            if (te instanceof TileEntityJarXP) {
                                this.dripXP((TileEntityJarXP)te);
                                needDrip = false;
                                break;
                            }
                            if (te instanceof TileJarFillable) {
                                TileEntityJarXP jar = TileEntityJarXP.transformWardedJar((TileJarFillable)te);
                                this.dripXP(jar);
                                needDrip = false;
                                break;
                            }
                        }
                        if (!(this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d - yOffset, this.field_145849_e) || yOffset == 1 && ThaumcraftExtension.blockIsItemGrate((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, true))) {
                            if (yOffset > 1 || this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - yOffset, this.field_145849_e) instanceof TileJar) {
                                this.dripXP(null);
                            }
                            needDrip = false;
                            break;
                        }
                        if (this.field_145848_d - yOffset < 1) break;
                    }
                    if (needDrip) {
                        this.dripXP(null);
                    }
                }
            }
        } else {
            --this.nextDrip;
            if (this.nextDrip < 1) {
                this.nextDrip = DRIP_FREQUENCY;
                if (this.xp > 0 && this.field_145848_d > 1) {
                    Integer i;
                    float y = 0.0f;
                    if (ThaumcraftExtension.blockIsItemGrate((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, true)) {
                        y = (float)this.field_145848_d - 0.2f;
                    } else if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) || this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileJar) {
                        y = (float)this.field_145848_d - 0.02f;
                    }
                    if (y > 0.0f && (i = ((BlockXPStone)this.func_145838_q()).getOverlayInvColor(this.func_145832_p())) != null) {
                        Color color = new Color(i);
                        float r = (float)color.getRed() / 255.0f;
                        float g = (float)color.getGreen() / 255.0f;
                        float b = (float)color.getBlue() / 255.0f;
                        Automagy.proxy.xpDropletFX(this.field_145850_b, (float)this.field_145851_c + 0.5f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.15f, y, (float)this.field_145849_e + 0.5f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.15f, r, g, b);
                    }
                }
            }
        }
    }

    public void dripXP(TileEntityJarXP jar) {
        int amt = Math.min(DRIP_AMOUNT, this.xp);
        this.xp -= amt;
        this.func_70296_d();
        if (jar != null) {
            jar.addXP(amt);
        }
    }

    public int drainXP(int amt) {
        if ((amt = Math.min(Math.min(amt, MAX_TRANSFER_AMT), this.xp)) < 1) {
            return 0;
        }
        this.xp -= amt;
        this.func_70296_d();
        return amt;
    }

    public int addXP(int amt) {
        if ((amt = Math.min(Math.min(amt, MAX_TRANSFER_AMT), MAX_XP - this.xp)) < 1) {
            return 0;
        }
        this.xp += amt;
        this.func_70296_d();
        return amt;
    }

    public int quickDrain() {
        if (this.xp == 0) {
            return 0;
        }
        int amt = Math.min(this.xp, MAX_QUICK_DRAIN_AMT);
        this.xp -= amt;
        this.func_70296_d();
        return amt;
    }

    @Override
    public int getXP() {
        return this.xp;
    }

    @Override
    public int getMaxXP() {
        return MAX_XP;
    }

    public float getXPFraction() {
        if (this.xp == 0) {
            return 0.0f;
        }
        return (float)this.xp / (float)MAX_XP;
    }

    public int getComparatorStrength() {
        return RedstoneCalc.getRedstoneSignalStrengthFromValues(this.xp, MAX_XP);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.xp = nbttagcompound.func_74762_e("xp");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("xp", this.xp);
    }
}

