/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.compat.forestry;

import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import fox.spiteful.avaritia.compat.forestry.AlleleFloat;
import fox.spiteful.avaritia.compat.forestry.AlleleInteger;
import net.minecraft.util.StatCollector;

public class Allele
implements IAllele {
    public static Allele grindySpeed;
    public static Allele grindyLife;
    private String name;
    private String id;
    private boolean dom;

    public static void prepareGenes() {
        grindySpeed = new AlleleFloat("speedNerfed", true, 0.1f);
        grindyLife = new AlleleInteger("lifespanArtificial", false, 75);
    }

    public Allele(String moniker, boolean dominant) {
        this.name = "avaritia.allele." + moniker;
        this.id = "avaritia." + moniker;
        this.dom = dominant;
        AlleleManager.alleleRegistry.registerAllele((IAllele)this);
    }

    public String getUID() {
        return this.id;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)this.name);
    }

    public String getUnlocalizedName() {
        return this.name;
    }

    public boolean isDominant() {
        return this.dom;
    }

    public static IAlleleBeeSpecies getBaseSpecies(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.species" + name);
    }

    public static IAlleleBeeSpecies getExtraSpecies(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("extrabees.species." + name.toLowerCase());
    }

    public static IAlleleBeeSpecies getMagicSpecies(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("magicbees.species" + name);
    }

    public static IAllele getBaseAllele(String name) {
        return AlleleManager.alleleRegistry.getAllele("forestry." + name);
    }
}

