/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.misc;

import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.misc.ProxyRect;
import javax.annotation.Nonnull;

public class GuiRectLerp
implements IGuiRect {
    private IGuiRect startRect;
    private IGuiRect targetRect;
    private long duration = 200L;
    private long et;
    private final ProxyRect pxRect;

    public GuiRectLerp(@Nonnull IGuiRect start) {
        this.startRect = start;
        this.targetRect = start;
        this.pxRect = new ProxyRect(start);
        this.et = System.currentTimeMillis();
    }

    public void lerpTo(@Nonnull IGuiRect target, long time) {
        if (time <= 0L) {
            return;
        }
        this.targetRect = target;
        this.duration = time;
        this.et = System.currentTimeMillis();
        this.pxRect.changeReference(target);
    }

    public void snapTo(@Nonnull IGuiRect target) {
        this.startRect = target;
        this.targetRect = target;
        this.et = System.currentTimeMillis();
        this.pxRect.changeReference(target);
    }

    public IGuiRect getProxyRect() {
        return this.pxRect;
    }

    public boolean isIdle() {
        if (this.startRect == this.targetRect) {
            return true;
        }
        if (System.currentTimeMillis() - this.et >= this.duration) {
            this.startRect = this.targetRect;
            return true;
        }
        return false;
    }

    @Override
    public int getX() {
        return this.isIdle() ? this.targetRect.getX() : (int)Math.round(RenderUtils.lerpDouble(this.startRect.getX(), this.targetRect.getX(), (double)(System.currentTimeMillis() - this.et) / (double)this.duration));
    }

    @Override
    public int getY() {
        return this.isIdle() ? this.targetRect.getY() : (int)Math.round(RenderUtils.lerpDouble(this.startRect.getY(), this.targetRect.getY(), (double)(System.currentTimeMillis() - this.et) / (double)this.duration));
    }

    @Override
    public int getWidth() {
        return this.isIdle() ? this.targetRect.getWidth() : (int)Math.round(RenderUtils.lerpDouble(this.startRect.getWidth(), this.targetRect.getWidth(), (double)(System.currentTimeMillis() - this.et) / (double)this.duration));
    }

    @Override
    public int getHeight() {
        return this.isIdle() ? this.targetRect.getHeight() : (int)Math.round(RenderUtils.lerpDouble(this.startRect.getHeight(), this.targetRect.getHeight(), (double)(System.currentTimeMillis() - this.et) / (double)this.duration));
    }

    @Override
    public int getDepth() {
        return this.targetRect.getDepth();
    }

    @Override
    public IGuiRect getParent() {
        return this.targetRect.getParent();
    }

    @Override
    public void setParent(IGuiRect rect) {
        this.targetRect.setParent(rect);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.targetRect.contains(x, y);
    }

    @Override
    public int compareTo(@Nonnull IGuiRect o) {
        return this.targetRect.compareTo(o);
    }
}

