/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.registry;

import betterquesting.api2.registry.IFactory;
import betterquesting.api2.registry.IRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class SimpleRegistry<T extends IFactory<E>, E>
implements IRegistry<T, E> {
    private final HashMap<ResourceLocation, T> factories = new HashMap();

    @Override
    public void register(T factory) {
        if (factory == null || factory.getRegistryName() == null) {
            throw new NullPointerException("Factory or registry name is null!");
        }
        if (this.factories.containsKey(factory.getRegistryName()) || this.factories.containsValue(factory)) {
            throw new IllegalArgumentException("Cannot register duplicate factory or registry name");
        }
        this.factories.put(factory.getRegistryName(), factory);
    }

    @Override
    @Nullable
    public T getFactory(ResourceLocation idName) {
        return (T)((IFactory)this.factories.get(idName));
    }

    @Override
    @Nullable
    public E createNew(ResourceLocation idName) {
        T fact = this.getFactory(idName);
        return fact == null ? null : (E)fact.createNew();
    }

    @Override
    public List<T> getAll() {
        return new ArrayList<T>(this.factories.values());
    }
}

