/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2;

import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestSearch;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.GuiHome;
import betterquesting.client.gui2.GuiQuest;
import betterquesting.misc.QuestSearchEntry;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class GuiQuestSearch
extends GuiScreenCanvas {
    private String prevSearch;
    private Consumer<QuestSearchEntry> callback;

    public GuiQuestSearch(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void initPanel() {
        super.initPanel();
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        CanvasEmpty cvInner = new CanvasEmpty(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(8, 8, 8, 8), 0));
        cvBackground.addPanel(cvInner);
        this.createExitButton(cvInner);
        PanelTextBox txtDb = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -16), 0), QuestTranslation.translate("betterquesting.gui.search", new Object[0])).setAlignment(1).setColor(PresetColor.TEXT_MAIN.getColor());
        cvInner.addPanel(txtDb);
        this.createSearchBox(cvInner);
    }

    private void createExitButton(CanvasEmpty cvInner) {
        PanelButton btnExit = new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0]));
        btnExit.setClickAction(b -> this.field_146297_k.func_147108_a(this.parent));
        cvInner.addPanel(btnExit);
    }

    private void createSearchBox(CanvasEmpty cvInner) {
        PanelTextField<String> searchBox = new PanelTextField<String>(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 8, -32), 0), "", FieldFilterString.INSTANCE);
        searchBox.setWatermark("Search...");
        searchBox.lockFocus(true);
        searchBox.enableClearingOnRightClick(true);
        cvInner.addPanel(searchBox);
        CanvasQuestSearch canvasQuestSearch = this.createSearchCanvas();
        cvInner.addPanel(canvasQuestSearch);
        searchBox.setCallback((T searchText) -> {
            this.prevSearch = searchText;
            canvasQuestSearch.setSearchFilter((String)searchText);
        });
        PanelVScrollBar scDb = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 32, 0, 24), 0));
        cvInner.addPanel(scDb);
        canvasQuestSearch.setScrollDriverY(scDb);
        if (this.prevSearch != null) {
            searchBox.setText(this.prevSearch);
            searchBox.setCursorPosition(Integer.MAX_VALUE);
            canvasQuestSearch.setSearchFilter(this.prevSearch);
        }
    }

    private CanvasQuestSearch createSearchCanvas() {
        CanvasQuestSearch canvasQuestSearch = new CanvasQuestSearch((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 32, 8, 24), 0), (EntityPlayer)this.field_146297_k.field_71439_g);
        canvasQuestSearch.setQuestOpenCallback(questSearchEntry -> {
            this.acceptCallback((QuestSearchEntry)questSearchEntry);
            GuiHome.bookmark = new GuiQuest(this.parent, questSearchEntry.getQuest().getKey());
            this.field_146297_k.func_147108_a(GuiHome.bookmark);
        });
        canvasQuestSearch.setQuestHighlightCallback(questSearchEntry -> {
            this.field_146297_k.func_147108_a(this.parent);
            this.acceptCallback((QuestSearchEntry)questSearchEntry);
        });
        return canvasQuestSearch;
    }

    public void setCallback(Consumer<QuestSearchEntry> callback) {
        this.callback = callback;
    }

    private void acceptCallback(QuestSearchEntry questSearchEntry) {
        if (this.callback != null) {
            this.callback.accept(questSearchEntry);
        }
    }
}

