/*
 * Decompiled with CFR 0.152.
 */
package bq_standard;

import betterquesting.api2.storage.INBTPartial;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ScoreBQ
implements INBTPartial<NBTTagList, UUID> {
    private final TreeMap<UUID, Integer> playerScores = new TreeMap();

    public synchronized int getScore(@Nonnull UUID uuid) {
        Integer value = this.playerScores.get(uuid);
        return value == null ? 0 : value;
    }

    public synchronized void setScore(@Nonnull UUID uuid, int value) {
        this.playerScores.put(uuid, value);
    }

    public synchronized boolean hasEntry(@Nonnull UUID uuid) {
        return this.playerScores.containsKey(uuid);
    }

    @Override
    public synchronized NBTTagList writeToNBT(NBTTagList nbt, @Nullable List<UUID> subset) {
        for (Map.Entry<UUID, Integer> entry : this.playerScores.entrySet()) {
            if (subset != null && !subset.contains(entry.getKey())) continue;
            NBTTagCompound jObj = new NBTTagCompound();
            jObj.func_74778_a("uuid", entry.getKey().toString());
            jObj.func_74768_a("value", entry.getValue().intValue());
            nbt.func_74742_a((NBTBase)jObj);
        }
        return nbt;
    }

    @Override
    public synchronized void readFromNBT(NBTTagList nbt, boolean merge) {
        if (!merge) {
            this.playerScores.clear();
        }
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            try {
                NBTTagCompound tag = nbt.func_150305_b(i);
                this.playerScores.put(UUID.fromString(tag.func_74779_i("uuid")), tag.func_74762_e("value"));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

