/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.network.handlers;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.api2.utils.Tuple2;
import bq_standard.tasks.TaskCheckbox;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import drethic.questbook.config.QBConfig;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class NetTaskCheckbox {
    private static final ResourceLocation ID_NAME = new ResourceLocation("bq_standard:task_checkbox");

    public static void registerHandler() {
        QuestingAPI.getAPI(ApiReference.PACKET_REG).registerServerHandler(ID_NAME, NetTaskCheckbox::onServer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestClick(UUID questID, int taskID) {
        NBTTagCompound payload = NBTConverter.UuidValueType.QUEST.writeId(questID);
        payload.func_74768_a("taskID", taskID);
        QuestingAPI.getAPI(ApiReference.PACKET_SENDER).sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        int tId;
        NBTTagCompound data = message.func_76341_a();
        EntityPlayerMP sender = message.func_76340_b();
        Optional<UUID> qId = NBTConverter.UuidValueType.QUEST.tryReadId(data);
        int n = tId = !data.func_150297_b("taskID", 99) ? -1 : data.func_74762_e("taskID");
        if (qId.isPresent() && tId >= 0) {
            ITask task;
            IQuest quest = (IQuest)QuestingAPI.getAPI(ApiReference.QUEST_DB).get(qId.get());
            ITask iTask = task = quest == null ? null : (ITask)quest.getTasks().getValue(tId);
            if (task instanceof TaskCheckbox) {
                ParticipantInfo pInfo = new ParticipantInfo((EntityPlayer)sender);
                List<UUID> playersToMark = QBConfig.fullySyncQuests ? pInfo.ALL_UUIDS : Collections.singletonList(pInfo.UUID);
                for (UUID user : playersToMark) {
                    QuestCache qc;
                    task.setComplete(user);
                    if (QuestingAPI.getPlayer(user) == null || (qc = (QuestCache)QuestingAPI.getPlayer(user).getExtendedProperties(QuestCache.LOC_QUEST_CACHE.toString())) == null) continue;
                    qc.markQuestDirty(qId.get());
                }
            }
        }
    }
}

