/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.block;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.event.TeleposeEvent;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.demonVillage.tileEntity.TEDemonPortal;
import WayofTime.alchemicalWizardry.common.items.TelepositionFocus;
import WayofTime.alchemicalWizardry.common.tileEntity.TETeleposer;
import codechicken.multipart.MultipartHelper;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class BlockTeleposer
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon sideIcon;

    public BlockTeleposer() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(AlchemicalWizardry.tabBloodMagic);
        this.func_149663_c("bloodTeleposer");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.topIcon = iconRegister.func_94245_a("AlchemicalWizardry:Teleposer_Top");
        this.sideIcon = iconRegister.func_94245_a("AlchemicalWizardry:Teleposer_Side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 1) {
            return this.topIcon;
        }
        return this.sideIcon;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int idk, float what, float these, float are) {
        ItemStack playerItem = player.func_71045_bC();
        if (playerItem == null || !(playerItem.func_77973_b() instanceof TelepositionFocus)) {
            player.openGui((Object)AlchemicalWizardry.instance, 1, world, x, y, z);
            return true;
        }
        SoulNetworkHandler.checkAndSetItemPlayer(playerItem, player);
        NBTTagCompound itemTag = IBindable.getTag(playerItem);
        itemTag.func_74768_a("xCoord", x);
        itemTag.func_74768_a("yCoord", y);
        itemTag.func_74768_a("zCoord", z);
        itemTag.func_74768_a("dimensionId", world.field_73011_w.field_76574_g);
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        this.dropItems(world, x, y, z);
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    private void dropItems(World world, int x, int y, int z) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        ItemStack item = inventory.func_70301_a(0);
        if (item == null || item.field_77994_a <= 0) {
            return;
        }
        float rx = rand.nextFloat() * 0.8f + 0.1f;
        float ry = rand.nextFloat() * 0.8f + 0.1f;
        float rz = rand.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
        if (item.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
        }
        float factor = 0.05f;
        entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
        entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
        entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
        world.func_72838_d((Entity)entityItem);
        item.field_77994_a = 0;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TETeleposer();
    }

    public static boolean swapBlocks(Object caller, World worldA, World worldB, int xA, int yA, int zA, int xB, int yB, int zB) {
        return BlockTeleposer.swapBlocks(caller, worldA, worldB, xA, yA, zA, xB, yB, zB, true, 3);
    }

    public static boolean swapBlocksWithoutSound(Object caller, World worldA, World worldB, int xA, int yA, int zA, int xB, int yB, int zB) {
        return BlockTeleposer.swapBlocks(caller, worldA, worldB, xA, yA, zA, xB, yB, zB, false, 3);
    }

    public static boolean swapBlocks(Object caller, World worldA, World worldB, int xA, int yA, int zA, int xB, int yB, int zB, boolean doSound, int flag) {
        int metaB;
        TileEntity tileA = worldA.func_147438_o(xA, yA, zA);
        TileEntity tileB = worldB.func_147438_o(xB, yB, zB);
        NBTTagCompound nbtA = new NBTTagCompound();
        NBTTagCompound nbtB = new NBTTagCompound();
        if (tileA != null) {
            tileA.func_145841_b(nbtA);
        }
        if (tileB != null) {
            tileB.func_145841_b(nbtB);
        }
        Block blockA = worldA.func_147439_a(xA, yA, zA);
        Block blockB = worldB.func_147439_a(xB, yB, zB);
        if (blockA.equals(Blocks.field_150350_a) && blockB.equals(Blocks.field_150350_a)) {
            return false;
        }
        if (!(caller instanceof TEDemonPortal) && (blockA instanceof BlockPortal || blockB instanceof BlockPortal)) {
            return false;
        }
        int metaA = worldA.func_72805_g(xA, yA, zA);
        TeleposeEvent evt = new TeleposeEvent(worldA, xA, yA, zA, blockA, metaA, worldB, xB, yB, zB, blockB, metaB = worldB.func_72805_g(xB, yB, zB));
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return false;
        }
        if (doSound) {
            String sound = "mob.endermen.portal";
            worldA.func_72908_a((double)xA, (double)yA, (double)zA, sound, 1.0f, 1.0f);
            worldB.func_72908_a((double)xB, (double)yB, (double)zB, sound, 1.0f, 1.0f);
        }
        worldB.func_147455_a(xB, yB, zB, blockB.createTileEntity(worldB, metaB));
        worldA.func_147455_a(xA, yA, zA, blockA.createTileEntity(worldA, metaA));
        worldB.func_147465_d(xB, yB, zB, blockA, metaA, flag);
        worldA.func_147465_d(xA, yA, zA, blockB, metaB, flag);
        BlockTeleposer.swapTile(worldB, xB, yB, zB, tileA, nbtA);
        BlockTeleposer.swapTile(worldA, xA, yA, zA, tileB, nbtB);
        return true;
    }

    private static void swapTile(World world, int x, int y, int z, TileEntity oldTile, NBTTagCompound nbt) {
        if (oldTile == null) {
            return;
        }
        boolean multipart = AlchemicalWizardry.isFMPLoaded && oldTile instanceof TileMultipart;
        TileEntity newTile = multipart ? MultipartHelper.createTileFromNBT((World)world, (NBTTagCompound)nbt) : TileEntity.func_145827_c((NBTTagCompound)nbt);
        world.func_147455_a(x, y, z, newTile);
        newTile.field_145851_c = x;
        newTile.field_145848_d = y;
        newTile.field_145849_e = z;
        if (multipart) {
            MultipartHelper.sendDescPacket((World)world, (TileEntity)newTile);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TETeleposer)) {
            return;
        }
        TETeleposer teleposer = (TETeleposer)tileEntity;
        boolean isPowered = world.func_72864_z(x, y, z);
        if (!teleposer.hasRedstone && isPowered) {
            teleposer.hasRedstone = true;
            teleposer.activate();
        } else {
            teleposer.hasRedstone = isPowered;
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }
}

