/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.energy;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.alchemy.energy.IReagentHandler;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainerInfo;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.api.items.interfaces.IReagentManipulator;
import WayofTime.alchemicalWizardry.common.tileEntity.TEReagentConduit;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemAttunedCrystal
extends Item
implements IReagentManipulator {
    public static final int maxDistance = 6;
    public IIcon crystalBody;
    public IIcon crystalLabel;

    public ItemAttunedCrystal() {
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
        this.field_77787_bX = true;
        this.field_77777_bU = 1;
    }

    public String func_77653_i(ItemStack stack) {
        Reagent reagent = this.getReagent(stack);
        String name = super.func_77653_i(stack);
        if (reagent != null) {
            name = name + " (" + reagent.name + ")";
        }
        return name;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.attunedcrystal.desc1"));
        par3List.add(StatCollector.func_74838_a((String)"tooltip.attunedcrystal.desc2"));
        if (par1ItemStack.func_77978_p() != null) {
            Reagent reagent = this.getReagent(par1ItemStack);
            if (reagent != null) {
                par3List.add(StatCollector.func_74838_a((String)"tooltip.reagent.selectedreagent") + " " + reagent.name);
            }
            if (this.getHasSavedCoordinates(par1ItemStack)) {
                par3List.add("");
                Int3 coords = this.getCoordinates(par1ItemStack);
                par3List.add(StatCollector.func_74838_a((String)"tooltip.alchemy.coords") + " " + coords.xCoord + ", " + coords.yCoord + ", " + coords.zCoord);
                par3List.add(StatCollector.func_74838_a((String)"tooltip.alchemy.dimension") + " " + this.getDimension(par1ItemStack));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.crystalBody = iconRegister.func_94245_a("AlchemicalWizardry:AttunedCrystal1");
        this.crystalLabel = iconRegister.func_94245_a("AlchemicalWizardry:AttunedCrystal2");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        switch (pass) {
            case 0: {
                return 0xFFFFFF;
            }
            case 1: {
                Reagent reagent = this.getReagent(stack);
                if (reagent == null) break;
                return reagent.getColourRed() * 256 * 256 + reagent.getColourGreen() * 256 + reagent.getColourBlue();
            }
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int meta) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        IIcon iIcon;
        switch (pass) {
            case 0: {
                iIcon = this.crystalBody;
                break;
            }
            case 1: {
                iIcon = this.crystalLabel;
                break;
            }
            default: {
                iIcon = this.field_77791_bV;
            }
        }
        return iIcon;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return itemStack;
        }
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, false);
        if (movingobjectposition == null) {
            if (player.func_70093_af()) {
                this.setHasSavedCoordinates(itemStack, false);
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("message.attunedcrystal.clearing", new Object[0]));
            }
            return itemStack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            TileEntity tile = world.func_147438_o(x, y, z);
            if (!(tile instanceof IReagentHandler)) {
                return itemStack;
            }
            IReagentHandler relay = (IReagentHandler)tile;
            if (player.func_70093_af()) {
                ReagentContainerInfo[] infos = relay.getContainerInfo(ForgeDirection.UNKNOWN);
                if (infos != null) {
                    LinkedList<Reagent> reagentList = new LinkedList<Reagent>();
                    for (ReagentContainerInfo info : infos) {
                        Reagent reagent;
                        ReagentStack reagentStack;
                        if (info == null || (reagentStack = info.reagent) == null || (reagent = reagentStack.reagent) == null) continue;
                        reagentList.add(reagent);
                    }
                    Reagent pastReagent = this.getReagent(itemStack);
                    if (reagentList.size() <= 0) {
                        return itemStack;
                    }
                    int reagentLocation = reagentList.indexOf(pastReagent);
                    if (reagentLocation == -1 || reagentLocation + 1 >= reagentList.size()) {
                        this.setReagentWithNotification(itemStack, (Reagent)reagentList.get(0), player);
                    } else {
                        this.setReagentWithNotification(itemStack, (Reagent)reagentList.get(reagentLocation + 1), player);
                    }
                }
            } else if (this.getHasSavedCoordinates(itemStack)) {
                Int3 coords = this.getCoordinates(itemStack);
                int dimension = this.getDimension(itemStack);
                if (coords == null) {
                    return itemStack;
                }
                if (dimension != world.field_73011_w.field_76574_g || Math.abs(coords.xCoord - x) > 6 || Math.abs(coords.yCoord - y) > 6 || Math.abs(coords.zCoord - z) > 6) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("message.attunedcrystal.error.toofar", new Object[0]));
                    return itemStack;
                }
                TileEntity pastTile = world.func_147438_o(coords.xCoord, coords.yCoord, coords.zCoord);
                if (!(pastTile instanceof TEReagentConduit)) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("message.attunedcrystal.error.cannotfind", new Object[0]));
                    return itemStack;
                }
                Reagent reagent = this.getReagent(itemStack);
                if (reagent == null) {
                    return itemStack;
                }
                TEReagentConduit pastRelay = (TEReagentConduit)pastTile;
                if (player.func_70093_af()) {
                    pastRelay.removeReagentDestinationViaActual(reagent, x, y, z);
                } else if (pastRelay.addReagentDestinationViaActual(reagent, x, y, z)) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.attunedcrystal.linked") + " " + reagent.name));
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("message.attunedcrystal.error.noconnections", new Object[0]));
                }
                world.func_147471_g(coords.xCoord, coords.yCoord, coords.zCoord);
            } else {
                int dimension = world.field_73011_w.field_76574_g;
                this.setDimension(itemStack, dimension);
                this.setCoordinates(itemStack, new Int3(x, y, z));
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("message.attunedcrystal.linking", new Object[0]));
            }
        }
        return itemStack;
    }

    public void setCoordinates(ItemStack stack, Int3 coords) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        coords.writeToNBT(tag);
        this.setHasSavedCoordinates(stack, true);
    }

    public void setDimension(ItemStack stack, int dimension) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74768_a("dimension", dimension);
    }

    public Int3 getCoordinates(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        return Int3.readFromNBT(tag);
    }

    public int getDimension(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74762_e("dimension");
    }

    public void setHasSavedCoordinates(ItemStack stack, boolean flag) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74757_a("hasSavedCoordinates", flag);
    }

    public boolean getHasSavedCoordinates(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74767_n("hasSavedCoordinates");
    }

    public Reagent getReagent(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        return ReagentRegistry.getReagentForKey(tag.func_74779_i("reagent"));
    }

    public void setReagent(ItemStack stack, Reagent reagent) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74778_a("reagent", ReagentRegistry.getKeyForReagent(reagent));
    }

    public void setReagentWithNotification(ItemStack stack, Reagent reagent, EntityPlayer player) {
        this.setReagent(stack, reagent);
        if (reagent != null) {
            player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.attunedcrystal.setto") + " " + reagent.name));
        }
    }
}

