/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.AlchemicalWizardryEventHooks;
import WayofTime.alchemicalWizardry.common.CoordAndRange;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.World;

public class RitualEffectSpawnWard
extends RitualEffect {
    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (currentEssence < this.getCostPerRefresh()) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            int horizRange = 32;
            int vertRange = 32;
            int dimension = world.field_73011_w.field_76574_g;
            if (AlchemicalWizardryEventHooks.respawnMap.containsKey(new Integer(dimension))) {
                List<CoordAndRange> list = AlchemicalWizardryEventHooks.respawnMap.get(new Integer(dimension));
                if (list != null) {
                    if (!list.contains(new CoordAndRange(x, y, z, horizRange, vertRange))) {
                        boolean hasFoundAndRemoved = false;
                        for (CoordAndRange coords : list) {
                            int xLocation = coords.xCoord;
                            int yLocation = coords.yCoord;
                            int zLocation = coords.zCoord;
                            if (xLocation != x || yLocation != y || zLocation != z) continue;
                            list.remove(coords);
                            hasFoundAndRemoved = true;
                            break;
                        }
                        list.add(new CoordAndRange(x, y, z, horizRange, vertRange));
                    }
                } else {
                    list = new LinkedList<CoordAndRange>();
                    list.add(new CoordAndRange(x, y, z, horizRange, vertRange));
                    AlchemicalWizardryEventHooks.respawnMap.put(new Integer(dimension), list);
                }
            } else {
                LinkedList<CoordAndRange> list = new LinkedList<CoordAndRange>();
                list.add(new CoordAndRange(x, y, z, horizRange, vertRange));
                AlchemicalWizardryEventHooks.respawnMap.put(new Integer(dimension), list);
            }
            SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostSpawnWard[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> wardRitualRitual = new ArrayList<RitualComponent>();
        for (int i = 2; i <= 4; ++i) {
            if (i <= 3) {
                wardRitualRitual.add(new RitualComponent(0, 0, i, 4));
                wardRitualRitual.add(new RitualComponent(0, 0, -i, 4));
                wardRitualRitual.add(new RitualComponent(i, 0, 0, 4));
                wardRitualRitual.add(new RitualComponent(-i, 0, 0, 4));
            }
            wardRitualRitual.add(new RitualComponent(i, 0, i, 2));
            wardRitualRitual.add(new RitualComponent(i, 0, -i, 2));
            wardRitualRitual.add(new RitualComponent(-i, 0, -i, 2));
            wardRitualRitual.add(new RitualComponent(-i, 0, i, 2));
        }
        wardRitualRitual.add(new RitualComponent(0, 0, 5, 5));
        wardRitualRitual.add(new RitualComponent(0, 0, -5, 5));
        wardRitualRitual.add(new RitualComponent(5, 0, 0, 5));
        wardRitualRitual.add(new RitualComponent(-5, 0, 0, 5));
        wardRitualRitual.add(new RitualComponent(6, 0, 5, 1));
        wardRitualRitual.add(new RitualComponent(5, 0, 6, 1));
        wardRitualRitual.add(new RitualComponent(6, 0, -5, 1));
        wardRitualRitual.add(new RitualComponent(-5, 0, 6, 1));
        wardRitualRitual.add(new RitualComponent(-6, 0, 5, 1));
        wardRitualRitual.add(new RitualComponent(5, 0, -6, 1));
        wardRitualRitual.add(new RitualComponent(-6, 0, -5, 1));
        wardRitualRitual.add(new RitualComponent(-5, 0, -6, 1));
        return wardRitualRitual;
    }
}

