/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.simple;

import WayofTime.alchemicalWizardry.common.spell.simple.ISimpleSpell;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class HomSpell
implements ISimpleSpell {
    private int offensiveRangedEnergy;
    private int offensiveMeleeEnergy;
    private int defensiveEnergy;
    private int environmentalEnergy;

    @Override
    public abstract ItemStack onOffensiveRangedRightClick(ItemStack var1, World var2, EntityPlayer var3);

    @Override
    public abstract ItemStack onOffensiveMeleeRightClick(ItemStack var1, World var2, EntityPlayer var3);

    @Override
    public abstract ItemStack onDefensiveRightClick(ItemStack var1, World var2, EntityPlayer var3);

    @Override
    public abstract ItemStack onEnvironmentalRightClick(ItemStack var1, World var2, EntityPlayer var3);

    public int getOffensiveRangedEnergy() {
        return this.offensiveRangedEnergy;
    }

    public int getOffensiveMeleeEnergy() {
        return this.offensiveMeleeEnergy;
    }

    public int getDefensiveEnergy() {
        return this.defensiveEnergy;
    }

    public int getEnvironmentalEnergy() {
        return this.environmentalEnergy;
    }

    public void setEnergies(int offensiveRanged, int offensiveMelee, int defensive, int environmental) {
        this.offensiveRangedEnergy = offensiveRanged;
        this.offensiveMeleeEnergy = offensiveMelee;
        this.defensiveEnergy = defensive;
        this.environmentalEnergy = environmental;
    }

    public void setSpellParadigm(ItemStack itemStack, int paradigm) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a("paradigm", paradigm);
    }

    public int getSpellParadigm(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p().func_74762_e("paradigm");
    }

    public ItemStack useSpell(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        int paradigm = this.getSpellParadigm(par1ItemStack);
        if (par3EntityPlayer.func_70093_af()) {
            if (paradigm < 3) {
                this.setSpellParadigm(par1ItemStack, paradigm + 1);
            } else {
                this.setSpellParadigm(par1ItemStack, 0);
            }
            return par1ItemStack;
        }
        switch (paradigm) {
            case 0: {
                return this.onOffensiveRangedRightClick(par1ItemStack, par2World, par3EntityPlayer);
            }
            case 1: {
                return this.onOffensiveMeleeRightClick(par1ItemStack, par2World, par3EntityPlayer);
            }
            case 2: {
                return this.onDefensiveRightClick(par1ItemStack, par2World, par3EntityPlayer);
            }
            case 3: {
                return this.onEnvironmentalRightClick(par1ItemStack, par2World, par3EntityPlayer);
            }
        }
        return par1ItemStack;
    }

    public int getDimensionID(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p().func_74762_e("dimensionId");
    }
}

