/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tweaker;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.tweaker.Alchemy;
import WayofTime.alchemicalWizardry.common.tweaker.Binding;
import WayofTime.alchemicalWizardry.common.tweaker.BloodAltar;
import WayofTime.alchemicalWizardry.common.tweaker.BloodOrb;
import WayofTime.alchemicalWizardry.common.tweaker.FallingTower;
import WayofTime.alchemicalWizardry.common.tweaker.HarvestMoon;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.InvalidVersionSpecificationException;
import cpw.mods.fml.common.versioning.VersionRange;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.util.IEventHandler;

public class MineTweakerIntegration {
    public static void register() {
        MineTweakerAPI.registerClass(Alchemy.class);
        MineTweakerAPI.registerClass(Binding.class);
        MineTweakerAPI.registerClass(BloodAltar.class);
        MineTweakerAPI.registerClass(BloodOrb.class);
        MineTweakerAPI.registerClass(FallingTower.class);
        MineTweakerAPI.registerClass(HarvestMoon.class);
        MineTweakerImplementationAPI.onPostReload((IEventHandler)new HandleLateAdditionsAndRemovals());
        ArtifactVersion mtVersion = ((ModContainer)Loader.instance().getIndexedModList().get("MineTweaker3")).getProcessedVersion();
        try {
            if (VersionRange.createFromVersionSpec((String)"[3.2.4,)").containsVersion(mtVersion)) {
                GTNHIntegration.register();
            } else {
                AlchemicalWizardry.logger.warn("Non-GTNH MineTweaker (CraftTweaker) version detected, late recipe additions and removals won't work correctly");
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    public static class HandleLateAdditionsAndRemovals
    implements IEventHandler<MineTweakerImplementationAPI.ReloadEvent> {
        public void handle(MineTweakerImplementationAPI.ReloadEvent event) {
            BloodOrb.applyAdditionsAndRemovals();
        }
    }

    public static class GTNHIntegration {
        public static void register() {
            MineTweakerImplementationAPI.onRollbackEvent((IEventHandler)new HandleLateAdditionsAndRemovals());
        }
    }
}

