/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.world.World;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.item.relic.ItemRelic;

public abstract class ItemRelicBauble
extends ItemBauble
implements IRelic {
    Achievement achievement;

    public ItemRelicBauble(String name) {
        super(name);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean isHeld) {
        if (entity instanceof EntityPlayer) {
            ItemRelic.updateRelic(stack, (EntityPlayer)entity);
        }
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        super.onWornTick(stack, player);
        if (player instanceof EntityPlayer) {
            EntityPlayer ePlayer = (EntityPlayer)player;
            ItemRelic.updateRelic(stack, ePlayer);
            if (ItemRelic.isRightPlayer(ePlayer, stack)) {
                this.onValidPlayerWornTick(stack, ePlayer);
            }
        }
    }

    @Override
    public void addHiddenTooltip(ItemStack stack, EntityPlayer player, List<String> infoList, boolean adv) {
        super.addHiddenTooltip(stack, player, infoList, adv);
        ItemRelic.addBindInfo(infoList, stack, player);
    }

    public void onValidPlayerWornTick(ItemStack stack, EntityPlayer player) {
    }

    @Override
    public boolean canEquip(ItemStack stack, EntityLivingBase player) {
        return player instanceof EntityPlayer && ItemRelic.isRightPlayer((EntityPlayer)player, stack);
    }

    @Override
    public void bindToUsername(String playerName, ItemStack stack) {
        ItemRelic.bindToUsernameS(playerName, stack);
    }

    @Override
    public String getSoulbindUsername(ItemStack stack) {
        return ItemRelic.getSoulbindUsernameS(stack);
    }

    @Override
    public Achievement getBindAchievement() {
        return this.achievement;
    }

    @Override
    public void setBindAchievement(Achievement achievement) {
        this.achievement = achievement;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return BotaniaAPI.rarityRelic;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }
}

