/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.util;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryHelper {
    public static final int TAG_ID_COMPOUND = 10;

    public static ItemStack pushToInventory(@Nonnull IInventory target, @Nonnull ItemStack inputStack) {
        int maxDestSize = target.func_70297_j_();
        int maxItemSize = inputStack.func_77976_d();
        for (int slot = 0; slot < target.func_70302_i_(); ++slot) {
            if (!target.func_94041_b(slot, inputStack)) continue;
            ItemStack targetStack = target.func_70301_a(slot);
            if (targetStack != null) {
                if (targetStack.field_77994_a >= maxDestSize || !InventoryHelper.canStacksBeMerged(targetStack, inputStack)) continue;
                int stackSizeLimit = Math.min(maxDestSize, maxItemSize);
                int itemsToMove = Math.min(inputStack.field_77994_a, stackSizeLimit - targetStack.field_77994_a);
                ItemStack updatedDestinationStack = targetStack.func_77946_l();
                updatedDestinationStack.field_77994_a += itemsToMove;
                target.func_70299_a(slot, updatedDestinationStack);
                inputStack = inputStack.func_77946_l();
                inputStack.field_77994_a -= itemsToMove;
                if (inputStack.field_77994_a != 0) continue;
                return null;
            }
            int itemsToMove = Math.min(maxDestSize, Math.min(maxItemSize, inputStack.field_77994_a));
            if (itemsToMove == inputStack.field_77994_a) {
                target.func_70299_a(slot, inputStack);
                return null;
            }
            ItemStack splitDestinationStack = inputStack.func_77946_l();
            splitDestinationStack.field_77994_a = itemsToMove;
            target.func_70299_a(slot, inputStack);
            inputStack = inputStack.func_77946_l();
            inputStack.field_77994_a -= itemsToMove;
        }
        return inputStack;
    }

    public static int itemsToMove(@Nonnull ItemStack target, @Nonnull ItemStack source) {
        if (InventoryHelper.canStacksBeMerged(target, source)) {
            int maxItemSize = source.func_77976_d();
            int maxMove = maxItemSize - target.field_77994_a;
            return Math.min(maxMove, source.field_77994_a);
        }
        return 0;
    }

    public static boolean canStacksBeMerged(@Nonnull ItemStack destination, @Nonnull ItemStack source) {
        return destination.func_77973_b() == source.func_77973_b() && destination.func_77960_j() == source.func_77960_j() && destination.field_77994_a <= destination.func_77976_d() && ItemStack.func_77970_a((ItemStack)destination, (ItemStack)source);
    }

    @Nonnull
    public static NBTTagCompound saveInventoryToNBT(@Nonnull IInventory inventory) {
        NBTTagCompound compound = new NBTTagCompound();
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (stack == null || stack.field_77994_a == 0) continue;
            NBTTagCompound stackData = new NBTTagCompound();
            stack.func_77955_b(stackData);
            compound.func_74782_a("slot_" + slot, (NBTBase)stackData);
        }
        return compound;
    }

    public static void readInventoryFromNBT(@Nonnull IInventory inventory, NBTTagCompound compound) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            String tag = "slot_" + slot;
            if (compound != null && compound.func_150297_b(tag, 10)) {
                NBTTagCompound stackData = compound.func_74775_l(tag);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)stackData);
                inventory.func_70299_a(slot, stack);
                continue;
            }
            inventory.func_70299_a(slot, null);
        }
    }

    public static boolean isIngredient(ItemStack stack, Object recipe) {
        ItemStack compare;
        if (recipe instanceof String) {
            int[] oreIds;
            for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!OreDictionary.getOreName((int)oreId).equals(recipe)) continue;
                return true;
            }
        } else if (recipe instanceof ItemStack && (compare = (ItemStack)recipe).func_77969_a(stack)) {
            return true;
        }
        return false;
    }

    public static void setRandomDropDirection(EntityItem item, World world) {
        double speed = 0.05;
        Random random = world.field_73012_v;
        item.field_70159_w = random.nextGaussian() * speed;
        item.field_70181_x = random.nextGaussian() * speed + (double)0.2f;
        item.field_70179_y = random.nextGaussian() * speed;
    }
}

