/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer.helper;

import com.carpentersblocks.data.FlowerPot;
import com.carpentersblocks.data.Slope;
import com.carpentersblocks.renderer.BlockHandlerBase;
import com.carpentersblocks.renderer.helper.LightingHelper;
import com.carpentersblocks.renderer.helper.VertexHelper;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.collapsible.CollapsibleUtil;
import com.carpentersblocks.util.flowerpot.FlowerPotProperties;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockGrass;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class RenderHelper
extends VertexHelper {
    private boolean rotationOverride = false;
    protected int rotation;
    private double uMin;
    private double uMax;
    private double vMin;
    private double vMax;
    protected double xMin;
    protected double xMax;
    protected double yMin;
    protected double yMax;
    protected double zMin;
    protected double zMax;
    protected double uTL;
    protected double vTL;
    protected double uBL;
    protected double vBL;
    protected double uBR;
    protected double vBR;
    protected double uTR;
    protected double vTR;
    public static final double OFFSET_MAX = 0.001953125;
    public static final double OFFSET_MIN = 9.765625E-4;
    public double renderOffset;

    @Override
    public void setOffset(double offset) {
        this.renderOffset = offset;
    }

    @Override
    public void clearOffset() {
        this.renderOffset = 0.0;
    }

    public void setTextureRotationOverride(int in_rotation) {
        this.rotationOverride = true;
        this.rotation = in_rotation;
    }

    public void clearTextureRotationOverride() {
        this.rotationOverride = false;
    }

    private void setCornerUV(double t_uTL, double t_vTL, double t_uBL, double t_vBL, double t_uBR, double t_vBR, double t_uTR, double t_vTR) {
        this.uTL = t_uTL;
        this.vTL = t_vTL;
        this.uBL = t_uBL;
        this.vBL = t_vBL;
        this.uBR = t_uBR;
        this.vBR = t_vBR;
        this.uTR = t_uTR;
        this.vTR = t_vTR;
    }

    protected void prepareRender(RenderBlocks renderBlocks, ForgeDirection side, double x, double y, double z, IIcon icon) {
        if (icon == BlockGrass.func_149990_e() || icon.func_94215_i().contains("overlay/overlay_") && icon.func_94215_i().endsWith("_side")) {
            this.setFloatingIcon();
        }
        this.xMin = x + renderBlocks.field_147859_h - this.renderOffset;
        this.xMax = x + renderBlocks.field_147861_i + this.renderOffset;
        this.yMin = y + renderBlocks.field_147855_j - this.renderOffset;
        this.yMax = y + renderBlocks.field_147857_k + this.renderOffset;
        this.zMin = z + renderBlocks.field_147851_l - this.renderOffset;
        this.zMax = z + renderBlocks.field_147853_m + this.renderOffset;
        if (!this.rotationOverride) {
            switch (side) {
                case DOWN: {
                    this.rotation = renderBlocks.field_147865_v;
                    break;
                }
                case UP: {
                    this.rotation = renderBlocks.field_147867_u;
                    break;
                }
                case NORTH: {
                    this.rotation = renderBlocks.field_147869_t;
                    break;
                }
                case SOUTH: {
                    this.rotation = renderBlocks.field_147871_s;
                    break;
                }
                case WEST: {
                    this.rotation = renderBlocks.field_147873_r;
                    break;
                }
                case EAST: {
                    this.rotation = renderBlocks.field_147875_q;
                    break;
                }
            }
        }
        switch (side) {
            case DOWN: {
                switch (this.rotation) {
                    case 0: {
                        this.uMin = icon.func_94214_a(renderBlocks.field_147859_h * 16.0);
                        this.uMax = icon.func_94214_a(renderBlocks.field_147861_i * 16.0);
                        this.vMin = icon.func_94207_b(renderBlocks.field_147851_l * 16.0);
                        this.vMax = icon.func_94207_b(renderBlocks.field_147853_m * 16.0);
                        this.setCornerUV(this.uMax, this.vMax, this.uMax, this.vMin, this.uMin, this.vMin, this.uMin, this.vMax);
                        break;
                    }
                    case 1: {
                        this.uMin = icon.func_94214_a(16.0 - renderBlocks.field_147853_m * 16.0);
                        this.uMax = icon.func_94214_a(16.0 - renderBlocks.field_147851_l * 16.0);
                        this.vMin = icon.func_94207_b(renderBlocks.field_147859_h * 16.0);
                        this.vMax = icon.func_94207_b(renderBlocks.field_147861_i * 16.0);
                        this.setCornerUV(this.uMin, this.vMax, this.uMax, this.vMax, this.uMax, this.vMin, this.uMin, this.vMin);
                        break;
                    }
                    case 2: {
                        this.uMin = icon.func_94214_a(16.0 - renderBlocks.field_147859_h * 16.0);
                        this.uMax = icon.func_94214_a(16.0 - renderBlocks.field_147861_i * 16.0);
                        this.vMin = icon.func_94207_b(16.0 - renderBlocks.field_147851_l * 16.0);
                        this.vMax = icon.func_94207_b(16.0 - renderBlocks.field_147853_m * 16.0);
                        this.setCornerUV(this.uMax, this.vMax, this.uMax, this.vMin, this.uMin, this.vMin, this.uMin, this.vMax);
                        break;
                    }
                    case 3: {
                        this.uMin = icon.func_94214_a(renderBlocks.field_147853_m * 16.0);
                        this.uMax = icon.func_94214_a(renderBlocks.field_147851_l * 16.0);
                        this.vMin = icon.func_94207_b(16.0 - renderBlocks.field_147859_h * 16.0);
                        this.vMax = icon.func_94207_b(16.0 - renderBlocks.field_147861_i * 16.0);
                        this.setCornerUV(this.uMin, this.vMax, this.uMax, this.vMax, this.uMax, this.vMin, this.uMin, this.vMin);
                    }
                }
                break;
            }
            case UP: {
                switch (this.rotation) {
                    case 0: {
                        this.uMin = icon.func_94214_a(renderBlocks.field_147859_h * 16.0);
                        this.uMax = icon.func_94214_a(renderBlocks.field_147861_i * 16.0);
                        this.vMin = icon.func_94207_b(renderBlocks.field_147851_l * 16.0);
                        this.vMax = icon.func_94207_b(renderBlocks.field_147853_m * 16.0);
                        this.setCornerUV(this.uMax, this.vMax, this.uMax, this.vMin, this.uMin, this.vMin, this.uMin, this.vMax);
                        break;
                    }
                    case 1: {
                        this.uMin = icon.func_94214_a(renderBlocks.field_147853_m * 16.0);
                        this.uMax = icon.func_94214_a(renderBlocks.field_147851_l * 16.0);
                        this.vMin = icon.func_94207_b(16.0 - renderBlocks.field_147859_h * 16.0);
                        this.vMax = icon.func_94207_b(16.0 - renderBlocks.field_147861_i * 16.0);
                        this.setCornerUV(this.uMin, this.vMax, this.uMax, this.vMax, this.uMax, this.vMin, this.uMin, this.vMin);
                        break;
                    }
                    case 2: {
                        this.uMin = icon.func_94214_a(16.0 - renderBlocks.field_147859_h * 16.0);
                        this.uMax = icon.func_94214_a(16.0 - renderBlocks.field_147861_i * 16.0);
                        this.vMin = icon.func_94207_b(16.0 - renderBlocks.field_147851_l * 16.0);
                        this.vMax = icon.func_94207_b(16.0 - renderBlocks.field_147853_m * 16.0);
                        this.setCornerUV(this.uMax, this.vMax, this.uMax, this.vMin, this.uMin, this.vMin, this.uMin, this.vMax);
                        break;
                    }
                    case 3: {
                        this.uMin = icon.func_94214_a(16.0 - renderBlocks.field_147853_m * 16.0);
                        this.uMax = icon.func_94214_a(16.0 - renderBlocks.field_147851_l * 16.0);
                        this.vMin = icon.func_94207_b(renderBlocks.field_147859_h * 16.0);
                        this.vMax = icon.func_94207_b(renderBlocks.field_147861_i * 16.0);
                        this.setCornerUV(this.uMin, this.vMax, this.uMax, this.vMax, this.uMax, this.vMin, this.uMin, this.vMin);
                    }
                }
                break;
            }
            case NORTH: {
                switch (this.rotation) {
                    case 0: {
                        this.uMin = icon.func_94214_a(16.0 - renderBlocks.field_147861_i * 16.0);
                        this.uMax = icon.func_94214_a(16.0 - renderBlocks.field_147859_h * 16.0);
                        this.vMin = icon.func_94207_b(16.0 - (this.floatingIcon ? 1.0 - (renderBlocks.field_147857_k - renderBlocks.field_147855_j) : renderBlocks.field_147855_j) * 16.0);
                        this.vMax = icon.func_94207_b(16.0 - (this.floatingIcon ? 1.0 : renderBlocks.field_147857_k) * 16.0);
                        this.setCornerUV(this.uMin, this.vMax, this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax);
                        break;
                    }
                    case 1: {
                        this.uMin = icon.func_94214_a(16.0 - renderBlocks.field_147857_k * 16.0);
                        this.uMax = icon.func_94214_a(16.0 - renderBlocks.field_147855_j * 16.0);
                        this.vMin = icon.func_94207_b(renderBlocks.field_147861_i * 16.0);
                        this.vMax = icon.func_94207_b(renderBlocks.field_147859_h * 16.0);
                        this.setCornerUV(this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax, this.uMin, this.vMax);
                        break;
                    }
                    case 2: {
                        this.uMin = icon.func_94214_a(renderBlocks.field_147861_i * 16.0);
                        this.uMax = icon.func_94214_a(renderBlocks.field_147859_h * 16.0);
                        this.vMin = icon.func_94207_b(renderBlocks.field_147855_j * 16.0);
                        this.vMax = icon.func_94207_b(renderBlocks.field_147857_k * 16.0);
                        this.setCornerUV(this.uMin, this.vMax, this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax);
                        break;
                    }
                    case 3: {
                        this.uMin = icon.func_94214_a(renderBlocks.field_147857_k * 16.0);
                        this.uMax = icon.func_94214_a(renderBlocks.field_147855_j * 16.0);
                        this.vMin = icon.func_94207_b(16.0 - renderBlocks.field_147861_i * 16.0);
                        this.vMax = icon.func_94207_b(16.0 - renderBlocks.field_147859_h * 16.0);
                        this.setCornerUV(this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax, this.uMin, this.vMax);
                    }
                }
                break;
            }
            case SOUTH: {
                switch (this.rotation) {
                    case 0: {
                        this.uMin = icon.func_94214_a(renderBlocks.field_147859_h * 16.0);
                        this.uMax = icon.func_94214_a(renderBlocks.field_147861_i * 16.0);
                        this.vMin = icon.func_94207_b(16.0 - (this.floatingIcon ? 1.0 - (renderBlocks.field_147857_k - renderBlocks.field_147855_j) : renderBlocks.field_147855_j) * 16.0);
                        this.vMax = icon.func_94207_b(16.0 - (this.floatingIcon ? 1.0 : renderBlocks.field_147857_k) * 16.0);
                        this.setCornerUV(this.uMin, this.vMax, this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax);
                        break;
                    }
                    case 1: {
                        this.uMin = icon.func_94214_a(16.0 - renderBlocks.field_147857_k * 16.0);
                        this.uMax = icon.func_94214_a(16.0 - renderBlocks.field_147855_j * 16.0);
                        this.vMin = icon.func_94207_b(16.0 - renderBlocks.field_147859_h * 16.0);
                        this.vMax = icon.func_94207_b(16.0 - renderBlocks.field_147861_i * 16.0);
                        this.setCornerUV(this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax, this.uMin, this.vMax);
                        break;
                    }
                    case 2: {
                        this.uMin = icon.func_94214_a(16.0 - renderBlocks.field_147859_h * 16.0);
                        this.uMax = icon.func_94214_a(16.0 - renderBlocks.field_147861_i * 16.0);
                        this.vMin = icon.func_94207_b(renderBlocks.field_147855_j * 16.0);
                        this.vMax = icon.func_94207_b(renderBlocks.field_147857_k * 16.0);
                        this.setCornerUV(this.uMin, this.vMax, this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax);
                        break;
                    }
                    case 3: {
                        this.uMin = icon.func_94214_a(renderBlocks.field_147857_k * 16.0);
                        this.uMax = icon.func_94214_a(renderBlocks.field_147855_j * 16.0);
                        this.vMin = icon.func_94207_b(renderBlocks.field_147859_h * 16.0);
                        this.vMax = icon.func_94207_b(renderBlocks.field_147861_i * 16.0);
                        this.setCornerUV(this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax, this.uMin, this.vMax);
                    }
                }
                break;
            }
            case WEST: {
                switch (this.rotation) {
                    case 0: {
                        this.uMin = icon.func_94214_a(renderBlocks.field_147851_l * 16.0);
                        this.uMax = icon.func_94214_a(renderBlocks.field_147853_m * 16.0);
                        this.vMax = icon.func_94207_b(16.0 - (this.floatingIcon ? 1.0 : renderBlocks.field_147857_k) * 16.0);
                        this.vMin = icon.func_94207_b(16.0 - (this.floatingIcon ? 1.0 - (renderBlocks.field_147857_k - renderBlocks.field_147855_j) : renderBlocks.field_147855_j) * 16.0);
                        this.setCornerUV(this.uMin, this.vMax, this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax);
                        break;
                    }
                    case 1: {
                        this.uMin = icon.func_94214_a(16.0 - renderBlocks.field_147857_k * 16.0);
                        this.uMax = icon.func_94214_a(16.0 - renderBlocks.field_147855_j * 16.0);
                        this.vMin = icon.func_94207_b(16.0 - renderBlocks.field_147851_l * 16.0);
                        this.vMax = icon.func_94207_b(16.0 - renderBlocks.field_147853_m * 16.0);
                        this.setCornerUV(this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax, this.uMin, this.vMax);
                        break;
                    }
                    case 2: {
                        this.uMin = icon.func_94214_a(16.0 - renderBlocks.field_147851_l * 16.0);
                        this.uMax = icon.func_94214_a(16.0 - renderBlocks.field_147853_m * 16.0);
                        this.vMin = icon.func_94207_b(renderBlocks.field_147855_j * 16.0);
                        this.vMax = icon.func_94207_b(renderBlocks.field_147857_k * 16.0);
                        this.setCornerUV(this.uMin, this.vMax, this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax);
                        break;
                    }
                    case 3: {
                        this.uMin = icon.func_94214_a(renderBlocks.field_147857_k * 16.0);
                        this.uMax = icon.func_94214_a(renderBlocks.field_147855_j * 16.0);
                        this.vMin = icon.func_94207_b(renderBlocks.field_147851_l * 16.0);
                        this.vMax = icon.func_94207_b(renderBlocks.field_147853_m * 16.0);
                        this.setCornerUV(this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax, this.uMin, this.vMax);
                    }
                }
                break;
            }
            case EAST: {
                switch (this.rotation) {
                    case 0: {
                        this.uMin = icon.func_94214_a(16.0 - renderBlocks.field_147853_m * 16.0);
                        this.uMax = icon.func_94214_a(16.0 - renderBlocks.field_147851_l * 16.0);
                        this.vMax = icon.func_94207_b(16.0 - (this.floatingIcon ? 1.0 : renderBlocks.field_147857_k) * 16.0);
                        this.vMin = icon.func_94207_b(16.0 - (this.floatingIcon ? 1.0 - (renderBlocks.field_147857_k - renderBlocks.field_147855_j) : renderBlocks.field_147855_j) * 16.0);
                        this.setCornerUV(this.uMin, this.vMax, this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax);
                        break;
                    }
                    case 1: {
                        this.uMin = icon.func_94214_a(16.0 - renderBlocks.field_147857_k * 16.0);
                        this.uMax = icon.func_94214_a(16.0 - renderBlocks.field_147855_j * 16.0);
                        this.vMin = icon.func_94207_b(renderBlocks.field_147853_m * 16.0);
                        this.vMax = icon.func_94207_b(renderBlocks.field_147851_l * 16.0);
                        this.setCornerUV(this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax, this.uMin, this.vMax);
                        break;
                    }
                    case 2: {
                        this.uMin = icon.func_94214_a(renderBlocks.field_147853_m * 16.0);
                        this.uMax = icon.func_94214_a(renderBlocks.field_147851_l * 16.0);
                        this.vMin = icon.func_94207_b(renderBlocks.field_147855_j * 16.0);
                        this.vMax = icon.func_94207_b(renderBlocks.field_147857_k * 16.0);
                        this.setCornerUV(this.uMin, this.vMax, this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax);
                        break;
                    }
                    case 3: {
                        this.uMin = icon.func_94214_a(renderBlocks.field_147857_k * 16.0);
                        this.uMax = icon.func_94214_a(renderBlocks.field_147855_j * 16.0);
                        this.vMin = icon.func_94207_b(16.0 - renderBlocks.field_147853_m * 16.0);
                        this.vMax = icon.func_94207_b(16.0 - renderBlocks.field_147851_l * 16.0);
                        this.setCornerUV(this.uMin, this.vMin, this.uMax, this.vMin, this.uMax, this.vMax, this.uMin, this.vMax);
                    }
                }
                break;
            }
        }
    }

    public void renderFaceYNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.DOWN, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uTR, this.vTR, 3);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uTL, this.vTL, 0);
    }

    public void renderFaceYPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.UP, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uBR, this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
    }

    public void renderFaceZNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 0);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 3);
    }

    public void renderFaceZPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.SOUTH, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 0);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 3);
    }

    public void renderFaceXNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.WEST, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 0);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
    }

    public void renderFaceXPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.EAST, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 3);
    }

    public void triangleRenderFaceZNegXPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.floatingIcon ? this.vTL : this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 3);
    }

    public void triangleRenderFaceZNegXNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 0);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.floatingIcon ? this.vTR : this.vBR, 2);
    }

    public void triangleRenderFaceZPosXNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.SOUTH, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.floatingIcon ? this.vTL : this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 3);
    }

    public void triangleRenderFaceZPosXPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.SOUTH, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.floatingIcon ? this.vTR : this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 0);
    }

    public void triangleRenderFaceXNegZNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.WEST, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.floatingIcon ? this.vTL : this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
    }

    public void triangleRenderFaceXNegZPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.WEST, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 0);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.floatingIcon ? this.vTR : this.vBR, 2);
    }

    public void triangleRenderFaceXPosZPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.EAST, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.floatingIcon ? this.vTL : this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 3);
    }

    public void triangleRenderFaceXPosZNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.EAST, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.floatingIcon ? this.vTR : this.vBR, 2);
    }

    public void orthoWedgeRenderFaceYNeg(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.DOWN, x, y, z, icon);
        switch (slopeID) {
            case 1: 
            case 29: 
            case 41: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uTR, this.vTR, 3);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uTL, this.vTL, 0);
                break;
            }
            case 3: 
            case 31: 
            case 43: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uTL, this.vTL, 0);
                break;
            }
            case 2: 
            case 30: 
            case 42: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uTR, this.vTR, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uTL, this.vTL, 0);
                break;
            }
            case 0: 
            case 28: 
            case 40: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uTR, this.vTR, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
            }
        }
    }

    public void orthoWedgeRenderFaceYPos(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.UP, x, y, z, icon);
        switch (slopeID) {
            case 1: 
            case 33: 
            case 37: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
                break;
            }
            case 3: 
            case 35: 
            case 39: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uBR, this.vBR, 2);
                break;
            }
            case 2: 
            case 34: 
            case 38: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
                break;
            }
            case 0: 
            case 32: 
            case 36: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
            }
        }
    }

    public void orthoWedgeRenderFaceZNeg(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        Slope slope = Slope.getSlopeById(slopeID);
        if (slope.isPositive) {
            if (slope.facings.contains(ForgeDirection.WEST)) {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.floatingIcon ? this.vTR : this.vBR, 2);
            } else {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.floatingIcon ? this.vTL : this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 3);
            }
        } else if (slope.facings.contains(ForgeDirection.WEST)) {
            this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 0);
            this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
            this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 3);
        } else {
            this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 0);
            this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
            this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 3);
        }
    }

    public void orthoWedgeRenderFaceZPos(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.SOUTH, x, y, z, icon);
        Slope slope = Slope.getSlopeById(slopeID);
        if (slope.isPositive) {
            if (slope.facings.contains(ForgeDirection.WEST)) {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.floatingIcon ? this.vTL : this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 3);
            } else {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.floatingIcon ? this.vTR : this.vBR, 2);
            }
        } else if (slope.facings.contains(ForgeDirection.WEST)) {
            this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 0);
            this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 2);
            this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 3);
        } else {
            this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 0);
            this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 1);
            this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 3);
        }
    }

    public void orthoWedgeRenderFaceXNeg(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.WEST, x, y, z, icon);
        Slope slope = Slope.getSlopeById(slopeID);
        if (slope.isPositive) {
            if (slope.facings.contains(ForgeDirection.NORTH)) {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.floatingIcon ? this.vTL : this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
            } else {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.floatingIcon ? this.vTR : this.vBR, 2);
            }
        } else if (slope.facings.contains(ForgeDirection.NORTH)) {
            this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
            this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 0);
            this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 2);
        } else {
            this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
            this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 0);
            this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 1);
        }
    }

    public void orthoWedgeRenderFaceXPos(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.EAST, x, y, z, icon);
        Slope slope = Slope.getSlopeById(slopeID);
        if (slope.isPositive) {
            if (slope.facings.contains(ForgeDirection.NORTH)) {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.floatingIcon ? this.vTR : this.vBR, 2);
            } else {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.floatingIcon ? this.vTL : this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 3);
            }
        } else if (slope.facings.contains(ForgeDirection.NORTH)) {
            this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 1);
            this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 3);
            this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
        } else {
            this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 2);
            this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 3);
            this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
        }
    }

    public void prismRenderSlopeYNegZNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        double uBM = this.uBR - (this.uBR - this.uBL) / 2.0;
        double xMid = this.xMax - (this.xMax - this.xMin) / 2.0;
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 1);
        this.setupVertex(renderBlocks, xMid, this.yMin, this.zMax, uBM, this.vBR, 4);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 2);
    }

    public void prismRenderSlopeYNegZPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.SOUTH, x, y, z, icon);
        double uBM = this.uBR - (this.uBR - this.uBL) / 2.0;
        double xMid = this.xMax - (this.xMax - this.xMin) / 2.0;
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 3);
        this.setupVertex(renderBlocks, xMid, this.yMin, this.zMin, uBM, this.vBR, 5);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 0);
    }

    public void prismRenderSlopeYNegXNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.WEST, x, y, z, icon);
        double uBM = this.uBR - (this.uBR - this.uBL) / 2.0;
        double zMid = this.zMax - (this.zMax - this.zMin) / 2.0;
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 2);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, zMid, uBM, this.vBR, 6);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
    }

    public void prismRenderSlopeYNegXPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.EAST, x, y, z, icon);
        double uBM = this.uBR - (this.uBR - this.uBL) / 2.0;
        double zMid = this.zMax - (this.zMax - this.zMin) / 2.0;
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, zMid, uBM, this.vBR, 7);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 1);
    }

    public void prismRenderSlopeYPosZNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        double uTM = this.uTR - (this.uTR - this.uTL) / 2.0;
        double xMid = this.xMax - (this.xMax - this.xMin) / 2.0;
        this.setupVertex(renderBlocks, xMid, this.yMax, this.zMax, uTM, this.vTL, 4);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
    }

    public void prismRenderSlopeYPosZPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.SOUTH, x, y, z, icon);
        double uTM = this.uTR - (this.uTR - this.uTL) / 2.0;
        double xMid = this.xMax - (this.xMax - this.xMin) / 2.0;
        this.setupVertex(renderBlocks, xMid, this.yMax, this.zMin, uTM, this.vTL, 5);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 3);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 0);
    }

    public void prismRenderSlopeYPosXNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.WEST, x, y, z, icon);
        double uTM = this.uTR - (this.uTR - this.uTL) / 2.0;
        double zMid = this.zMax - (this.zMax - this.zMin) / 2.0;
        this.setupVertex(renderBlocks, this.xMax, this.yMax, zMid, uTM, this.vTL, 6);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 2);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 3);
    }

    public void prismRenderSlopeYPosXPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.EAST, x, y, z, icon);
        double uTM = this.uTR - (this.uTR - this.uTL) / 2.0;
        double zMid = this.zMax - (this.zMax - this.zMin) / 2.0;
        this.setupVertex(renderBlocks, this.xMin, this.yMax, zMid, uTM, this.vTR, 7);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 0);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 1);
    }

    public void prismRenderWestPointSlopeZNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
    }

    public void prismRenderWestPointSlopeZPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.SOUTH, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 2);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 3);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 1);
    }

    public void prismRenderEastPointSlopeZNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
    }

    public void prismRenderEastPointSlopeZPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.SOUTH, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 2);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 0);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 1);
    }

    public void prismRenderNorthPointSlopeXNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.WEST, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 1);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 2);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 0);
    }

    public void prismRenderNorthPointSlopeXPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.EAST, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 3);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 1);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 2);
    }

    public void prismRenderSouthPointSlopeXNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.WEST, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 1);
        this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 3);
        this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 0);
    }

    public void prismRenderSouthPointSlopeXPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.EAST, x, y, z, icon);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 3);
        this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 0);
        this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 2);
    }

    public void oblWedgeRenderSlopeZNeg(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        switch (slopeID) {
            case 8: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
                break;
            }
            case 4: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 0);
                break;
            }
            case 1: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
                break;
            }
            case 2: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 3);
            }
        }
    }

    public void oblWedgeRenderSlopeZPos(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.SOUTH, x, y, z, icon);
        switch (slopeID) {
            case 9: {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 3);
                break;
            }
            case 5: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 0);
                break;
            }
            case 3: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 3);
                break;
            }
            case 0: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 3);
            }
        }
    }

    public void oblWedgeRenderSlopeXNeg(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.WEST, x, y, z, icon);
        switch (slopeID) {
            case 10: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 3);
                break;
            }
            case 6: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 0);
            }
        }
    }

    public void oblWedgeRenderSlopeXPos(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.EAST, x, y, z, icon);
        switch (slopeID) {
            case 11: {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 3);
                break;
            }
            case 7: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
            }
        }
    }

    public void prismRenderWedgeSlopeZNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.oblWedgeRenderSlopeZNeg(renderBlocks, 8, x, y, z, icon);
    }

    public void prismRenderWedgeSlopeZPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.oblWedgeRenderSlopeZPos(renderBlocks, 9, x, y, z, icon);
    }

    public void prismRenderWedgeSlopeXNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.oblWedgeRenderSlopeXNeg(renderBlocks, 10, x, y, z, icon);
    }

    public void prismRenderWedgeSlopeXPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.oblWedgeRenderSlopeXPos(renderBlocks, 11, x, y, z, icon);
    }

    public void obliqueRenderIntObliqueYNeg(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        double uMI = this.uTR - (this.uTR - this.uTL) / 2.0;
        double vMI = this.rotation % 2 == 0 ? this.vTL : this.vBR - (this.vBR - this.vBL) / 2.0;
        switch (slopeID) {
            case 29: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, uMI, vMI, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                break;
            }
            case 31: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, uMI, vMI, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 0);
                break;
            }
            case 30: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, uMI, vMI, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 0);
                break;
            }
            case 28: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 3);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, uMI, vMI, 0);
            }
        }
    }

    public void obliqueRenderIntObliqueYPos(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        boolean altRot = this.rotation % 2 == 0;
        double uMI = !altRot ? this.uBL : this.uTR - (this.uTR - this.uTL) / 2.0;
        double vMI = altRot ? this.vBR : this.vBR - (this.vBR - this.vBL) / 2.0;
        switch (slopeID) {
            case 33: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, uMI, vMI, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
                break;
            }
            case 35: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 0);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, uMI, vMI, 3);
                break;
            }
            case 34: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, uMI, vMI, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 2);
                break;
            }
            case 32: {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, uMI, vMI, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 3);
            }
        }
    }

    public void obliqueRenderExtObliqueYNegLeft(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        double uTOP_MIDDLE = this.uTR;
        double uTOP_RIGHT_MIDDLE = uTOP_MIDDLE - (this.uTR - this.uTL) / 2.0;
        double xMid = this.xMax - (this.xMax - this.xMin) / 2.0;
        double zMid = this.zMax - (this.zMax - this.zMin) / 2.0;
        switch (slopeID) {
            case 37: {
                this.setupVertex(renderBlocks, xMid, this.yMax, zMid, uTOP_MIDDLE, this.vTR, 4);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, uTOP_RIGHT_MIDDLE, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, uTOP_MIDDLE, this.vBL, 1);
                break;
            }
            case 39: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, uTOP_RIGHT_MIDDLE, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, uTOP_MIDDLE, this.vBL, 1);
                this.setupVertex(renderBlocks, xMid, this.yMax, zMid, uTOP_MIDDLE, this.vTR, 4);
                break;
            }
            case 38: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, uTOP_MIDDLE, this.vBL, 1);
                this.setupVertex(renderBlocks, xMid, this.yMax, zMid, uTOP_MIDDLE, this.vTR, 4);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, uTOP_RIGHT_MIDDLE, this.vTL, 0);
                break;
            }
            case 36: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, uTOP_RIGHT_MIDDLE, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, uTOP_MIDDLE, this.vBL, 1);
                this.setupVertex(renderBlocks, xMid, this.yMax, zMid, uTOP_MIDDLE, this.vTR, 4);
            }
        }
    }

    public void obliqueRenderExtObliqueYNegRight(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        double uTOP_MIDDLE = this.uTR - (this.uTR - this.uTL) / 2.0;
        double uTOP_LEFT_MIDDLE = uTOP_MIDDLE - (this.uTR - this.uTL) / 2.0;
        double xMid = this.xMax - (this.xMax - this.xMin) / 2.0;
        double zMid = this.zMax - (this.zMax - this.zMin) / 2.0;
        switch (slopeID) {
            case 37: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, uTOP_MIDDLE, this.vTR, 3);
                this.setupVertex(renderBlocks, xMid, this.yMax, zMid, uTOP_LEFT_MIDDLE, this.vTL, 4);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, uTOP_LEFT_MIDDLE, this.vBL, 1);
                break;
            }
            case 39: {
                this.setupVertex(renderBlocks, xMid, this.yMax, zMid, uTOP_LEFT_MIDDLE, this.vTL, 4);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, uTOP_LEFT_MIDDLE, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, uTOP_MIDDLE, this.vTR, 3);
                break;
            }
            case 38: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, uTOP_LEFT_MIDDLE, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, uTOP_MIDDLE, this.vTR, 3);
                this.setupVertex(renderBlocks, xMid, this.yMax, zMid, uTOP_LEFT_MIDDLE, this.vTL, 4);
                break;
            }
            case 36: {
                this.setupVertex(renderBlocks, xMid, this.yMax, zMid, uTOP_LEFT_MIDDLE, this.vTL, 4);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, uTOP_LEFT_MIDDLE, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, uTOP_MIDDLE, this.vTR, 3);
            }
        }
    }

    public void obliqueRenderExtObliqueYPosLeft(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        double uMI1 = this.uBR;
        double uMI2 = uMI1 - (this.uBR - this.uBL) / 2.0;
        double xMid = this.xMax - (this.xMax - this.xMin) / 2.0;
        double zMid = this.zMax - (this.zMax - this.zMin) / 2.0;
        switch (slopeID) {
            case 41: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, uMI1, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, uMI2, this.vBL, 1);
                this.setupVertex(renderBlocks, xMid, this.yMin, zMid, uMI1, this.vBR, 5);
                break;
            }
            case 43: {
                this.setupVertex(renderBlocks, xMid, this.yMin, zMid, uMI1, this.vBR, 5);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, uMI1, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, uMI2, this.vBL, 1);
                break;
            }
            case 42: {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, uMI2, this.vBL, 1);
                this.setupVertex(renderBlocks, xMid, this.yMin, zMid, uMI1, this.vBR, 5);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, uMI1, this.vTL, 0);
                break;
            }
            case 40: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, uMI1, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, uMI2, this.vBL, 1);
                this.setupVertex(renderBlocks, xMid, this.yMin, zMid, uMI1, this.vBR, 5);
            }
        }
    }

    public void obliqueRenderExtObliqueYPosRight(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        double uBOTTOM_MIDDLE = this.uBR - (this.uBR - this.uBL) / 2.0;
        double uBOTTOM_LEFT_MIDDLE = uBOTTOM_MIDDLE - (this.uBR - this.uBL) / 2.0;
        double xMid = this.xMax - (this.xMax - this.xMin) / 2.0;
        double zMid = this.zMax - (this.zMax - this.zMin) / 2.0;
        switch (slopeID) {
            case 41: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, uBOTTOM_LEFT_MIDDLE, this.vTL, 0);
                this.setupVertex(renderBlocks, xMid, this.yMin, zMid, uBOTTOM_LEFT_MIDDLE, this.vBL, 5);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, uBOTTOM_MIDDLE, this.vBR, 2);
                break;
            }
            case 43: {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, uBOTTOM_MIDDLE, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, uBOTTOM_LEFT_MIDDLE, this.vTL, 0);
                this.setupVertex(renderBlocks, xMid, this.yMin, zMid, uBOTTOM_LEFT_MIDDLE, this.vBL, 5);
                break;
            }
            case 42: {
                this.setupVertex(renderBlocks, xMid, this.yMin, zMid, uBOTTOM_LEFT_MIDDLE, this.vBL, 5);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, uBOTTOM_MIDDLE, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, uBOTTOM_LEFT_MIDDLE, this.vTL, 0);
                break;
            }
            case 40: {
                this.setupVertex(renderBlocks, xMid, this.yMin, zMid, uBOTTOM_LEFT_MIDDLE, this.vBL, 5);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, uBOTTOM_MIDDLE, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, uBOTTOM_LEFT_MIDDLE, this.vTL, 0);
            }
        }
    }

    public void cornerRenderSlopeZNeg(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        switch (slopeID) {
            case 13: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 0);
                break;
            }
            case 14: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 3);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 0);
                break;
            }
            case 21: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 0);
                break;
            }
            case 22: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 1);
                break;
            }
            case 17: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
                break;
            }
            case 18: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
                break;
            }
            case 25: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                break;
            }
            case 26: {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
            }
        }
    }

    public void cornerRenderSlopeZPos(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.SOUTH, x, y, z, icon);
        switch (slopeID) {
            case 15: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 1);
                break;
            }
            case 12: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 0);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 1);
                break;
            }
            case 23: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 3);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 0);
                break;
            }
            case 20: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 0);
                break;
            }
            case 19: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 3);
                break;
            }
            case 16: {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 2);
                break;
            }
            case 27: {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 3);
                break;
            }
            case 24: {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 0);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 3);
            }
        }
    }

    public void cornerRenderSlopeXNeg(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.WEST, x, y, z, icon);
        switch (slopeID) {
            case 13: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 0);
                break;
            }
            case 15: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 0);
                break;
            }
            case 21: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 0);
                break;
            }
            case 23: {
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
                break;
            }
            case 17: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 2);
                break;
            }
            case 19: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 3);
                break;
            }
            case 25: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 0);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 3);
                break;
            }
            case 27: {
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 3);
            }
        }
    }

    public void cornerRenderSlopeXPos(RenderBlocks renderBlocks, int slopeID, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.EAST, x, y, z, icon);
        switch (slopeID) {
            case 14: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 1);
                break;
            }
            case 12: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 3);
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                break;
            }
            case 22: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 3);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                break;
            }
            case 20: {
                this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 1);
                this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
                break;
            }
            case 18: {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 3);
                break;
            }
            case 16: {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 0);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 2);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 3);
                break;
            }
            case 26: {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 3);
                break;
            }
            case 24: {
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 0);
                this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 1);
                this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 2);
            }
        }
    }

    public void collapsibleRenderSlopeYNegZNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.DOWN, x, y, z, icon);
        double uTM = this.uTR - (this.uTR - this.uTL) / 2.0;
        double xMid = this.xMax - (this.xMax - this.xMin) / 2.0;
        this.setupVertex(renderBlocks, this.xMin, y + 1.0 - CollapsibleUtil.offset_XZNN, this.zMin, this.uBR, this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMax, y + 1.0 - CollapsibleUtil.offset_XZPN, this.zMin, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, xMid, y + 1.0 - CollapsibleUtil.CENTER_YMAX, this.zMax, uTM, this.vTR, 4);
    }

    public void collapsibleRenderSlopeYNegZPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.DOWN, x, y, z, icon);
        double uBM = this.uBR - (this.uBR - this.uBL) / 2.0;
        double xMid = this.xMax - (this.xMax - this.xMin) / 2.0;
        this.setupVertex(renderBlocks, this.xMin, y + 1.0 - CollapsibleUtil.offset_XZNP, this.zMax, this.uTR, this.vTR, 3);
        this.setupVertex(renderBlocks, xMid, y + 1.0 - CollapsibleUtil.CENTER_YMAX, this.zMin, uBM, this.vBR, 5);
        this.setupVertex(renderBlocks, this.xMax, y + 1.0 - CollapsibleUtil.offset_XZPP, this.zMax, this.uTL, this.vTL, 0);
    }

    public void collapsibleRenderSlopeYPosZNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.UP, x, y, z, icon);
        double uTM = this.uTR - (this.uTR - this.uTL) / 2.0;
        double xMid = this.xMax - (this.xMax - this.xMin) / 2.0;
        this.setupVertex(renderBlocks, xMid, y + CollapsibleUtil.CENTER_YMAX, this.zMax, uTM, this.vTR, 4);
        this.setupVertex(renderBlocks, this.xMax, y + CollapsibleUtil.offset_XZPN, this.zMin, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMin, y + CollapsibleUtil.offset_XZNN, this.zMin, this.uBR, this.vBR, 2);
    }

    public void collapsibleRenderSlopeYPosZPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.UP, x, y, z, icon);
        double uBM = this.uBR - (this.uBR - this.uBL) / 2.0;
        double xMid = this.xMax - (this.xMax - this.xMin) / 2.0;
        this.setupVertex(renderBlocks, this.xMax, y + CollapsibleUtil.offset_XZPP, this.zMax, this.uTL, this.vTL, 0);
        this.setupVertex(renderBlocks, xMid, y + CollapsibleUtil.CENTER_YMAX, this.zMin, uBM, this.vBR, 5);
        this.setupVertex(renderBlocks, this.xMin, y + CollapsibleUtil.offset_XZNP, this.zMax, this.uTR, this.vTR, 3);
    }

    public void collapsibleRenderSlopeXNegYNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.DOWN, x, y, z, icon);
        double vLM = this.vBL - (this.vBL - this.vTL) / 2.0;
        double zMid = this.zMax - (this.zMax - this.zMin) / 2.0;
        this.setupVertex(renderBlocks, this.xMin, y + 1.0 - CollapsibleUtil.offset_XZNP, this.zMax, this.uTR, this.vTR, 3);
        this.setupVertex(renderBlocks, this.xMin, y + 1.0 - CollapsibleUtil.offset_XZNN, this.zMin, this.uBR, this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMax, y + 1.0 - CollapsibleUtil.CENTER_YMAX, zMid, this.uBL, vLM, 6);
    }

    public void collapsibleRenderSlopeXPosYNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.DOWN, x, y, z, icon);
        double vRM = this.vBR - (this.vBR - this.vTR) / 2.0;
        double zMid = this.zMax - (this.zMax - this.zMin) / 2.0;
        this.setupVertex(renderBlocks, this.xMin, y + 1.0 - CollapsibleUtil.CENTER_YMAX, zMid, this.uBR, vRM, 7);
        this.setupVertex(renderBlocks, this.xMax, y + 1.0 - CollapsibleUtil.offset_XZPN, this.zMin, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMax, y + 1.0 - CollapsibleUtil.offset_XZPP, this.zMax, this.uTL, this.vTL, 0);
    }

    public void collapsibleRenderSlopeXNegYPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.UP, x, y, z, icon);
        double vLM = this.vBL - (this.vBL - this.vTL) / 2.0;
        double zMid = this.zMax - (this.zMax - this.zMin) / 2.0;
        this.setupVertex(renderBlocks, this.xMax, y + CollapsibleUtil.CENTER_YMAX, zMid, this.uBL, vLM, 6);
        this.setupVertex(renderBlocks, this.xMin, y + CollapsibleUtil.offset_XZNN, this.zMin, this.uBR, this.vBR, 2);
        this.setupVertex(renderBlocks, this.xMin, y + CollapsibleUtil.offset_XZNP, this.zMax, this.uTR, this.vTR, 3);
    }

    public void collapsibleRenderSlopeXPosYPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        this.prepareRender(renderBlocks, ForgeDirection.UP, x, y, z, icon);
        double vRM = this.vBR - (this.vBR - this.vTR) / 2.0;
        double zMid = this.zMax - (this.zMax - this.zMin) / 2.0;
        this.setupVertex(renderBlocks, this.xMax, y + CollapsibleUtil.offset_XZPP, this.zMax, this.uTL, this.vTL, 0);
        this.setupVertex(renderBlocks, this.xMax, y + CollapsibleUtil.offset_XZPN, this.zMin, this.uBL, this.vBL, 1);
        this.setupVertex(renderBlocks, this.xMin, y + CollapsibleUtil.CENTER_YMAX, zMid, this.uBR, vRM, 7);
    }

    public void collapsibleRenderFaceZNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon, boolean isPositive) {
        this.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        if (isPositive) {
            if (this.floatingIcon) {
                this.vBL = this.vTL - (this.vTL - this.vBL) * CollapsibleUtil.offset_XZPN;
                this.vBR = this.vTR - (this.vTR - this.vBR) * CollapsibleUtil.offset_XZNN;
            } else {
                this.vTL = this.vBL + (this.vTL - this.vBL) * CollapsibleUtil.offset_XZPN;
                this.vTR = this.vBR + (this.vTR - this.vBR) * CollapsibleUtil.offset_XZNN;
            }
            this.setupVertex(renderBlocks, this.xMax, this.yMin + CollapsibleUtil.offset_XZPN, this.zMin, this.uTL, this.vTL, 0);
            this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBL, this.vBL, 1);
            this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBR, this.vBR, 2);
            this.setupVertex(renderBlocks, this.xMin, this.yMin + CollapsibleUtil.offset_XZNN, this.zMin, this.uTR, this.vTR, 3);
        } else {
            this.vBL = this.vTL - (this.vTL - this.vBL) * CollapsibleUtil.offset_XZPN;
            this.vBR = this.vTR - (this.vTR - this.vBR) * CollapsibleUtil.offset_XZNN;
            this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTL, this.vTL, 0);
            this.setupVertex(renderBlocks, this.xMax, this.yMax - CollapsibleUtil.offset_XZPN, this.zMin, this.uBL, this.vBL, 1);
            this.setupVertex(renderBlocks, this.xMin, this.yMax - CollapsibleUtil.offset_XZNN, this.zMin, this.uBR, this.vBR, 2);
            this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTR, this.vTR, 3);
        }
    }

    public void collapsibleRenderFaceZPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon, boolean isPositive) {
        this.prepareRender(renderBlocks, ForgeDirection.SOUTH, x, y, z, icon);
        if (isPositive) {
            if (this.floatingIcon) {
                this.vBL = this.vTL - (this.vTL - this.vBL) * CollapsibleUtil.offset_XZNP;
                this.vBR = this.vTR - (this.vTR - this.vBR) * CollapsibleUtil.offset_XZPP;
            } else {
                this.vTL = this.vBL + (this.vTL - this.vBL) * CollapsibleUtil.offset_XZNP;
                this.vTR = this.vBR + (this.vTR - this.vBR) * CollapsibleUtil.offset_XZPP;
            }
            this.setupVertex(renderBlocks, this.xMin, this.yMin + CollapsibleUtil.offset_XZNP, this.zMax, this.uTL, this.vTL, 0);
            this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBL, this.vBL, 1);
            this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBR, this.vBR, 2);
            this.setupVertex(renderBlocks, this.xMax, this.yMin + CollapsibleUtil.offset_XZPP, this.zMax, this.uTR, this.vTR, 3);
        } else {
            this.vBL = this.vTL - (this.vTL - this.vBL) * CollapsibleUtil.offset_XZNP;
            this.vBR = this.vTR - (this.vTR - this.vBR) * CollapsibleUtil.offset_XZPP;
            this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTL, this.vTL, 0);
            this.setupVertex(renderBlocks, this.xMin, this.yMax - CollapsibleUtil.offset_XZNP, this.zMax, this.uBL, this.vBL, 1);
            this.setupVertex(renderBlocks, this.xMax, this.yMax - CollapsibleUtil.offset_XZPP, this.zMax, this.uBR, this.vBR, 2);
            this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTR, this.vTR, 3);
        }
    }

    public void collapsibleRenderFaceXNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon, boolean isPositive) {
        this.prepareRender(renderBlocks, ForgeDirection.WEST, x, y, z, icon);
        if (isPositive) {
            if (this.floatingIcon) {
                this.vBL = this.vTL - (this.vTL - this.vBL) * CollapsibleUtil.offset_XZNN;
                this.vBR = this.vTR - (this.vTR - this.vBR) * CollapsibleUtil.offset_XZNP;
            } else {
                this.vTL = this.vBL + (this.vTL - this.vBL) * CollapsibleUtil.offset_XZNN;
                this.vTR = this.vBR + (this.vTR - this.vBR) * CollapsibleUtil.offset_XZNP;
            }
            this.setupVertex(renderBlocks, this.xMin, this.yMin + CollapsibleUtil.offset_XZNN, this.zMin, this.uTL, this.vTL, 0);
            this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMin, this.uBL, this.vBL, 1);
            this.setupVertex(renderBlocks, this.xMin, this.yMin, this.zMax, this.uBR, this.vBR, 2);
            this.setupVertex(renderBlocks, this.xMin, this.yMin + CollapsibleUtil.offset_XZNP, this.zMax, this.uTR, this.vTR, 3);
        } else {
            this.vBL = this.vTL - (this.vTL - this.vBL) * CollapsibleUtil.offset_XZNN;
            this.vBR = this.vTR - (this.vTR - this.vBR) * CollapsibleUtil.offset_XZNP;
            this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMin, this.uTL, this.vTL, 0);
            this.setupVertex(renderBlocks, this.xMin, this.yMax - CollapsibleUtil.offset_XZNN, this.zMin, this.uBL, this.vBL, 1);
            this.setupVertex(renderBlocks, this.xMin, this.yMax - CollapsibleUtil.offset_XZNP, this.zMax, this.uBR, this.vBR, 2);
            this.setupVertex(renderBlocks, this.xMin, this.yMax, this.zMax, this.uTR, this.vTR, 3);
        }
    }

    public void collapsibleRenderFaceXPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon, boolean isPositive) {
        this.prepareRender(renderBlocks, ForgeDirection.EAST, x, y, z, icon);
        if (isPositive) {
            if (this.floatingIcon) {
                this.vBL = this.vTL - (this.vTL - this.vBL) * CollapsibleUtil.offset_XZPP;
                this.vBR = this.vTR - (this.vTR - this.vBR) * CollapsibleUtil.offset_XZPN;
            } else {
                this.vTL = this.vBL + (this.vTL - this.vBL) * CollapsibleUtil.offset_XZPP;
                this.vTR = this.vBR + (this.vTR - this.vBR) * CollapsibleUtil.offset_XZPN;
            }
            this.setupVertex(renderBlocks, this.xMax, this.yMin + CollapsibleUtil.offset_XZPP, this.zMax, this.uTL, this.vTL, 0);
            this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMax, this.uBL, this.vBL, 1);
            this.setupVertex(renderBlocks, this.xMax, this.yMin, this.zMin, this.uBR, this.vBR, 2);
            this.setupVertex(renderBlocks, this.xMax, this.yMin + CollapsibleUtil.offset_XZPN, this.zMin, this.uTR, this.vTR, 3);
        } else {
            this.vBL = this.vTL - (this.vTL - this.vBL) * CollapsibleUtil.offset_XZPP;
            this.vBR = this.vTR - (this.vTR - this.vBR) * CollapsibleUtil.offset_XZPN;
            this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMax, this.uTL, this.vTL, 0);
            this.setupVertex(renderBlocks, this.xMax, this.yMax - CollapsibleUtil.offset_XZPP, this.zMax, this.uBL, this.vBL, 1);
            this.setupVertex(renderBlocks, this.xMax, this.yMax - CollapsibleUtil.offset_XZPN, this.zMin, this.uBR, this.vBR, 2);
            this.setupVertex(renderBlocks, this.xMax, this.yMax, this.zMin, this.uTR, this.vTR, 3);
        }
    }

    public void setPlantColor(BlockHandlerBase blockHandler, ItemStack itemStack, int x, int y, int z) {
        Block block = FlowerPotProperties.toBlock(itemStack);
        Tessellator tessellator = Tessellator.field_78398_a;
        float[] rgb = LightingHelper.getRGB(blockHandler.getBlockColor(block, itemStack.func_77960_j(), x, y, z, 1, null));
        blockHandler.lightingHelper.applyAnaglyph(rgb);
        tessellator.func_78386_a(rgb[0], rgb[1], rgb[2]);
        TEBase cfr_ignored_0 = blockHandler.TE;
        if (blockHandler.TE.hasAttribute((byte)24) && FlowerPotProperties.getPlantColor(blockHandler.TE) != 0xFFFFFF) {
            tessellator.func_78386_a(0.45f, 0.8f, 0.3f);
        }
    }

    public boolean renderBlockDoublePlant(TEBase TE, RenderBlocks renderBlocks, ItemStack itemStack, int x, int y, int z, boolean thin) {
        BlockDoublePlant block = (BlockDoublePlant)FlowerPotProperties.toBlock(itemStack);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(renderBlocks.field_147845_a, x, y, z));
        boolean thinPlant = itemStack.func_77977_a().equals("tile.doublePlant.grass");
        int metadata = itemStack.func_77960_j();
        IIcon icon_bottom = block.func_149888_a(false, metadata);
        if (thinPlant) {
            this.renderPlantThinCrossedSquares(renderBlocks, (Block)block, icon_bottom, x, y, z, false);
        } else {
            this.renderPlantCrossedSquares(renderBlocks, (Block)block, icon_bottom, x, y, z, 0.75f, false);
        }
        tessellator.func_78372_c(0.0f, 0.75f, 0.0f);
        IIcon icon_top = block.func_149888_a(true, metadata);
        if (thinPlant) {
            this.renderPlantThinCrossedSquares(renderBlocks, (Block)block, icon_top, x, y, z, false);
        } else {
            this.renderPlantCrossedSquares(renderBlocks, (Block)block, icon_top, x, y, z, 0.75f, false);
        }
        if (metadata == 0) {
            tessellator.func_78372_c(0.0f, -0.15f, 0.0f);
            IIcon icon_sunflower_top_front = block.field_149891_b[0];
            double angle = (double)FlowerPot.getAngle(TE) / 16.0 * 2.0 * Math.PI + 1.5707963267948966;
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            double uMin = icon_sunflower_top_front.func_94209_e();
            double vMin = icon_sunflower_top_front.func_94206_g();
            double uMax = icon_sunflower_top_front.func_94212_f();
            double vMax = icon_sunflower_top_front.func_94210_h();
            double d11 = 0.5 + 0.25 * cos - 0.45 * sin;
            double d12 = 0.5 + 0.45 * cos + 0.25 * sin;
            double d13 = 0.5 + 0.25 * cos + 0.45 * sin;
            double d14 = 0.5 + -0.45 * cos + 0.25 * sin;
            double d15 = 0.5 + -0.05 * cos + 0.45 * sin;
            double d16 = 0.5 + -0.45 * cos + -0.05 * sin;
            double d17 = 0.5 + -0.05 * cos - 0.45 * sin;
            double d18 = 0.5 + 0.45 * cos + -0.05 * sin;
            tessellator.func_78374_a((double)x + d15, (double)y + 1.0, (double)z + d16, uMin, vMax);
            tessellator.func_78374_a((double)x + d17, (double)y + 1.0, (double)z + d18, uMax, vMax);
            tessellator.func_78374_a((double)x + d11, (double)y + 0.0, (double)z + d12, uMax, vMin);
            tessellator.func_78374_a((double)x + d13, (double)y + 0.0, (double)z + d14, uMin, vMin);
            IIcon icon_sunflower_top_back = block.field_149891_b[1];
            uMin = icon_sunflower_top_back.func_94209_e();
            vMin = icon_sunflower_top_back.func_94206_g();
            uMax = icon_sunflower_top_back.func_94212_f();
            vMax = icon_sunflower_top_back.func_94210_h();
            tessellator.func_78374_a((double)x + d17, (double)y + 1.0, (double)z + d18, uMin, vMax);
            tessellator.func_78374_a((double)x + d15, (double)y + 1.0, (double)z + d16, uMax, vMax);
            tessellator.func_78374_a((double)x + d13, (double)y + 0.0, (double)z + d14, uMax, vMin);
            tessellator.func_78374_a((double)x + d11, (double)y + 0.0, (double)z + d12, uMin, vMin);
            tessellator.func_78372_c(0.0f, 0.15f, 0.0f);
        }
        tessellator.func_78372_c(0.0f, -0.75f, 0.0f);
        return true;
    }

    public boolean renderPlantCrossedSquares(RenderBlocks renderBlocks, Block block, IIcon icon, int x, int y, int z, float scale, boolean flip_vertical) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(renderBlocks.field_147845_a, x, y, z));
        double uMin = icon.func_94209_e();
        double vMin = icon.func_94206_g();
        double uMax = icon.func_94212_f();
        double vMax = icon.func_94210_h();
        double rotation = 0.45 * (double)scale;
        double xMin = (double)x + 0.5 - rotation;
        double xMax = (double)x + 0.5 + rotation;
        double zMin = (double)z + 0.5 - rotation;
        double zMax = (double)z + 0.5 + rotation;
        if (flip_vertical) {
            double temp = vMin;
            vMin = vMax;
            vMax = temp;
        }
        tessellator.func_78374_a(xMin, (double)y + (double)scale, zMin, uMin, vMin);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMin, uMin, vMax);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMax, uMax, vMax);
        tessellator.func_78374_a(xMax, (double)y + (double)scale, zMax, uMax, vMin);
        tessellator.func_78374_a(xMax, (double)y + (double)scale, zMax, uMin, vMin);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMax, uMin, vMax);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMin, uMax, vMax);
        tessellator.func_78374_a(xMin, (double)y + (double)scale, zMin, uMax, vMin);
        tessellator.func_78374_a(xMin, (double)y + (double)scale, zMax, uMin, vMin);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMax, uMin, vMax);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMin, uMax, vMax);
        tessellator.func_78374_a(xMax, (double)y + (double)scale, zMin, uMax, vMin);
        tessellator.func_78374_a(xMax, (double)y + (double)scale, zMin, uMin, vMin);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMin, uMin, vMax);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMax, uMax, vMax);
        tessellator.func_78374_a(xMin, (double)y + (double)scale, zMax, uMax, vMin);
        return true;
    }

    public void renderPlantThinCrossedSquares(RenderBlocks renderBlocks, Block block, IIcon icon, int x, int y, int z, boolean flip_vertical) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(renderBlocks.field_147845_a, x, y, z));
        double uMin = icon.func_94214_a(0.0);
        double uMax = icon.func_94214_a(4.0);
        double vMin = icon.func_94207_b(16.0);
        double vMax = icon.func_94207_b(0.0);
        double rotatedScaleFactor = 0.16875;
        double xMin = (double)x + 0.5 - rotatedScaleFactor;
        double xMax = (double)x + 0.5 + rotatedScaleFactor;
        double zMin = (double)z + 0.5 - rotatedScaleFactor;
        double zMax = (double)z + 0.5 + rotatedScaleFactor;
        if (flip_vertical) {
            double temp = vMin;
            vMin = vMax;
            vMax = temp;
        }
        tessellator.func_78374_a(xMin, (double)y + 0.75, zMin, uMin, vMax);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMin, uMin, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMax, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMax, vMax);
        tessellator.func_78374_a(xMax, (double)y + 0.75, zMin, uMin, vMax);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMin, uMin, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMax, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMax, vMax);
        tessellator.func_78374_a(xMax, (double)y + 0.75, zMax, uMin, vMax);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMax, uMin, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMax, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMax, vMax);
        tessellator.func_78374_a(xMin, (double)y + 0.75, zMax, uMin, vMax);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMax, uMin, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMax, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMax, vMax);
        uMin = icon.func_94214_a(12.0);
        uMax = icon.func_94214_a(16.0);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMin, vMax);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMin, vMin);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMin, uMax, vMin);
        tessellator.func_78374_a(xMin, (double)y + 0.75, zMin, uMax, vMax);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMin, vMax);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMin, vMin);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMin, uMax, vMin);
        tessellator.func_78374_a(xMax, (double)y + 0.75, zMin, uMax, vMax);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMin, vMax);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMin, vMin);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMax, uMax, vMin);
        tessellator.func_78374_a(xMax, (double)y + 0.75, zMax, uMax, vMax);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMin, vMax);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMin, vMin);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMax, uMax, vMin);
        tessellator.func_78374_a(xMin, (double)y + 0.75, zMax, uMax, vMax);
    }

    public void drawPlantCactus(LightingHelper lightingHelper, RenderBlocks renderBlocks, ItemStack itemStack, int x, int y, int z) {
        Block block = BlockProperties.toBlock(itemStack);
        IIcon icon = block.func_149733_h(2);
        double uMinL = icon.func_94214_a(0.0);
        double uMaxL = icon.func_94214_a(3.0);
        double uMinR = icon.func_94214_a(13.0);
        double uMaxR = icon.func_94214_a(16.0);
        double vMin = icon.func_94207_b(16.0);
        double vMax = icon.func_94207_b(0.0);
        renderBlocks.field_147863_w = true;
        renderBlocks.func_147782_a(0.375, 0.25, 0.375, 0.6875, 1.0, 0.6875);
        lightingHelper.setupLightingZNeg(itemStack, x, y, z);
        lightingHelper.setupColor(x, y, z, 2, 0xFFFFFF, icon);
        this.setupVertex(renderBlocks, (float)x + 0.6875f, (float)y + 0.75f, (float)z + 0.375f, uMinL, vMax, 0);
        this.setupVertex(renderBlocks, (float)x + 0.6875f, y, (float)z + 0.375f, uMinL, vMin, 1);
        this.setupVertex(renderBlocks, (float)x + 0.5f, y, (float)z + 0.375f, uMaxL, vMin, 5);
        this.setupVertex(renderBlocks, (float)x + 0.5f, (float)y + 0.75f, (float)z + 0.375f, uMaxL, vMax, 4);
        this.setupVertex(renderBlocks, (float)x + 0.5f, (float)y + 0.75f, (float)z + 0.375f, uMinR, vMax, 4);
        this.setupVertex(renderBlocks, (float)x + 0.5f, y, (float)z + 0.375f, uMinR, vMin, 5);
        this.setupVertex(renderBlocks, (float)x + 0.3125f, y, (float)z + 0.375f, uMaxR, vMin, 2);
        this.setupVertex(renderBlocks, (float)x + 0.3125f, (float)y + 0.75f, (float)z + 0.375f, uMaxR, vMax, 3);
        lightingHelper.setupLightingZPos(itemStack, x, y, z);
        lightingHelper.setupColor(x, y, z, 3, 0xFFFFFF, icon);
        this.setupVertex(renderBlocks, (float)x + 0.3125f, (float)y + 0.75f, (float)z + 0.625f, uMinL, vMax, 0);
        this.setupVertex(renderBlocks, (float)x + 0.3125f, y, (float)z + 0.625f, uMinL, vMin, 1);
        this.setupVertex(renderBlocks, (float)x + 0.5f, y, (float)z + 0.625f, uMaxL, vMin, 5);
        this.setupVertex(renderBlocks, (float)x + 0.5f, (float)y + 0.75f, (float)z + 0.625f, uMaxL, vMax, 4);
        this.setupVertex(renderBlocks, (float)x + 0.5f, (float)y + 0.75f, (float)z + 0.625f, uMinR, vMax, 4);
        this.setupVertex(renderBlocks, (float)x + 0.5f, y, (float)z + 0.625f, uMinR, vMin, 5);
        this.setupVertex(renderBlocks, (float)x + 0.6875f, y, (float)z + 0.625f, uMaxR, vMin, 2);
        this.setupVertex(renderBlocks, (float)x + 0.6875f, (float)y + 0.75f, (float)z + 0.625f, uMaxR, vMax, 3);
        lightingHelper.setupLightingXNeg(itemStack, x, y, z);
        lightingHelper.setupColor(x, y, z, 4, 0xFFFFFF, icon);
        this.setupVertex(renderBlocks, (float)x + 0.375f, (float)y + 0.75f, (float)z + 0.3125f, uMinL, vMax, 0);
        this.setupVertex(renderBlocks, (float)x + 0.375f, y, (float)z + 0.3125f, uMinL, vMin, 1);
        this.setupVertex(renderBlocks, (float)x + 0.375f, y, (float)z + 0.5f, uMaxL, vMin, 5);
        this.setupVertex(renderBlocks, (float)x + 0.375f, (float)y + 0.75f, (float)z + 0.5f, uMaxL, vMax, 4);
        this.setupVertex(renderBlocks, (float)x + 0.375f, (float)y + 0.75f, (float)z + 0.5f, uMinR, vMax, 4);
        this.setupVertex(renderBlocks, (float)x + 0.375f, y, (float)z + 0.5f, uMinR, vMin, 5);
        this.setupVertex(renderBlocks, (float)x + 0.375f, y, (float)z + 0.6875f, uMaxR, vMin, 2);
        this.setupVertex(renderBlocks, (float)x + 0.375f, (float)y + 0.75f, (float)z + 0.6875f, uMaxR, vMax, 3);
        lightingHelper.setupLightingXPos(itemStack, x, y, z);
        lightingHelper.setupColor(x, y, z, 5, 0xFFFFFF, icon);
        this.setupVertex(renderBlocks, (float)x + 0.625f, (float)y + 0.75f, (float)z + 0.6875f, uMinL, vMax, 0);
        this.setupVertex(renderBlocks, (float)x + 0.625f, y, (float)z + 0.6875f, uMinL, vMin, 1);
        this.setupVertex(renderBlocks, (float)x + 0.625f, y, (float)z + 0.5f, uMaxL, vMin, 5);
        this.setupVertex(renderBlocks, (float)x + 0.625f, (float)y + 0.75f, (float)z + 0.5f, uMaxL, vMax, 4);
        this.setupVertex(renderBlocks, (float)x + 0.625f, (float)y + 0.75f, (float)z + 0.5f, uMinR, vMax, 4);
        this.setupVertex(renderBlocks, (float)x + 0.625f, y, (float)z + 0.5f, uMinR, vMin, 5);
        this.setupVertex(renderBlocks, (float)x + 0.625f, y, (float)z + 0.3125f, uMaxR, vMin, 2);
        this.setupVertex(renderBlocks, (float)x + 0.625f, (float)y + 0.75f, (float)z + 0.3125f, uMaxR, vMax, 3);
        lightingHelper.setupLightingYPos(itemStack, x, y, z);
        lightingHelper.setupColor(x, y, z, 1, 0xFFFFFF, icon);
        icon = block.func_149733_h(1);
        double uMin = icon.func_94214_a(6.0);
        double uMax = icon.func_94214_a(10.0);
        vMin = icon.func_94207_b(10.0);
        vMax = icon.func_94207_b(6.0);
        this.setupVertex(renderBlocks, (float)x + 0.375f, (float)y + 0.75f, (float)z + 0.625f, uMin, vMin, 0);
        this.setupVertex(renderBlocks, (float)x + 0.625f, (float)y + 0.75f, (float)z + 0.625f, uMin, vMax, 1);
        this.setupVertex(renderBlocks, (float)x + 0.625f, (float)y + 0.75f, (float)z + 0.375f, uMax, vMax, 2);
        this.setupVertex(renderBlocks, (float)x + 0.375f, (float)y + 0.75f, (float)z + 0.375f, uMax, vMin, 3);
        renderBlocks.field_147863_w = false;
    }
}

