/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.api.audio;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.AudioPacketClientHandler;
import pl.asie.lib.audio.StreamingPlaybackManager;

public final class AudioPacketRegistry {
    public static final AudioPacketRegistry INSTANCE = new AudioPacketRegistry();
    private final TObjectIntMap<Class<? extends AudioPacket>> audioPacketIdMap = new TObjectIntHashMap();
    private final TIntObjectMap<AudioPacketClientHandler> audioPacketHandlerMap = new TIntObjectHashMap();
    private final TIntObjectMap<StreamingPlaybackManager> playbackManagerMap = new TIntObjectHashMap();
    private int nextTypeId;
    private int nextManagerId;

    private AudioPacketRegistry() {
    }

    public void registerType(Class<? extends AudioPacket> type) {
        this.audioPacketIdMap.put(type, this.nextTypeId++);
    }

    public int getId(Class<? extends AudioPacket> packetClass) {
        return this.audioPacketIdMap.get(packetClass);
    }

    public void registerClientHandler(Class<? extends AudioPacket> packetClass, AudioPacketClientHandler handler) {
        this.audioPacketHandlerMap.put(this.getId(packetClass), (Object)handler);
    }

    public AudioPacketClientHandler getClientHandler(int id) {
        return (AudioPacketClientHandler)this.audioPacketHandlerMap.get(id);
    }

    public int registerManager(StreamingPlaybackManager manager) {
        int managerId = this.nextManagerId++;
        this.playbackManagerMap.put(managerId, (Object)manager);
        return managerId;
    }

    public StreamingPlaybackManager getManager(int id) {
        return (StreamingPlaybackManager)this.playbackManagerMap.get(id);
    }
}

