/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.audio;

import java.io.IOException;
import java.util.Queue;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.IAudioSource;
import pl.asie.computronics.util.sound.AudioUtil;
import pl.asie.computronics.util.sound.Instruction;
import pl.asie.lib.network.Packet;

public class SoundCardPacket
extends AudioPacket {
    public final String address;
    public final Queue<Instruction> instructions;

    public SoundCardPacket(IAudioSource source, byte volume, String address, Queue<Instruction> instructions) {
        super(source, volume);
        this.address = address;
        this.instructions = instructions;
    }

    @Override
    protected void writeData(Packet packet) throws IOException {
        packet.writeString(this.address).writeInt(this.instructions.size());
        for (Instruction instruction : this.instructions) {
            if (instruction instanceof Instruction.Open) {
                packet.writeByte((byte)0).writeByte((byte)((Instruction.Open)instruction).channelIndex);
                continue;
            }
            if (instruction instanceof Instruction.Close) {
                packet.writeByte((byte)1).writeByte((byte)((Instruction.Close)instruction).channelIndex);
                continue;
            }
            if (instruction instanceof Instruction.SetWave) {
                packet.writeByte((byte)2).writeByte((byte)((Instruction.SetWave)instruction).channelIndex).writeInt(((Instruction.SetWave)instruction).type.ordinal());
                continue;
            }
            if (instruction instanceof Instruction.Delay) {
                packet.writeByte((byte)3).writeInt(((Instruction.Delay)instruction).delay);
                continue;
            }
            if (instruction instanceof Instruction.SetFM) {
                packet.writeByte((byte)4).writeByte((byte)((Instruction.SetFM)instruction).channelIndex).writeInt(((Instruction.SetFM)instruction).freqMod.modulatorIndex).writeFloat(((Instruction.SetFM)instruction).freqMod.index);
                continue;
            }
            if (instruction instanceof Instruction.ResetFM) {
                packet.writeByte((byte)5).writeByte((byte)((Instruction.ResetFM)instruction).channelIndex);
                continue;
            }
            if (instruction instanceof Instruction.SetAM) {
                packet.writeByte((byte)6).writeByte((byte)((Instruction.SetAM)instruction).channelIndex).writeInt(((Instruction.SetAM)instruction).ampMod.modulatorIndex);
                continue;
            }
            if (instruction instanceof Instruction.ResetAM) {
                packet.writeByte((byte)7).writeByte((byte)((Instruction.ResetAM)instruction).channelIndex);
                continue;
            }
            if (instruction instanceof Instruction.SetADSR) {
                AudioUtil.ADSR envelope = ((Instruction.SetADSR)instruction).envelope;
                packet.writeByte((byte)8).writeByte((byte)((Instruction.SetADSR)instruction).channelIndex).writeInt(envelope.attackDuration).writeInt(envelope.decayDuration).writeFloat(envelope.attenuation).writeInt(envelope.releaseDuration);
                continue;
            }
            if (instruction instanceof Instruction.ResetEnvelope) {
                packet.writeByte((byte)9).writeByte((byte)((Instruction.ResetEnvelope)instruction).channelIndex);
                continue;
            }
            if (instruction instanceof Instruction.SetVolume) {
                packet.writeByte((byte)10).writeByte((byte)((Instruction.SetVolume)instruction).channelIndex).writeFloat(((Instruction.SetVolume)instruction).volume);
                continue;
            }
            if (instruction instanceof Instruction.SetFrequency) {
                packet.writeByte((byte)11).writeByte((byte)((Instruction.SetFrequency)instruction).channelIndex).writeFloat(((Instruction.SetFrequency)instruction).frequency);
                continue;
            }
            if (instruction instanceof Instruction.SetWhiteNoise) {
                packet.writeByte((byte)12).writeByte((byte)((Instruction.SetWhiteNoise)instruction).channelIndex);
                continue;
            }
            if (!(instruction instanceof Instruction.SetLFSR)) continue;
            packet.writeByte((byte)13).writeByte((byte)((Instruction.SetLFSR)instruction).channelIndex).writeInt(((Instruction.SetLFSR)instruction).initial).writeInt(((Instruction.SetLFSR)instruction).mask);
        }
    }
}

