/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.block;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.oc.api.network.Environment;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.block.BlockPeripheral;
import pl.asie.computronics.client.LampRender;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tile.TileColorfulLamp;
import pl.asie.computronics.util.LampUtil;
import pl.asie.lib.block.BlockBase;
import pl.asie.lib.integration.Integration;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetInputNode;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.RedNetConnectionType;

@Optional.InterfaceList(value={@Optional.Interface(iface="powercrystals.minefactoryreloaded.api.rednet.IRedNetInputNode", modid="MineFactoryReloaded")})
public class BlockColorfulLamp
extends BlockPeripheral
implements IRedNetInputNode {
    public IIcon m0;
    public IIcon m1;
    private int renderingPass = 0;

    public BlockColorfulLamp() {
        super("colorful_lamp");
        this.func_149647_a(Computronics.tab);
        this.func_149663_c("computronics.colorfulLamp");
        this.setRotation(BlockBase.Rotation.NONE);
        this.field_149784_t = 15;
    }

    public TileEntity func_149915_a(World arg0, int arg1) {
        return new TileColorfulLamp();
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float _x, float _y, float _z) {
        ItemStack held;
        TileEntity tile;
        if (!world.field_72995_K && Mods.isLoaded("MineFactoryReloaded") && player.func_70093_af() && (tile = world.func_147438_o(x, y, z)) instanceof TileColorfulLamp && (held = player.func_71045_bC()) != null && held.func_77973_b() != null && Integration.isTool((ItemStack)held, (EntityPlayer)player, (int)x, (int)y, (int)z) && Integration.useTool((ItemStack)held, (EntityPlayer)player, (int)x, (int)y, (int)z)) {
            TileColorfulLamp lamp;
            lamp.setBinaryMode(!(lamp = (TileColorfulLamp)tile).isBinaryMode());
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.computronics.lamp.binary." + (lamp.isBinaryMode() ? "on" : "off"), new Object[0]));
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, side, _x, _y, _z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister r) {
        this.m0 = r.func_94245_a("computronics:lamp_layer_0");
        this.m1 = r.func_94245_a("computronics:lamp_layer_1");
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (Mods.isLoaded("ProjRed|Core") && tile instanceof TileColorfulLamp) {
            ((TileColorfulLamp)tile).onProjectRedBundledInputChanged();
        }
    }

    public void setLightValue(int value) {
        if (LampUtil.shouldColorLight()) {
            int r = ((value & 0x7C00) >>> 10) / 2;
            int g = ((value & 0x3E0) >>> 5) / 2;
            int b = (value & 0x1F) / 2;
            int n = value > Short.MAX_VALUE ? 15 : (r < 0 ? 0 : (r = r > 15 ? 15 : r));
            int n2 = value > Short.MAX_VALUE ? 15 : (g < 0 ? 0 : (g = g > 15 ? 15 : g));
            b = value > Short.MAX_VALUE ? 15 : (b < 0 ? 0 : (b > 15 ? 15 : b));
            int brightness = Math.max(Math.max(r, g), b);
            this.field_149784_t = brightness | (b << 15) + (g << 10) + (r << 5);
        } else {
            this.field_149784_t = value;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return LampRender.id();
    }

    public void setRenderingPass(int i) {
        this.renderingPass = i & 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.renderingPass == 1 ? this.m1 : this.m0;
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public RedNetConnectionType getConnectionType(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileColorfulLamp && ((TileColorfulLamp)tile).isBinaryMode()) {
            return RedNetConnectionType.CableAll;
        }
        return RedNetConnectionType.CableSingle;
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public void onInputsChanged(World world, int x, int y, int z, ForgeDirection side, int[] inputValues) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileColorfulLamp && ((TileColorfulLamp)tile).isBinaryMode()) {
            int c = 0;
            for (int i = 0; i < 15; ++i) {
                if (inputValues[i] == 0) continue;
                c |= 1 << i;
            }
            ((TileColorfulLamp)tile).setLampColor(c);
        }
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public void onInputChanged(World world, int x, int y, int z, ForgeDirection side, int inputValue) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileColorfulLamp && !((TileColorfulLamp)tile).isBinaryMode()) {
            ((TileColorfulLamp)tile).setLampColor(inputValue & Short.MAX_VALUE);
        }
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Class<? extends Environment> getTileEntityClass(int meta) {
        return TileColorfulLamp.class;
    }
}

