/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.buildcraft.pluggable;

import buildcraft.api.core.EnumColor;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import java.util.Map;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DeviceInfo;
import li.cil.oc.api.internal.Drone;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.ManagedEnvironment;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.integration.buildcraft.pluggable.DroneStationPluggable;
import pl.asie.computronics.util.OCUtils;

public class DriverDockingUpgrade
extends ManagedEnvironment
implements DeviceInfo {
    protected final Drone drone;
    protected boolean isDocking = false;
    protected boolean isDocked = false;
    protected IPipeTile pipe;
    protected final ForgeDirection side = ForgeDirection.UP;
    private int[] pipevec;
    private float targetX;
    private float targetY;
    private float targetZ;
    protected Map<String, String> deviceInfo;

    public DriverDockingUpgrade(Drone drone) {
        this.drone = drone;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Neighbors).withComponent("docking").create());
    }

    public boolean canUpdate() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update() {
        Vec3 realTarget;
        Vec3 target;
        DroneStationPluggable station;
        block5: {
            block6: {
                if (!this.isDocking && !this.isDocked || this.pipevec == null) break block5;
                TileEntity tile = this.drone.world().func_147438_o(this.pipevec[0], this.pipevec[1], this.pipevec[2]);
                if (!(tile instanceof IPipeTile)) break block6;
                this.pipe = (IPipeTile)tile;
                if (this.pipe.getPipePluggable(this.side) != null && this.pipe.getPipePluggable(this.side) instanceof DroneStationPluggable) {
                    station = (DroneStationPluggable)this.pipe.getPipePluggable(this.side);
                    if (station.getState() != DroneStationPluggable.DroneStationState.Used && station.getDrone() != this.drone) {
                        station.setDrone(this.drone);
                    }
                    break block5;
                } else {
                    Vec3 target2 = this.drone.getTarget();
                    double targetY = this.pipe != null ? (double)this.pipe.y() + 1.5 : (this.pipevec != null ? (double)this.pipevec[1] + 1.5 : target2.field_72448_b + 0.5);
                    target2.field_72448_b = (float)targetY;
                    this.drone.setTarget(target2);
                    this.isDocked = false;
                    this.isDocking = false;
                    this.pipe = null;
                    return;
                }
            }
            Vec3 target3 = this.drone.getTarget();
            double targetY = this.pipevec != null ? (double)this.pipevec[1] + 1.5 : target3.field_72448_b + 0.5;
            target3.field_72448_b = (float)targetY;
            this.drone.setTarget(target3);
            this.isDocked = false;
            this.isDocking = false;
            return;
        }
        Vec3 velocity = this.drone.getVelocity();
        if (this.isDocking && this.pipe != null && velocity.field_72450_a == 0.0 && velocity.field_72448_b == 0.0 && velocity.field_72449_c == 0.0) {
            this.isDocking = false;
            this.isDocked = true;
            station = (DroneStationPluggable)this.pipe.getPipePluggable(this.side);
            station.setDrone(this.drone);
        }
        if (this.isDocked && (target = this.drone.getTarget()).func_72438_d(realTarget = Vec3.func_72443_a((double)this.targetX, (double)this.targetY, (double)this.targetZ)) > 0.0) {
            Entity droneEntity = (Entity)this.drone;
            droneEntity.field_70159_w = 0.0;
            droneEntity.field_70181_x = 0.0;
            droneEntity.field_70179_y = 0.0;
            this.drone.setTarget(Vec3.func_72443_a((double)this.targetX, (double)this.targetY, (double)this.targetZ));
            droneEntity.field_70165_t = this.targetX;
            droneEntity.field_70163_u = this.targetY;
            droneEntity.field_70161_v = this.targetZ;
        }
    }

    private int injectItem(TileGenericPipe pipe, ItemStack stack, boolean doAdd, ForgeDirection from, EnumColor color) {
        if (!pipe.pipe.inputOpen(from)) {
            return 0;
        }
        if (BlockGenericPipe.isValid((Pipe)pipe.pipe) && pipe.pipe.transport instanceof PipeTransportItems && pipe.getPipePluggable(from) != null) {
            if (doAdd) {
                Position position = new Position((double)pipe.field_145851_c + 0.5, (double)pipe.field_145848_d + 0.02, (double)pipe.field_145849_e + 0.5, from.getOpposite());
                position.moveBackwards(0.4);
                TravelingItem itemInPipe = TravelingItem.make((double)position.x, (double)position.y, (double)position.z, (ItemStack)stack);
                itemInPipe.color = color;
                ((PipeTransportItems)pipe.pipe.transport).injectItem(itemInPipe, position.orientation);
            }
            return stack.field_77994_a;
        }
        return 0;
    }

    @Callback(doc="function(slot:number[,maxAmount:number[,color:number]]):number; drops an item into the attached pipe if docked; Returns the amount of items dropped on success; Allows coloring the item if the drone is tier 2")
    public Object[] dropItem(Context context, Arguments args) {
        if (!this.isDocked || this.pipe == null) {
            if (this.isDocking) {
                return new Object[]{0, "drone is still docking"};
            }
            return new Object[]{0, "drone is not docked"};
        }
        if (this.pipe.getPipeType() != IPipeTile.PipeType.ITEM) {
            return new Object[]{0, "cannot inject items into pipe"};
        }
        if (!(this.pipe instanceof TileGenericPipe)) {
            return new Object[]{0, "invalid pipe type"};
        }
        int count = args.count() > 1 ? Math.max(0, Math.min(64, args.checkInteger(1))) : 64;
        int slot = Math.max(0, args.checkInteger(0) - 1);
        ItemStack stack = this.drone.mainInventory().func_70301_a(slot);
        if (stack != null && stack.func_77973_b() != null) {
            stack = this.drone.mainInventory().func_70298_a(slot, count);
            int rejected = stack.field_77994_a - this.injectItem((TileGenericPipe)this.pipe, stack, true, this.side, args.count() > 2 && this.drone.tier() > 0 ? EnumColor.fromId((int)(15 - args.checkInteger(2))) : null);
            this.drone.mainInventory().func_70301_a((int)slot).field_77994_a += rejected;
            stack.field_77994_a -= rejected;
            return new Object[]{stack.field_77994_a};
        }
        return new Object[]{0, "invalid/empty slot"};
    }

    @Callback(doc="function():boolean; Makes the drone start docking with a docking station; Always tries to dock with a station below it first")
    public Object[] dock(Context context, Arguments args) {
        int x = (int)Math.floor(this.drone.xPosition());
        int y = (int)Math.floor(this.drone.yPosition());
        int z = (int)Math.floor(this.drone.zPosition());
        World world = this.drone.world();
        DroneStationPluggable station = this.tryGetStation(world, x, y - 1, z, this.side);
        if (station != null && station.getState() != DroneStationPluggable.DroneStationState.Used) {
            double targetY = this.pipe.y() + 1;
            Vec3 velocity = this.drone.getVelocity();
            if (velocity.field_72450_a != 0.0 || velocity.field_72448_b != 0.0 || velocity.field_72449_c != 0.0) {
                return new Object[]{false, "drone is still moving"};
            }
            Vec3 target = this.drone.getTarget();
            target.field_72448_b = (float)targetY;
            this.drone.setTarget(target);
            target = this.drone.getTarget();
            this.targetX = (float)target.field_72450_a;
            this.targetY = (float)target.field_72448_b;
            this.targetZ = (float)target.field_72449_c;
            this.isDocking = true;
            return new Object[]{true};
        }
        return new Object[]{false, "no non-occupied station found"};
    }

    @Callback(doc="function():boolean; Releases the drone if docked")
    public Object[] release(Context context, Arguments args) {
        if (!this.isDocked || this.pipe == null || !(this.pipe.getPipePluggable(this.side) instanceof DroneStationPluggable)) {
            if (this.isDocking) {
                return new Object[]{0, "drone is still docking"};
            }
            return new Object[]{0, "drone is not docked"};
        }
        double targetY = (double)this.pipe.y() + 1.5;
        Vec3 target = this.drone.getTarget();
        target.field_72448_b = (float)targetY;
        this.drone.setTarget(target);
        ((DroneStationPluggable)this.pipe.getPipePluggable(this.side)).setDrone(null);
        this.isDocking = false;
        this.isDocked = false;
        this.pipe = null;
        return new Object[]{true};
    }

    private DroneStationPluggable tryGetStation(World world, int x, int y, int z, ForgeDirection side) {
        PipePluggable pluggable;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof IPipeTile && (pluggable = ((IPipeTile)tile).getPipePluggable(side)) != null && pluggable instanceof DroneStationPluggable) {
            this.pipe = (IPipeTile)tile;
            return (DroneStationPluggable)pluggable;
        }
        return null;
    }

    public void onDisconnect(Node node) {
        super.onDisconnect(node);
        if (this.isDocked || this.isDocking) {
            if (this.drone != null) {
                Vec3 target = this.drone.getTarget();
                double targetY = this.pipe != null ? (double)this.pipe.y() + 1.5 : (this.pipevec != null ? (double)this.pipevec[1] + 1.5 : target.field_72448_b + 0.5);
                target.field_72448_b = (float)targetY;
                this.drone.setTarget(target);
            }
            if (this.pipe != null) {
                if (this.pipe.getPipePluggable(this.side) != null && this.pipe.getPipePluggable(this.side) instanceof DroneStationPluggable) {
                    ((DroneStationPluggable)this.pipe.getPipePluggable(this.side)).setDrone(null);
                }
                this.isDocked = false;
                this.isDocking = false;
                this.pipe = null;
            }
        }
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74757_a("drone:docking", this.isDocking);
        nbt.func_74757_a("drone:docked", this.isDocked);
        if ((this.isDocked || this.isDocking) && this.pipe != null) {
            nbt.func_74768_a("drone:dockX", this.pipe.x());
            nbt.func_74768_a("drone:dockY", this.pipe.y());
            nbt.func_74768_a("drone:dockZ", this.pipe.z());
            nbt.func_74776_a("drone:targetX", this.targetX);
            nbt.func_74776_a("drone:targetY", this.targetY);
            nbt.func_74776_a("drone:targetZ", this.targetZ);
        }
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.isDocking = nbt.func_74767_n("drone:docking");
        this.isDocked = nbt.func_74767_n("drone:docked");
        if (this.isDocked || this.isDocking) {
            this.pipevec = new int[]{nbt.func_74762_e("drone:dockX"), nbt.func_74762_e("drone:dockY"), nbt.func_74762_e("drone:dockZ")};
            this.targetX = nbt.func_74760_g("drone:targetX");
            this.targetY = nbt.func_74760_g("drone:targetY");
            this.targetZ = nbt.func_74760_g("drone:targetZ");
        }
    }

    public Map<String, String> getDeviceInfo() {
        if (this.deviceInfo == null) {
            this.deviceInfo = new OCUtils.Device("bus", "Drone pipe connector", "BuildCraft, Inc.", "DroneDock 233-B Deluxe", new String[0]).deviceInfo();
            return this.deviceInfo;
        }
        return this.deviceInfo;
    }
}

