/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import li.cil.oc.common.block.Item;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.integration.buildcraft.IntegrationBuildCraftBuilder;
import pl.asie.computronics.integration.railcraft.LocomotiveManager;
import pl.asie.computronics.integration.railcraft.SignalTypes;
import pl.asie.computronics.integration.railcraft.block.BlockDigitalControllerBox;
import pl.asie.computronics.integration.railcraft.block.BlockDigitalDetector;
import pl.asie.computronics.integration.railcraft.block.BlockDigitalReceiverBox;
import pl.asie.computronics.integration.railcraft.block.BlockLocomotiveRelay;
import pl.asie.computronics.integration.railcraft.block.BlockTicketMachine;
import pl.asie.computronics.integration.railcraft.client.SignalBoxRenderer;
import pl.asie.computronics.integration.railcraft.gui.GuiProviderTicketMachine;
import pl.asie.computronics.integration.railcraft.item.ItemBlockSignalBox;
import pl.asie.computronics.integration.railcraft.item.ItemRelaySensor;
import pl.asie.computronics.integration.railcraft.tile.TileDigitalControllerBox;
import pl.asie.computronics.integration.railcraft.tile.TileDigitalDetector;
import pl.asie.computronics.integration.railcraft.tile.TileDigitalReceiverBox;
import pl.asie.computronics.integration.railcraft.tile.TileLocomotiveRelay;
import pl.asie.computronics.integration.railcraft.tile.TileTicketMachine;
import pl.asie.lib.gui.managed.IGuiProvider;
import pl.asie.lib.network.Packet;

public class IntegrationRailcraft {
    public BlockLocomotiveRelay locomotiveRelay;
    public BlockDigitalDetector detector;
    public ItemRelaySensor relaySensor;
    public Block digitalReceiverBox;
    public Block digitalControllerBox;
    public BlockTicketMachine ticketMachine;
    LocomotiveManager manager;
    public GuiProviderTicketMachine guiTicketMachine;

    private static boolean isEnabled(Configuration config, String name, boolean def) {
        return config.get("enable.railcraft", name, def).getBoolean(def);
    }

    public void preInit(Configuration config) {
        if (IntegrationRailcraft.isEnabled(config, "locomotiveRelay", true)) {
            this.locomotiveRelay = new BlockLocomotiveRelay();
            GameRegistry.registerBlock((Block)this.locomotiveRelay, (String)"computronics.locomotiveRelay");
            GameRegistry.registerTileEntity(TileLocomotiveRelay.class, (String)"computronics.locomotiveRelay");
            FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileLocomotiveRelay.class.getCanonicalName());
            IntegrationBuildCraftBuilder.INSTANCE.registerBlockBaseSchematic(this.locomotiveRelay);
            this.relaySensor = new ItemRelaySensor();
            GameRegistry.registerItem((net.minecraft.item.Item)this.relaySensor, (String)"computronics.relaySensor");
            this.manager = new LocomotiveManager();
            MinecraftForge.EVENT_BUS.register((Object)this.manager);
        }
        if (IntegrationRailcraft.isEnabled(config, "digitalReceiverBox", true)) {
            this.digitalReceiverBox = new BlockDigitalReceiverBox();
            GameRegistry.registerBlock((Block)this.digitalReceiverBox, ItemBlockSignalBox.class, (String)"computronics.digitalReceiverBox");
            GameRegistry.registerTileEntity(TileDigitalReceiverBox.class, (String)"computronics.digitalReceiverBox");
            FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileDigitalReceiverBox.class.getCanonicalName());
        }
        if (IntegrationRailcraft.isEnabled(config, "digitalControllerBox", true)) {
            this.digitalControllerBox = new BlockDigitalControllerBox();
            GameRegistry.registerBlock((Block)this.digitalControllerBox, ItemBlockSignalBox.class, (String)"computronics.digitalControllerBox");
            GameRegistry.registerTileEntity(TileDigitalControllerBox.class, (String)"computronics.digitalControllerBox");
            FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileDigitalControllerBox.class.getCanonicalName());
        }
        if (IntegrationRailcraft.isEnabled(config, "digitalDetector", true)) {
            this.detector = new BlockDigitalDetector();
            GameRegistry.registerBlock((Block)this.detector, (String)"computronics.detector");
            GameRegistry.registerTileEntity(TileDigitalDetector.class, (String)"computronics.detector");
            FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileDigitalDetector.class.getCanonicalName());
            IntegrationBuildCraftBuilder.INSTANCE.registerBlockBaseSchematic(this.detector);
        }
        if (IntegrationRailcraft.isEnabled(config, "ticketMachine", true)) {
            this.guiTicketMachine = new GuiProviderTicketMachine();
            Computronics.gui.registerGuiProvider((IGuiProvider)this.guiTicketMachine);
            this.ticketMachine = new BlockTicketMachine();
            GameRegistry.registerBlock((Block)this.ticketMachine, (String)"computronics.ticketMachine");
            GameRegistry.registerTileEntity(TileTicketMachine.class, (String)"computronics.ticketMachine");
            FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileTicketMachine.class.getCanonicalName());
            IntegrationBuildCraftBuilder.INSTANCE.registerBlockBaseSchematic(this.ticketMachine);
        }
    }

    @Optional.Method(modid="Railcraft")
    public void onMessageRailcraft(Packet packet, EntityPlayer player, boolean isServer) throws IOException {
        TileEntity entity;
        TileEntity tileEntity = entity = isServer ? packet.readTileEntityServer() : packet.readTileEntity();
        if (entity instanceof TileTicketMachine) {
            TileTicketMachine machine = (TileTicketMachine)entity;
            int i = packet.readInt();
            machine.setLocked((i & 1) == 1, isServer);
            machine.setSelectionLocked((i >> 1 & 1) == 1, isServer);
            machine.setPrintLocked((i >> 2 & 1) == 1, isServer);
            machine.setActive((i >> 3 & 1) == 1, isServer);
            machine.setSelectedSlot(packet.readInt(), isServer);
        }
    }

    @Optional.Method(modid="Railcraft")
    public void printTicket(Packet packet, EntityPlayer player, boolean isServer) throws IOException {
        TileEntity entity;
        TileEntity tileEntity = entity = isServer ? packet.readTileEntityServer() : packet.readTileEntity();
        if (entity instanceof TileTicketMachine) {
            ((TileTicketMachine)entity).printTicket();
        }
    }

    public void remap(FMLMissingMappingsEvent e) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : e.get()) {
            if (this.digitalReceiverBox == null || !mapping.name.equals("computronics:computronics.digitalBox")) continue;
            switch (mapping.type) {
                case BLOCK: {
                    mapping.remap(this.digitalReceiverBox);
                    break;
                }
                case ITEM: {
                    mapping.remap(Item.func_150898_a((Block)this.digitalReceiverBox));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="Railcraft")
    public void registerRenderers() {
        SignalBoxRenderer renderer = new SignalBoxRenderer(this.digitalReceiverBox, SignalTypes.DigitalReceiver);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)renderer);
        MinecraftForgeClient.registerItemRenderer((net.minecraft.item.Item)net.minecraft.item.Item.func_150898_a((Block)renderer.getBlock()), (IItemRenderer)renderer.getItemRenderer());
        renderer = new SignalBoxRenderer(this.digitalControllerBox, SignalTypes.DigitalController);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)renderer);
        MinecraftForgeClient.registerItemRenderer((net.minecraft.item.Item)net.minecraft.item.Item.func_150898_a((Block)renderer.getBlock()), (IItemRenderer)renderer.getItemRenderer());
    }
}

