/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.driver;

import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTTagCompound;
import pl.asie.computronics.oc.driver.ManagedEnvironmentWithComponentConnector;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.boom.SelfDestruct;

public class DriverCardBoom
extends ManagedEnvironmentWithComponentConnector {
    protected final EnvironmentHost container;
    protected int time = -1;

    public DriverCardBoom(EnvironmentHost container) {
        this.container = container;
        this.createNode();
    }

    protected void createNode() {
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Neighbors).withComponent("self_destruct").create());
    }

    public void onConnect(Node node) {
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message message) {
        super.onMessage(message);
        if ((message.name().equals("computer.stopped") || message.name().equals("computer.started")) && this.node().isNeighborOf(message.source())) {
            this.setTime(-1);
        }
    }

    protected void setTime(int time) {
        this.time = time;
    }

    @Callback(doc="function([time:number]):number; Starts the countdown; Will be ticking down until the time is reached. 5 seconds by default. Returns the time set")
    public Object[] start(Context context, Arguments args) {
        if (this.time >= 0) {
            return new Object[]{-1, "fuse has already been set"};
        }
        double fuse = args.optDouble(0, 5.0);
        if (fuse > 100000.0) {
            throw new IllegalArgumentException("time may not be greater than 100000");
        }
        this.setTime((int)Math.round(Math.floor(fuse * 20.0)));
        return new Object[]{fuse};
    }

    @Callback(doc="function():number; Returns the time in seconds left", direct=true)
    public Object[] time(Context context, Arguments args) {
        if (this.time < 0) {
            return new Object[]{-1, "fuse has not been set"};
        }
        return new Object[]{(double)this.time / 20.0};
    }

    public boolean canUpdate() {
        return true;
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (nbt.func_74767_n("ticking")) {
            this.setTime(nbt.func_74762_e("time"));
        }
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.time >= 0) {
            nbt.func_74757_a("ticking", true);
            nbt.func_74768_a("time", this.time);
        } else {
            nbt.func_74757_a("ticking", false);
        }
    }

    @Override
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("generic", "Machine destruction service", "Hugging Creeper Industries", "SD-Struct 1", new String[0]);
    }

    public void update() {
        super.update();
        if (this.time < 0) {
            return;
        }
        if (this.time <= 0) {
            this.goBoom();
        } else {
            --this.time;
        }
    }

    protected void goBoom() {
        SelfDestruct.goBoom(this.container.world(), this.container.xPosition(), this.container.yPosition(), this.container.zPosition(), true);
    }
}

