/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util.sound;

public enum AudioType {
    Square{

        @Override
        public double generate(float pos) {
            return Math.signum(Sine.generate(pos)) * 0.5;
        }
    }
    ,
    Sine{

        @Override
        public double generate(float pos) {
            return Math.sin(Math.PI * 2 * (double)pos);
        }
    }
    ,
    Triangle{

        @Override
        public double generate(float pos) {
            return 1.0 - Math.abs((double)pos - 0.5) * 4.0;
        }
    }
    ,
    Sawtooth{

        @Override
        public double generate(float pos) {
            return 2.0f * pos - 1.0f;
        }
    };

    public static final AudioType[] VALUES;

    public abstract double generate(float var1);

    public static AudioType fromIndex(int index) {
        return index >= 0 && index < VALUES.length ? VALUES[index] : Square;
    }

    static {
        VALUES = AudioType.values();
    }
}

