/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.block;

import java.util.ArrayList;
import java.util.List;
import minetweaker.api.block.IBlock;
import minetweaker.api.block.IBlockPattern;
import minetweaker.util.ArrayUtil;

public class BlockPatternOr
implements IBlockPattern {
    private final IBlockPattern[] elements;

    public BlockPatternOr(IBlockPattern[] elements) {
        this.elements = elements;
    }

    public BlockPatternOr(IBlockPattern a, IBlockPattern b) {
        this.elements = new IBlockPattern[]{a, b};
    }

    @Override
    public List<IBlock> getBlocks() {
        ArrayList<IBlock> blocks = new ArrayList<IBlock>();
        for (IBlockPattern pattern : this.elements) {
            blocks.addAll(pattern.getBlocks());
        }
        return blocks;
    }

    @Override
    public boolean matches(IBlock block) {
        for (IBlockPattern pattern : this.elements) {
            if (!pattern.matches(block)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayName() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (IBlockPattern pattern : this.elements) {
            if (first) {
                first = false;
            } else {
                result.append(" | ");
            }
            result.append(pattern.getDisplayName());
        }
        return result.toString();
    }

    @Override
    public IBlockPattern or(IBlockPattern pattern) {
        return new BlockPatternOr(ArrayUtil.append(this.elements, pattern));
    }
}

