/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.compiler;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import stanhebben.zenscript.IZenCompileEnvironment;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolLocal;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;

public class EnvironmentScope
implements IEnvironmentMethod {
    private final IEnvironmentMethod outer;
    private final Map<String, IZenSymbol> local;
    private final Map<SymbolLocal, Integer> locals;

    public EnvironmentScope(IEnvironmentMethod outer) {
        this.outer = outer;
        this.local = new HashMap<String, IZenSymbol>();
        this.locals = new HashMap<SymbolLocal, Integer>();
    }

    @Override
    public MethodOutput getOutput() {
        return this.outer.getOutput();
    }

    @Override
    public int getLocal(SymbolLocal variable) {
        if (this.locals.containsKey(variable)) {
            return this.locals.get(variable);
        }
        return this.outer.getLocal(variable);
    }

    @Override
    public ClassVisitor getClassOutput() {
        return this.outer.getClassOutput();
    }

    @Override
    public ZenType getType(Type type) {
        return this.outer.getType(type);
    }

    @Override
    public IZenCompileEnvironment getEnvironment() {
        return this.outer.getEnvironment();
    }

    @Override
    public TypeExpansion getExpansion(String name) {
        return this.outer.getExpansion(name);
    }

    @Override
    public String makeClassName() {
        return this.outer.makeClassName();
    }

    @Override
    public String makeClassNameWithMiddleName(String middleName) {
        return this.outer.makeClassNameWithMiddleName(middleName);
    }

    @Override
    public boolean containsClass(String name) {
        return this.outer.containsClass(name);
    }

    @Override
    public void putClass(String name, byte[] data) {
        this.outer.putClass(name, data);
    }

    @Override
    public IPartialExpression getValue(String name, ZenPosition position) {
        if (this.local.containsKey(name)) {
            return this.local.get(name).instance(position);
        }
        return this.outer.getValue(name, position);
    }

    @Override
    public void putValue(String name, IZenSymbol value, ZenPosition position) {
        if (this.local.containsKey(name)) {
            this.error(position, "Value already defined in this scope: " + name);
        } else {
            this.local.put(name, value);
        }
    }

    @Override
    public void error(ZenPosition position, String message) {
        this.outer.error(position, message);
    }

    @Override
    public void warning(ZenPosition position, String message) {
        this.outer.warning(position, message);
    }

    @Override
    public void info(ZenPosition position, String message) {
        this.outer.info(position, message);
    }

    @Override
    public Set<String> getClassNames() {
        return this.outer.getClassNames();
    }

    @Override
    public byte[] getClass(String name) {
        return this.outer.getClass(name);
    }

    @Override
    public void error(String message) {
        this.outer.error(message);
    }

    @Override
    public void error(String message, Throwable e) {
        this.outer.error(message, e);
    }

    @Override
    public void warning(String message) {
        this.outer.warning(message);
    }

    @Override
    public void info(String message) {
        this.outer.info(message);
    }
}

