/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression;

import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.ZenPosition;

public class ExpressionFunctionCall
extends Expression {
    private final Expression[] values;
    private final ZenType returnType;
    private final Expression receiver;
    private final String className;
    private final String descriptor;

    public ExpressionFunctionCall(ZenPosition position, Expression[] values, ZenType returnType, Expression receiver, String className, String descriptor) {
        super(position);
        this.values = values;
        this.returnType = returnType;
        this.receiver = receiver;
        this.className = className;
        this.descriptor = descriptor;
    }

    @Override
    public void compile(boolean result, IEnvironmentMethod environment) {
        this.receiver.compile(result, environment);
        for (Expression value : this.values) {
            value.compile(true, environment);
        }
        environment.getOutput().invokeVirtual(this.className, "accept", this.descriptor);
        if (this.returnType != ZenType.VOID && !result) {
            environment.getOutput().pop(this.returnType.isLarge());
        }
    }

    @Override
    public ZenType getType() {
        return this.returnType;
    }
}

