/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import java.util.ArrayList;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.annotations.CompareType;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallVirtual;
import stanhebben.zenscript.expression.ExpressionCompareGeneric;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.ExpressionNull;
import stanhebben.zenscript.expression.ExpressionStringConcat;
import stanhebben.zenscript.expression.ExpressionStringContains;
import stanhebben.zenscript.expression.ExpressionStringIndex;
import stanhebben.zenscript.expression.ExpressionStringMethod;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeAny;
import stanhebben.zenscript.type.casting.CastingRuleNullableStaticMethod;
import stanhebben.zenscript.type.casting.CastingRuleStaticMethod;
import stanhebben.zenscript.type.casting.ICastingRuleDelegate;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.AnyClassWriter;
import stanhebben.zenscript.util.IAnyDefinition;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;
import stanhebben.zenscript.value.IAny;

public class ZenTypeString
extends ZenType {
    public static final ZenTypeString INSTANCE = new ZenTypeString();
    private static final String ANY_NAME = "any/AnyString";
    private static final String ANY_NAME_2 = "any.AnyString";
    private final Type type = Type.getType(String.class);

    private ZenTypeString() {
    }

    @Override
    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        return null;
    }

    @Override
    public void constructCastingRules(IEnvironmentGlobal environment, ICastingRuleDelegate rules, boolean followCasters) {
        rules.registerCastingRule(BOOL, new CastingRuleStaticMethod(PARSE_BOOL));
        rules.registerCastingRule(BOOLOBJECT, new CastingRuleNullableStaticMethod(PARSE_BOOL_OBJECT));
        rules.registerCastingRule(BYTE, new CastingRuleStaticMethod(PARSE_BYTE));
        rules.registerCastingRule(BYTEOBJECT, new CastingRuleNullableStaticMethod(PARSE_BYTE_OBJECT));
        rules.registerCastingRule(SHORT, new CastingRuleStaticMethod(PARSE_SHORT));
        rules.registerCastingRule(SHORTOBJECT, new CastingRuleNullableStaticMethod(PARSE_SHORT_OBJECT));
        rules.registerCastingRule(INT, new CastingRuleStaticMethod(PARSE_INT));
        rules.registerCastingRule(INTOBJECT, new CastingRuleNullableStaticMethod(PARSE_INT_OBJECT));
        rules.registerCastingRule(LONG, new CastingRuleStaticMethod(PARSE_LONG));
        rules.registerCastingRule(LONGOBJECT, new CastingRuleNullableStaticMethod(PARSE_LONG_OBJECT));
        rules.registerCastingRule(FLOAT, new CastingRuleStaticMethod(PARSE_FLOAT));
        rules.registerCastingRule(FLOATOBJECT, new CastingRuleNullableStaticMethod(PARSE_FLOAT_OBJECT));
        rules.registerCastingRule(DOUBLE, new CastingRuleStaticMethod(PARSE_DOUBLE));
        rules.registerCastingRule(DOUBLEOBJECT, new CastingRuleNullableStaticMethod(PARSE_DOUBLE_OBJECT));
        rules.registerCastingRule(ANY, new CastingRuleNullableStaticMethod(JavaMethod.getStatic(this.getAnyClassName(environment), "valueOf", ANY, STRING)));
        if (followCasters) {
            this.constructExpansionCastingRules(environment, rules);
        }
    }

    @Override
    public Type toASMType() {
        return this.type;
    }

    @Override
    public int getNumberType() {
        return 0;
    }

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name) {
        if (ExpressionStringMethod.hasMethod(name, environment.getEnvironment().getTypeRegistry())) {
            return new ExpressionStringMethod(position, value.eval(environment), name);
        }
        IPartialExpression result = this.memberExpansion(position, environment, value.eval(environment), name);
        if (result == null) {
            environment.error(position, "string value has no such member: " + name);
            return new ExpressionInvalid(position, ZenTypeAny.INSTANCE);
        }
        return result;
    }

    @Override
    public IPartialExpression getStaticMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        return null;
    }

    @Override
    public String getSignature() {
        return "Ljava/lang/String;";
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    @Override
    public Expression unary(ZenPosition position, IEnvironmentGlobal environment, Expression value, OperatorType operator) {
        Expression result = this.unaryExpansion(position, environment, value, operator);
        if (result == null) {
            environment.error(position, "operator not supported on a string");
            return new ExpressionInvalid(position);
        }
        return result;
    }

    @Override
    public Expression binary(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, OperatorType operator) {
        if (operator == OperatorType.CAT || operator == OperatorType.ADD) {
            if (left instanceof ExpressionStringConcat) {
                ((ExpressionStringConcat)left).add(right.cast(position, environment, this));
                return left;
            }
            if (right.getType().canCastImplicit(STRING, environment)) {
                ArrayList<Expression> values = new ArrayList<Expression>();
                values.add(left);
                values.add(right.cast(position, environment, this));
                return new ExpressionStringConcat(position, values);
            }
            Expression expanded = this.binaryExpansion(position, environment, left, right, operator);
            if (expanded == null) {
                environment.error(position, "cannot add " + right.getType().getName() + " to a string");
                return new ExpressionInvalid(position, this);
            }
            return expanded;
        }
        if (operator == OperatorType.INDEXGET) {
            return new ExpressionStringIndex(position, left, right.cast(position, environment, INT));
        }
        if (operator == OperatorType.CONTAINS) {
            return new ExpressionStringContains(position, left, right.cast(position, environment, STRING));
        }
        Expression result = this.binaryExpansion(position, environment, left, right, operator);
        if (result == null) {
            environment.error(position, "operator not supported on strings");
            return new ExpressionInvalid(position, this);
        }
        return result;
    }

    @Override
    public Expression trinary(ZenPosition position, IEnvironmentGlobal environment, Expression first, Expression second, Expression third, OperatorType operator) {
        Expression result = this.trinaryExpansion(position, environment, first, second, third, operator);
        if (result == null) {
            environment.error(position, "operator not supported on strings");
            return new ExpressionInvalid(position, this);
        }
        return result;
    }

    @Override
    public Expression compare(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, CompareType type) {
        if (right.getType().canCastImplicit(STRING, environment)) {
            return new ExpressionCompareGeneric(position, new ExpressionCallVirtual(position, environment, STRING_COMPARETO, left, right.cast(position, environment, STRING)), type);
        }
        Expression result = this.binaryExpansion(position, environment, left, right, OperatorType.COMPARE);
        if (result == null) {
            environment.error(position, "cannot compare strings");
            return new ExpressionInvalid(position, BOOL);
        }
        return new ExpressionCompareGeneric(position, result, type);
    }

    @Override
    public Expression call(ZenPosition position, IEnvironmentGlobal environment, Expression receiver, Expression ... arguments) {
        environment.error(position, "Cannot call a string value");
        return new ExpressionInvalid(position, INSTANCE);
    }

    @Override
    public Class toJavaClass() {
        return String.class;
    }

    @Override
    public String getName() {
        return "string";
    }

    @Override
    public String getAnyClassName(IEnvironmentGlobal environment) {
        if (!environment.containsClass(ANY_NAME_2)) {
            environment.putClass(ANY_NAME_2, new byte[0]);
            environment.putClass(ANY_NAME_2, AnyClassWriter.construct(new AnyDefinitionString(environment), ANY_NAME, this.type));
        }
        return ANY_NAME;
    }

    @Override
    public Expression defaultValue(ZenPosition position) {
        return new ExpressionNull(position);
    }

    private class AnyDefinitionString
    implements IAnyDefinition {
        private final IEnvironmentGlobal environment;

        private AnyDefinitionString(IEnvironmentGlobal environment) {
            this.environment = environment;
        }

        @Override
        public void defineMembers(ClassVisitor output) {
            output.visitField(2, "value", "Ljava/lang/String;", null, null);
            MethodOutput valueOf = new MethodOutput(output, 9, "valueOf", "(Ljava/lang/String;)" + ZenTypeUtil.signature(IAny.class), null, null);
            valueOf.start();
            valueOf.newObject(ZenTypeString.ANY_NAME);
            valueOf.dup();
            valueOf.loadObject(0);
            valueOf.construct(ZenTypeString.ANY_NAME, "Ljava/lang/String;");
            valueOf.returnObject();
            valueOf.end();
            MethodOutput constructor = new MethodOutput(output, 1, "<init>", "(Ljava/lang/String;)V", null, null);
            constructor.start();
            constructor.loadObject(0);
            constructor.invokeSpecial(ZenTypeUtil.internal(Object.class), "<init>", "()V");
            constructor.loadObject(0);
            constructor.load(ZenTypeString.this.type, 1);
            constructor.putField(ZenTypeString.ANY_NAME, "value", "Ljava/lang/String;");
            constructor.returnType(Type.VOID_TYPE);
            constructor.end();
        }

        @Override
        public void defineStaticCanCastImplicit(MethodOutput output) {
            Label lblOthers = new Label();
            output.constant(ZenTypeString.this.type);
            output.loadObject(0);
            output.ifACmpNe(lblOthers);
            output.iConst1();
            output.returnInt();
            output.label(lblOthers);
            TypeExpansion expansion = this.environment.getExpansion(ZenTypeString.this.getName());
            if (expansion != null) {
                expansion.compileAnyCanCastImplicit(ZenType.STRING, output, this.environment, 0);
            }
            output.iConst0();
            output.returnInt();
        }

        @Override
        public void defineStaticAs(MethodOutput output) {
            TypeExpansion expansion = this.environment.getExpansion(ZenTypeString.this.getName());
            if (expansion != null) {
                expansion.compileAnyCast(ZenType.STRING, output, this.environment, 0, 1);
            }
            AnyClassWriter.throwCastException(output, "string", 1);
        }

        @Override
        public void defineNot(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, "string", "not");
        }

        @Override
        public void defineNeg(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, "string", "negate");
        }

        @Override
        public void defineAdd(MethodOutput output) {
            this.defineCat(output);
        }

        @Override
        public void defineSub(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, "string", "-");
        }

        @Override
        public void defineCat(MethodOutput output) {
            output.newObject(StringBuilder.class);
            output.dup();
            output.invokeSpecial(ZenTypeUtil.internal(StringBuilder.class), "<init>", "()V");
            this.getValue(output);
            output.invokeVirtual(StringBuilder.class, "append", StringBuilder.class, String.class);
            output.loadObject(1);
            AnyClassWriter.METHOD_ASSTRING.invokeVirtual(output);
            output.invokeVirtual(StringBuilder.class, "append", StringBuilder.class, String.class);
            output.invokeVirtual(StringBuilder.class, "toString", String.class, new Class[0]);
            output.invokeStatic(ZenTypeString.ANY_NAME, "valueOf", "(Ljava/lang/String;)" + ZenTypeUtil.signature(IAny.class));
            output.returnObject();
        }

        @Override
        public void defineMul(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, "string", "*");
        }

        @Override
        public void defineDiv(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, "string", "/");
        }

        @Override
        public void defineMod(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, "string", "*");
        }

        @Override
        public void defineAnd(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, "string", "&");
        }

        @Override
        public void defineOr(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, "string", "|");
        }

        @Override
        public void defineXor(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, "string", "^");
        }

        @Override
        public void defineRange(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, "string", "..");
        }

        @Override
        public void defineCompareTo(MethodOutput output) {
            this.getValue(output);
            output.loadObject(1);
            AnyClassWriter.METHOD_ASSTRING.invokeVirtual(output);
            output.invokeVirtual(String.class, "compareTo", Integer.TYPE, String.class);
            output.returnInt();
        }

        @Override
        public void defineContains(MethodOutput output) {
            this.getValue(output);
            output.loadObject(1);
            AnyClassWriter.METHOD_ASSTRING.invokeVirtual(output);
            output.invokeVirtual(String.class, "contains", Boolean.TYPE, CharSequence.class);
            output.returnInt();
        }

        @Override
        public void defineMemberGet(MethodOutput output) {
            output.aConstNull();
            output.returnObject();
        }

        @Override
        public void defineMemberSet(MethodOutput output) {
            output.returnType(Type.VOID_TYPE);
        }

        @Override
        public void defineMemberCall(MethodOutput output) {
            output.aConstNull();
            output.returnObject();
        }

        @Override
        public void defineIndexGet(MethodOutput output) {
            this.getValue(output);
            output.loadObject(1);
            AnyClassWriter.METHOD_ASINT.invokeVirtual(output);
            output.dup();
            output.iConst1();
            output.iAdd();
            output.invokeVirtual(String.class, "substring", String.class, Integer.TYPE, Integer.TYPE);
            output.invokeStatic(ZenTypeString.ANY_NAME, "valueOf", "(Ljava/lang/String;)" + ZenTypeUtil.signature(IAny.class));
            output.returnObject();
        }

        @Override
        public void defineIndexSet(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, "string", "[]=");
        }

        @Override
        public void defineCall(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, "string", "call");
        }

        @Override
        public void defineAsBool(MethodOutput output) {
            this.getValue(output);
            output.invokeStatic(Boolean.class, "parseBoolean", Boolean.TYPE, String.class);
            output.returnInt();
        }

        @Override
        public void defineAsByte(MethodOutput output) {
            this.getValue(output);
            output.invokeStatic(Byte.class, "parseByte", Byte.TYPE, String.class);
            output.returnInt();
        }

        @Override
        public void defineAsShort(MethodOutput output) {
            this.getValue(output);
            output.invokeStatic(Short.class, "parseShort", Short.TYPE, String.class);
            output.returnInt();
        }

        @Override
        public void defineAsInt(MethodOutput output) {
            this.getValue(output);
            output.invokeStatic(Integer.class, "parseInt", Integer.TYPE, String.class);
            output.returnInt();
        }

        @Override
        public void defineAsLong(MethodOutput output) {
            this.getValue(output);
            output.invokeStatic(Long.class, "parseLong", Long.TYPE, String.class);
            output.returnType(Type.LONG_TYPE);
        }

        @Override
        public void defineAsFloat(MethodOutput output) {
            this.getValue(output);
            output.invokeStatic(Float.class, "parseFloat", Float.TYPE, String.class);
            output.returnType(Type.FLOAT_TYPE);
        }

        @Override
        public void defineAsDouble(MethodOutput output) {
            this.getValue(output);
            output.invokeStatic(Double.class, "parseDouble", Double.TYPE, String.class);
            output.returnType(Type.DOUBLE_TYPE);
        }

        @Override
        public void defineAsString(MethodOutput output) {
            this.getValue(output);
            output.returnObject();
        }

        @Override
        public void defineAs(MethodOutput output) {
            int localValue = output.local(ZenTypeString.this.type);
            this.getValue(output);
            output.store(ZenTypeString.this.type, localValue);
            TypeExpansion expansion = this.environment.getExpansion(ZenTypeString.this.getName());
            if (expansion != null) {
                expansion.compileAnyCast(ZenType.STRING, output, this.environment, localValue, 1);
            }
            AnyClassWriter.throwCastException(output, "string", 1);
        }

        @Override
        public void defineIs(MethodOutput output) {
            Label lblEq = new Label();
            output.loadObject(1);
            output.constant(ZenTypeString.this.type);
            output.ifACmpEq(lblEq);
            output.iConst0();
            output.returnInt();
            output.label(lblEq);
            output.iConst1();
            output.returnInt();
        }

        @Override
        public void defineGetNumberType(MethodOutput output) {
            output.iConst0();
            output.returnInt();
        }

        @Override
        public void defineIteratorSingle(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, "string", "iterator");
        }

        @Override
        public void defineIteratorMulti(MethodOutput output) {
            AnyClassWriter.throwUnsupportedException(output, "string", "iterator");
        }

        private void getValue(MethodOutput output) {
            output.loadObject(0);
            output.getField(ZenTypeString.ANY_NAME, "value", "Ljava/lang/String;");
        }

        @Override
        public void defineEquals(MethodOutput output) {
            this.getValue(output);
            output.loadObject(1);
            AnyClassWriter.METHOD_ASSTRING.invokeVirtual(output);
            output.invokeVirtual(String.class, "equals", Boolean.TYPE, Object.class);
            output.returnInt();
        }

        @Override
        public void defineHashCode(MethodOutput output) {
            this.getValue(output);
            output.invokeVirtual(String.class, "hashCode", Integer.TYPE, new Class[0]);
            output.returnInt();
        }
    }
}

