/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type.iterator;

import java.util.Iterator;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.MethodOutput;

public class IteratorIterable
implements IZenIterator {
    private final MethodOutput methodOutput;
    private final ZenType iteratorType;
    private int iterator;

    public IteratorIterable(MethodOutput methodOutput, ZenType iteratorType) {
        this.methodOutput = methodOutput;
        this.iteratorType = iteratorType;
    }

    @Override
    public void compileStart(int[] locals) {
        this.iterator = this.methodOutput.local(Type.getType(Iterator.class));
        this.methodOutput.invokeInterface(Iterable.class, "iterator", Iterator.class, new Class[0]);
        this.methodOutput.storeObject(this.iterator);
    }

    @Override
    public void compilePreIterate(int[] locals, Label exit) {
        this.methodOutput.loadObject(this.iterator);
        this.methodOutput.invokeInterface(Iterator.class, "hasNext", Boolean.TYPE, new Class[0]);
        this.methodOutput.ifEQ(exit);
        this.methodOutput.loadObject(this.iterator);
        this.methodOutput.invokeInterface(Iterator.class, "next", Object.class, new Class[0]);
        this.methodOutput.checkCast(this.iteratorType.toASMType().getInternalName());
        this.methodOutput.store(this.iteratorType.toASMType(), locals[0]);
    }

    @Override
    public void compilePostIterate(int[] locals, Label exit, Label repeat) {
        this.methodOutput.goTo(repeat);
    }

    @Override
    public ZenType getType(int i) {
        return this.iteratorType;
    }

    @Override
    public void compileEnd() {
    }
}

