/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.gregtechCrops;

import com.github.bartimaeusnek.cropspp.CCropUtility;
import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicDecorationCrop;
import gregtech.api.enums.Materials;
import ic2.api.crops.ICropTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class StonelillyCrop
extends BasicDecorationCrop {
    private final String color;

    public StonelillyCrop(String color) {
        this.color = color;
    }

    @Override
    public ItemStack getDisplayItem() {
        ItemStack itemStack;
        switch (this.color) {
            case "Red": {
                itemStack = Materials.GraniteRed.getDust(9);
                break;
            }
            case "Black": {
                itemStack = Materials.GraniteBlack.getDust(9);
                break;
            }
            case "White": {
                itemStack = Materials.Marble.getDust(9);
                break;
            }
            case "Gray": {
                itemStack = Materials.Stone.getDust(9);
                break;
            }
            case "Yellow": {
                itemStack = Materials.Endstone.getDust(2);
                break;
            }
            case "Nether": {
                itemStack = Materials.Netherrack.getDust(9);
                break;
            }
            default: {
                itemStack = new ItemStack(Blocks.field_150347_e);
            }
        }
        return itemStack;
    }

    public String name() {
        return this.color + " Stonelilly";
    }

    @Override
    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        if (this.color.equals("Yellow") && crop.getSize() >= this.maxSize() - 1 && crop.isBlockBelow(Blocks.field_150377_bs)) {
            return 550;
        }
        return 300;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        boolean bl;
        if (!super.canGrow(crop)) {
            return false;
        }
        if (ConfigValues.debug) {
            return true;
        }
        if (crop.getSize() < this.maxSize() - 1) {
            return true;
        }
        switch (this.color) {
            case "Red": {
                if (crop.isBlockBelow("stoneGraniteRed") || crop.isBlockBelow("blockGranite")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "Black": {
                if (crop.isBlockBelow("stoneGraniteBlack") || crop.isBlockBelow("stoneBasalt")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "White": {
                if (crop.isBlockBelow("blockMarble") || crop.isBlockBelow("blockDiorite")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "Gray": {
                if (crop.isBlockBelow(Blocks.field_150347_e) || crop.isBlockBelow(Blocks.field_150348_b) || crop.isBlockBelow("blockAndesite")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "Yellow": {
                if (crop.isBlockBelow(Blocks.field_150377_bs) || crop.isBlockBelow((Block)Blocks.field_150354_m) || crop.isBlockBelow(Blocks.field_150322_A)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "Nether": {
                if (crop.isBlockBelow(Blocks.field_150424_aL) || crop.isBlockBelow(Blocks.field_150385_bj)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)((double)humidity / 0.8 + (double)nutrients / 1.4 + (double)air / 0.8);
    }

    public String[] attributes() {
        String[] stringArray;
        switch (this.color) {
            case "Red": {
                String[] stringArray2 = new String[3];
                stringArray2[0] = this.color;
                stringArray2[1] = "Stone";
                stringArray = stringArray2;
                stringArray2[2] = "Fire";
                break;
            }
            case "Black": {
                String[] stringArray3 = new String[3];
                stringArray3[0] = this.color;
                stringArray3[1] = "Stone";
                stringArray = stringArray3;
                stringArray3[2] = "Dark";
                break;
            }
            case "White": {
                String[] stringArray4 = new String[3];
                stringArray4[0] = this.color;
                stringArray4[1] = "Stone";
                stringArray = stringArray4;
                stringArray4[2] = "Shiny";
                break;
            }
            case "Gray": {
                String[] stringArray5 = new String[3];
                stringArray5[0] = this.color;
                stringArray5[1] = "Stone";
                stringArray = stringArray5;
                stringArray5[2] = "Metal";
                break;
            }
            case "Yellow": {
                String[] stringArray6 = new String[3];
                stringArray6[0] = this.color;
                stringArray6[1] = "Stone";
                stringArray = stringArray6;
                stringArray6[2] = "Alien";
                break;
            }
            case "Nether": {
                String[] stringArray7 = new String[3];
                stringArray7[0] = this.color;
                stringArray7[1] = "Stone";
                stringArray = stringArray7;
                stringArray7[2] = "Evil";
                break;
            }
            default: {
                String[] stringArray8 = new String[2];
                stringArray8[0] = this.color;
                stringArray = stringArray8;
                stringArray8[1] = "Stone";
            }
        }
        return stringArray;
    }

    @Override
    public List<String> getCropInformation() {
        ArrayList<String> information = new ArrayList<String>();
        switch (this.color) {
            case "Red": {
                information.add("Needs a Block of Red Granite or Granite(Non-GT) below to fully Mature");
                break;
            }
            case "Black": {
                information.add("Needs a Block of Black Granite or Basalt below to fully Mature");
                break;
            }
            case "White": {
                information.add("Needs a Block of Marble or Diorite below to fully Mature");
                break;
            }
            case "Gray": {
                information.add("Needs a Block of Cobblestone, Stone or Andesite below to fully Mature");
                break;
            }
            case "Yellow": {
                information.add("Needs a Block of Endstone, Sand or Sandstone below to fully Mature");
                break;
            }
            case "Nether": {
                information.add("Needs a Block of Netherrack or Netherbrick below to fully Mature");
            }
        }
        information.add("Has increased Nutrient requirements (x1.4)");
        information.add("Has decreased humidity and air requirements (x0.8)");
        return information;
    }

    public ItemStack getGain(ICropTile crop) {
        switch (this.color) {
            case "Red": {
                if (crop.isBlockBelow("stoneGraniteRed")) {
                    return Materials.GraniteRed.getDust(9);
                }
                if (!crop.isBlockBelow("blockGranite")) break;
                return CCropUtility.getCopiedOreStack("blockGranite");
            }
            case "Black": {
                if (crop.isBlockBelow("stoneGraniteBlack")) {
                    return Materials.GraniteBlack.getDust(9);
                }
                if (!crop.isBlockBelow("stoneBasalt")) break;
                return Materials.Basalt.getDust(9);
            }
            case "White": {
                if (crop.isBlockBelow("blockMarble")) {
                    return Materials.Marble.getDust(9);
                }
                if (!crop.isBlockBelow("blockDiorite")) break;
                return CCropUtility.getCopiedOreStack("blockDiorite");
            }
            case "Gray": {
                if (crop.isBlockBelow(Blocks.field_150347_e) || crop.isBlockBelow(Blocks.field_150348_b)) {
                    return Materials.Stone.getDust(9);
                }
                if (!crop.isBlockBelow("blockAndesite")) break;
                return CCropUtility.getCopiedOreStack("blockAndesite");
            }
            case "Yellow": {
                if (crop.isBlockBelow(Blocks.field_150377_bs)) {
                    return Materials.Endstone.getDust(2);
                }
                if (!crop.isBlockBelow((Block)Blocks.field_150354_m) && !crop.isBlockBelow(Blocks.field_150322_A)) break;
                return new ItemStack((Block)Blocks.field_150354_m, 4);
            }
            case "Nether": {
                if (!crop.isBlockBelow(Blocks.field_150424_aL) && !crop.isBlockBelow(Blocks.field_150385_bj)) break;
                return Materials.Netherrack.getDust(9);
            }
        }
        return null;
    }
}

