/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.network;

import com.brandon3055.brandonscore.common.utills.DataUtills;
import com.brandon3055.draconicevolution.common.container.ContainerDataSync;
import com.brandon3055.draconicevolution.common.tileentities.TileObjectSync;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;

public class TileObjectPacket
implements IMessage {
    int x;
    int y;
    int z;
    short index;
    short dataType = (short)-1;
    Object object;
    boolean isContainerPacket;

    public TileObjectPacket() {
    }

    public TileObjectPacket(TileObjectSync tile, byte dataType, int index, Object object) {
        boolean bl = this.isContainerPacket = tile == null;
        if (!this.isContainerPacket) {
            this.x = tile.field_145851_c;
            this.y = tile.field_145848_d;
            this.z = tile.field_145849_e;
        }
        this.dataType = dataType;
        this.object = object;
        this.index = (short)index;
    }

    public void toBytes(ByteBuf bytes) {
        bytes.writeBoolean(this.isContainerPacket);
        if (!this.isContainerPacket) {
            bytes.writeInt(this.x);
            bytes.writeInt(this.y);
            bytes.writeInt(this.z);
        }
        bytes.writeByte((int)this.dataType);
        bytes.writeShort((int)this.index);
        DataUtills.instance.writeObjectToBytes(bytes, (int)this.dataType, this.object);
    }

    public void fromBytes(ByteBuf bytes) {
        this.isContainerPacket = bytes.readBoolean();
        if (!this.isContainerPacket) {
            this.x = bytes.readInt();
            this.y = bytes.readInt();
            this.z = bytes.readInt();
        }
        this.dataType = bytes.readByte();
        this.index = bytes.readShort();
        this.object = DataUtills.instance.readObjectFromBytes(bytes, (int)this.dataType);
    }

    public static class Handler
    implements IMessageHandler<TileObjectPacket, IMessage> {
        public IMessage onMessage(TileObjectPacket message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                if (message.isContainerPacket) {
                    ContainerDataSync container;
                    ContainerDataSync containerDataSync = container = Minecraft.func_71410_x().field_71439_g.field_71070_bA instanceof ContainerDataSync ? (ContainerDataSync)Minecraft.func_71410_x().field_71439_g.field_71070_bA : null;
                    if (container == null) {
                        return null;
                    }
                    container.receiveSyncData(message.index, (Integer)message.object);
                } else {
                    if (!(Minecraft.func_71410_x().field_71441_e.func_147438_o(message.x, message.y, message.z) instanceof TileObjectSync)) {
                        return null;
                    }
                    ((TileObjectSync)Minecraft.func_71410_x().field_71441_e.func_147438_o(message.x, message.y, message.z)).receiveObjectFromServer(message.index, message.object);
                }
            } else if (message.isContainerPacket) {
                ContainerDataSync container;
                ContainerDataSync containerDataSync = container = ctx.getServerHandler().field_147369_b.field_71070_bA instanceof ContainerDataSync ? (ContainerDataSync)ctx.getServerHandler().field_147369_b.field_71070_bA : null;
                if (container == null) {
                    return null;
                }
                container.receiveSyncData(message.index, (Integer)message.object);
            } else {
                if (!(ctx.getServerHandler().field_147369_b.field_70170_p.func_147438_o(message.x, message.y, message.z) instanceof TileObjectSync)) {
                    return null;
                }
                ((TileObjectSync)ctx.getServerHandler().field_147369_b.field_70170_p.func_147438_o(message.x, message.y, message.z)).receiveObjectFromClient(message.index, message.object);
            }
            return null;
        }
    }
}

