/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.energynet;

import cofh.api.energy.IEnergyReceiver;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LinkedReceiver {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public int connectionSide;
    public int particleEnergyCounter = 0;
    public Block target = null;
    private double tBBXMin = -1.0;
    private double tBBXMax = -1.0;
    private double tBBYMin = -1.0;
    private double tBBYMax = -1.0;
    private double tBBZMin = -1.0;
    private double tBBZMax = -1.0;

    public LinkedReceiver() {
    }

    public LinkedReceiver(int xCoord, int yCoord, int zCoord, int connectionSide) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.connectionSide = connectionSide;
    }

    public boolean isStillValid(World world) {
        TileEntity tile = world.func_147438_o(this.xCoord, this.yCoord, this.zCoord);
        return tile instanceof IEnergyReceiver && ((IEnergyReceiver)tile).canConnectEnergy(ForgeDirection.getOrientation((int)this.connectionSide));
    }

    public IEnergyReceiver getReceiver(World world) {
        return this.isStillValid(world) ? (IEnergyReceiver)world.func_147438_o(this.xCoord, this.yCoord, this.zCoord) : null;
    }

    public int receiveEnergy(World world, int maxReceive, boolean simulate) {
        if (this.isStillValid(world)) {
            return this.getReceiver(world).receiveEnergy(ForgeDirection.getOrientation((int)this.connectionSide), maxReceive, simulate);
        }
        return 0;
    }

    public int getEnergyStored(World world) {
        if (this.isStillValid(world)) {
            return this.getReceiver(world).getEnergyStored(ForgeDirection.getOrientation((int)this.connectionSide));
        }
        return 0;
    }

    public int getMaxEnergyStored(World world) {
        if (this.isStillValid(world)) {
            return this.getReceiver(world).getMaxEnergyStored(ForgeDirection.getOrientation((int)this.connectionSide));
        }
        return 0;
    }

    public void updateTarget(World world) {
        this.target = world.func_147439_a(this.xCoord, this.yCoord, this.zCoord);
        this.tBBXMin = this.target.func_149704_x();
        this.tBBXMax = this.target.func_149704_x();
        this.tBBYMin = this.target.func_149704_x();
        this.tBBYMax = this.target.func_149704_x();
        this.tBBZMin = this.target.func_149704_x();
        this.tBBZMax = this.target.func_149704_x();
    }

    public void writeToNBT(NBTTagCompound compound, String tag) {
        compound.func_74768_a(tag + "_XCoord", this.xCoord);
        compound.func_74768_a(tag + "_YCoord", this.yCoord);
        compound.func_74768_a(tag + "_ZCoord", this.zCoord);
        compound.func_74768_a(tag + "_Side", this.connectionSide);
    }

    public void readFromNBT(NBTTagCompound compound, String tag) {
        this.xCoord = compound.func_74762_e(tag + "_XCoord");
        this.yCoord = compound.func_74762_e(tag + "_YCoord");
        this.zCoord = compound.func_74762_e(tag + "_ZCoord");
        this.connectionSide = compound.func_74762_e(tag + "_Side");
    }
}

