/*
 * Decompiled with CFR 0.152.
 */
package emt.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thaumcraft.common.Thaumcraft;

public class EntityEnergyBall
extends Entity
implements IProjectile,
IEntityAdditionalSpawnData {
    public static final int RADIUS = 8;
    public static final int MAX_TICKS_IN_TILE = 60;
    public EntityLivingBase shootingEntity;
    public boolean inTile = false;
    public int ticksAlive = 1;
    public int ticksInAir = 1;
    public double accelerationX = 0.0;
    public double accelerationY = 0.0;
    public double accelerationZ = 0.0;

    public EntityEnergyBall(World world, EntityLivingBase shootingEntity, double rotX, double rotY, double rotZ) {
        this(world, shootingEntity);
        double len = MathHelper.func_76133_a((double)((rotX += this.field_70146_Z.nextGaussian() * 0.4) * rotX + (rotY += this.field_70146_Z.nextGaussian() * 0.4) * rotY + (rotZ += this.field_70146_Z.nextGaussian() * 0.4) * rotZ));
        this.accelerationX = rotX / len * 0.1;
        this.accelerationY = rotY / len * 0.1;
        this.accelerationZ = rotZ / len * 0.1;
    }

    public EntityEnergyBall(World world, EntityLivingBase shootingEntity) {
        this(world);
        this.shootingEntity = shootingEntity;
        this.func_70012_b(shootingEntity.field_70165_t, shootingEntity.field_70163_u + (double)shootingEntity.func_70047_e(), shootingEntity.field_70161_v, shootingEntity.field_70177_z, shootingEntity.field_70125_A);
    }

    public EntityEnergyBall(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70158_ak = true;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeDouble(this.accelerationX);
        buffer.writeDouble(this.accelerationY);
        buffer.writeDouble(this.accelerationZ);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.accelerationX = buffer.readDouble();
        this.accelerationY = buffer.readDouble();
        this.accelerationZ = buffer.readDouble();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.inTile) {
            ++this.ticksAlive;
            if (this.ticksAlive >= 60) {
                this.func_70106_y();
            }
            ArrayList<Entity> entities = new ArrayList<Entity>();
            int chunkSize = 2;
            for (int chX = -chunkSize; chX < chunkSize; ++chX) {
                for (int chZ = -chunkSize; chZ < chunkSize; ++chZ) {
                    Chunk chunk = this.field_70170_p.func_72964_e(chX + (int)(this.field_70165_t / 16.0), chZ + (int)(this.field_70161_v / 16.0));
                    if (!chunk.field_76636_d || !chunk.field_76644_m) continue;
                    for (int i = 0; i < chunk.field_76645_j.length; ++i) {
                        for (int k = 0; k < chunk.field_76645_j[i].size(); ++k) {
                            Entity entity = (Entity)chunk.field_76645_j[i].get(k);
                            double width = entity.field_70165_t - this.field_70165_t;
                            double length = entity.field_70161_v - this.field_70161_v;
                            double height = entity.field_70163_u - this.field_70163_u;
                            double hyp = MathHelper.func_76133_a((double)(width * width + length * length + height * height));
                            if (!(hyp <= 8.0)) continue;
                            entities.add(entity);
                            entity.func_70097_a(DamageSource.field_76376_m, (float)(8.0 - hyp));
                            if (!this.field_70170_p.field_72995_K) continue;
                            Thaumcraft.proxy.bolt(this.field_70170_p, (Entity)this, entity);
                        }
                    }
                }
            }
        } else {
            Vec3 vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 vec3next = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition mop = this.field_70170_p.func_72933_a(vec3, vec3next);
            ++this.ticksInAir;
            if (mop != null) {
                this.inTile = true;
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) + 90.0f;
            this.field_70125_A = (float)(Math.atan2(f1, this.field_70181_x) * 180.0 / Math.PI) - 90.0f;
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            double factor = this.getMotionFactor();
            this.field_70159_w += this.accelerationX;
            this.field_70181_x += this.accelerationY;
            this.field_70179_y += this.accelerationZ;
            this.field_70159_w *= factor;
            this.field_70181_x *= factor;
            this.field_70179_y *= factor;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        for (int i = 0; i < 3 && this.field_70170_p.field_72995_K; ++i) {
            float rndX = (float)((double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 2.0f * 4.0f) + this.field_70165_t);
            float rndY = (float)((double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 2.0f * 4.0f) + this.field_70163_u);
            float rndZ = (float)((double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 2.0f * 4.0f) + this.field_70161_v);
            Thaumcraft.proxy.nodeBolt(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, rndX, rndY, rndZ);
        }
    }

    protected float getMotionFactor() {
        return 0.85f;
    }

    public boolean func_70067_L() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 240;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    protected void func_70088_a() {
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74774_a("inTile", (byte)(this.inTile ? 1 : 0));
        nbt.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
    }

    public void func_70037_a(NBTTagCompound nbt) {
        if (!this.inTile) {
            boolean bl = this.inTile = nbt.func_74771_c("inTile") == 1;
        }
        if (nbt.func_150297_b("direction", 9)) {
            NBTTagList nbttaglist = nbt.func_150295_c("direction", 6);
            this.field_70159_w = nbttaglist.func_150309_d(0);
            this.field_70181_x = nbttaglist.func_150309_d(1);
            this.field_70179_y = nbttaglist.func_150309_d(2);
        } else {
            this.func_70106_y();
        }
    }

    public void func_70186_c(double x, double y, double z, float p1, float p2) {
    }
}

