/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.api.common.util.IProgressTile;
import crazypants.enderio.machine.AbstractPowerConsumerEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.PoweredTask;
import crazypants.enderio.machine.PoweredTaskProgress;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.power.IInternalPowerReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractPoweredTaskEntity
extends AbstractPowerConsumerEntity
implements IInternalPowerReceiver,
IProgressTile {
    protected IPoweredTask currentTask = null;
    protected IMachineRecipe lastCompletedRecipe;
    protected IMachineRecipe cachedNextRecipe;
    protected final Random random = new Random();
    protected int ticksSinceCheckedRecipe = 0;
    protected boolean startFailed = false;
    protected float nextChance = Float.NaN;

    public AbstractPoweredTaskEntity(SlotDefinition slotDefinition) {
        super(slotDefinition);
    }

    @Override
    public int[] func_94128_d(int var1) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)var1);
        IoMode mode = this.getIoMode(dir);
        if (mode == IoMode.DISABLED) {
            return new int[0];
        }
        int[] res = new int[this.inventory.length - this.slotDefinition.getNumUpgradeSlots()];
        int index = 0;
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.slotDefinition.isUpgradeSlot(i)) continue;
            res[index] = i;
            ++index;
        }
        return res;
    }

    @Override
    public boolean isActive() {
        return this.currentTask == null ? false : this.currentTask.getProgress() >= 0.0f && this.hasPower() && this.redstoneCheckPassed;
    }

    public float getProgress() {
        return this.currentTask == null ? -1.0f : this.currentTask.getProgress();
    }

    public TileEntity getTileEntity() {
        return this;
    }

    public void setProgress(float progress) {
        this.currentTask = progress < 0.0f ? null : new PoweredTaskProgress(progress);
    }

    public IPoweredTask getCurrentTask() {
        return this.currentTask;
    }

    public float getExperienceForOutput(ItemStack output) {
        if (this.lastCompletedRecipe == null) {
            return 0.0f;
        }
        return this.lastCompletedRecipe.getExperienceForOutput(output);
    }

    public boolean getRedstoneChecksPassed() {
        return this.redstoneCheckPassed;
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        IMachineRecipe nextRecipe;
        if (!redstoneChecksPassed) {
            return false;
        }
        boolean requiresClientSync = false;
        requiresClientSync |= this.checkProgress(redstoneChecksPassed);
        if (this.currentTask != null || !this.hasPower() || !this.hasInputStacks()) {
            return requiresClientSync;
        }
        if (this.startFailed) {
            ++this.ticksSinceCheckedRecipe;
            if (this.ticksSinceCheckedRecipe < 20) {
                return false;
            }
        }
        this.ticksSinceCheckedRecipe = 0;
        if (Float.isNaN(this.nextChance)) {
            this.nextChance = this.random.nextFloat();
        }
        if ((nextRecipe = this.canStartNextTask(this.nextChance)) != null) {
            boolean started = this.startNextTask(nextRecipe, this.nextChance);
            if (started) {
                this.nextChance = Float.NaN;
            }
            this.startFailed = !started;
        } else {
            this.startFailed = true;
        }
        this.sendTaskProgressPacket();
        return requiresClientSync;
    }

    protected boolean checkProgress(boolean redstoneChecksPassed) {
        if (this.currentTask == null || !this.hasPower()) {
            return false;
        }
        if (redstoneChecksPassed && !this.currentTask.isComplete()) {
            this.usePower();
        }
        if (this.currentTask.isComplete()) {
            this.taskComplete();
            return false;
        }
        return false;
    }

    protected double usePower() {
        return this.usePower(this.getPowerUsePerTick());
    }

    public int usePower(int wantToUse) {
        int used = Math.min(this.getEnergyStored(), wantToUse);
        this.setEnergyStored(Math.max(0, this.getEnergyStored() - used));
        if (this.currentTask != null) {
            this.currentTask.update(used);
        }
        return used;
    }

    protected void taskComplete() {
        if (this.currentTask != null) {
            this.lastCompletedRecipe = this.currentTask.getRecipe();
            IMachineRecipe.ResultStack[] output = this.currentTask.getCompletedResult();
            if (output != null && output.length > 0) {
                this.mergeResults(output);
            }
        }
        this.func_70296_d();
        this.currentTask = null;
        this.lastProgressScaled = 0;
    }

    protected void mergeResults(IMachineRecipe.ResultStack[] results) {
        ArrayList<ItemStack> outputStacks = new ArrayList<ItemStack>(this.slotDefinition.getNumOutputSlots());
        if (this.slotDefinition.getNumOutputSlots() > 0) {
            for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
                ItemStack it = this.inventory[i];
                if (it != null) {
                    it = it.func_77946_l();
                }
                outputStacks.add(it);
            }
        }
        for (IMachineRecipe.ResultStack result : results) {
            if (result.item != null) {
                int numMerged = this.mergeItemResult(result.item, outputStacks);
                if (numMerged <= 0) continue;
                result.item.field_77994_a -= numMerged;
                continue;
            }
            if (result.fluid == null) continue;
            this.mergeFluidResult(result);
        }
        if (this.slotDefinition.getNumOutputSlots() > 0) {
            int listIndex = 0;
            for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
                ItemStack st = (ItemStack)outputStacks.get(listIndex);
                if (st != null) {
                    st = st.func_77946_l();
                }
                this.inventory[i] = st;
                ++listIndex;
            }
        }
        this.cachedNextRecipe = null;
    }

    protected void mergeFluidResult(IMachineRecipe.ResultStack result) {
    }

    protected void drainInputFluid(MachineRecipeInput fluid) {
    }

    protected boolean canInsertResultFluid(IMachineRecipe.ResultStack fluid) {
        return false;
    }

    protected int mergeItemResult(ItemStack item, List<ItemStack> outputStacks) {
        ItemStack copy = item.func_77946_l();
        for (ItemStack outStack : outputStacks) {
            if (outStack == null || copy == null) continue;
            int num = this.getNumCanMerge(outStack, copy);
            outStack.field_77994_a += num;
            copy.field_77994_a -= num;
            if (copy.field_77994_a > 0) continue;
            return item.field_77994_a;
        }
        for (int i = 0; i < outputStacks.size(); ++i) {
            ItemStack outStack;
            outStack = outputStacks.get(i);
            if (outStack != null) continue;
            outputStacks.set(i, copy);
            return item.field_77994_a;
        }
        return 0;
    }

    protected MachineRecipeInput[] getRecipeInputs() {
        MachineRecipeInput[] res = new MachineRecipeInput[this.slotDefinition.getNumInputSlots()];
        int fromSlot = this.slotDefinition.minInputSlot;
        for (int i = 0; i < res.length; ++i) {
            res[i] = new MachineRecipeInput(fromSlot, this.inventory[fromSlot]);
            ++fromSlot;
        }
        return res;
    }

    protected IMachineRecipe getNextRecipe() {
        if (this.cachedNextRecipe == null) {
            this.cachedNextRecipe = MachineRecipeRegistry.instance.getRecipeForInputs(this.getMachineName(), this.getRecipeInputs());
        }
        return this.cachedNextRecipe;
    }

    protected IMachineRecipe canStartNextTask(float chance) {
        IMachineRecipe nextRecipe = this.getNextRecipe();
        if (nextRecipe == null) {
            return null;
        }
        return this.canInsertResult(chance, nextRecipe) ? nextRecipe : null;
    }

    protected boolean canInsertResult(float chance, IMachineRecipe nextRecipe) {
        IMachineRecipe.ResultStack[] nextResults = nextRecipe.getCompletedResult(chance, this.getRecipeInputs());
        ArrayList<ItemStack> outputStacks = new ArrayList<ItemStack>(this.slotDefinition.getNumOutputSlots());
        if (this.slotDefinition.getNumOutputSlots() > 0) {
            boolean allFull = true;
            for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
                ItemStack st = this.inventory[i];
                if (st != null) {
                    st = st.func_77946_l();
                    if (allFull && st.field_77994_a < st.func_77976_d()) {
                        allFull = false;
                    }
                } else {
                    allFull = false;
                }
                outputStacks.add(st);
            }
            if (allFull) {
                return false;
            }
        }
        for (IMachineRecipe.ResultStack result : nextResults) {
            if (!(result.item != null ? this.mergeItemResult(result.item, outputStacks) == 0 : result.fluid != null && !this.canInsertResultFluid(result))) continue;
            return false;
        }
        return true;
    }

    protected boolean hasInputStacks() {
        int fromSlot = this.slotDefinition.minInputSlot;
        for (int i = 0; i < this.slotDefinition.getNumInputSlots(); ++i) {
            if (this.inventory[fromSlot] != null) {
                return true;
            }
            ++fromSlot;
        }
        return false;
    }

    protected int getNumCanMerge(ItemStack itemStack, ItemStack result) {
        if (!itemStack.func_77969_a(result)) {
            return 0;
        }
        return Math.min(itemStack.func_77976_d() - itemStack.field_77994_a, result.field_77994_a);
    }

    protected boolean startNextTask(IMachineRecipe nextRecipe, float chance) {
        if (this.hasPower() && nextRecipe.isRecipe(this.getRecipeInputs())) {
            this.currentTask = this.createTask(nextRecipe, chance);
            List<MachineRecipeInput> consumed = nextRecipe.getQuantitiesConsumed(this.getRecipeInputs());
            for (MachineRecipeInput item : consumed) {
                if (item == null) continue;
                if (item.item != null && item.item.field_77994_a > 0) {
                    this.func_70298_a(item.slotNumber, item.item.field_77994_a);
                    continue;
                }
                if (item.fluid == null) continue;
                this.drainInputFluid(item);
            }
            return true;
        }
        return false;
    }

    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        return new PoweredTask(nextRecipe, chance, this.getRecipeInputs());
    }

    protected IPoweredTask createTask(NBTTagCompound taskTagCompound) {
        return PoweredTask.readFromNBT(taskTagCompound);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.currentTask = nbtRoot.func_74764_b("currentTask") ? this.createTask(nbtRoot.func_74775_l("currentTask")) : null;
        String uid = nbtRoot.func_74779_i("lastCompletedRecipe");
        this.lastCompletedRecipe = MachineRecipeRegistry.instance.getRecipeForUid(uid);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        if (this.currentTask != null) {
            NBTTagCompound currentTaskNBT = new NBTTagCompound();
            this.currentTask.writeToNBT(currentTaskNBT);
            nbtRoot.func_74782_a("currentTask", (NBTBase)currentTaskNBT);
        }
        if (this.lastCompletedRecipe != null) {
            nbtRoot.func_74778_a("lastCompletedRecipe", this.lastCompletedRecipe.getUid());
        }
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        this.cachedNextRecipe = null;
    }

    @Override
    public ItemStack func_70298_a(int fromSlot, int amount) {
        ItemStack res = super.func_70298_a(fromSlot, amount);
        if (this.slotDefinition.isInputSlot(fromSlot)) {
            this.cachedNextRecipe = null;
        }
        return res;
    }

    @Override
    public void func_70299_a(int slot, ItemStack contents) {
        super.func_70299_a(slot, contents);
        if (this.slotDefinition.isInputSlot(slot)) {
            this.cachedNextRecipe = null;
        }
    }
}

